/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.asm;

import com.laytonsmith.core.asm.AsmUtil;
import com.laytonsmith.core.asm.IRType;
import com.laytonsmith.core.asm.LLVMEnvironment;
import com.laytonsmith.core.asm.LLVMFunction;
import com.laytonsmith.core.asm.metadata.IRMetadata;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IRBuilder {
    Set<LLVMFunction> functionsUsed = new HashSet<LLVMFunction>();
    List<String> lines = new ArrayList<String>();
    List<Target> targets = new ArrayList<Target>();
    List<String> metadata = new ArrayList<String>();

    public void appendLine(Target t, String line) {
        this.lines.add(line);
        this.targets.add(t);
    }

    public void appendLines(Target t, String ... lines) {
        for (String line : lines) {
            this.appendLine(t, line);
        }
    }

    public void appendLines(Target t, List<String> lines) {
        for (String line : lines) {
            this.appendLine(t, line);
        }
    }

    public String renderStartupCode(Environment env) {
        StringBuilder b = new StringBuilder();
        LLVMEnvironment llvmenv = env.getEnv(LLVMEnvironment.class);
        IRBuilder newBuilder = new IRBuilder();
        for (LLVMFunction f : this.functionsUsed) {
            Target t = new Target(0, new File("/" + f.getName() + " startup code"), 0);
            f.addStartupCode(newBuilder, env, t);
        }
        return newBuilder.renderIR(env);
    }

    public String renderIR(Environment env) {
        StringBuilder b = new StringBuilder();
        LLVMEnvironment llvmenv = env.getEnv(LLVMEnvironment.class);
        int padding = 0;
        if (llvmenv.isOutputIRCodeTargetLoggingEnabled()) {
            for (String line : this.lines) {
                padding = Math.max(padding, line.length());
            }
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            String line;
            line = this.lines.get(i);
            Target t = this.targets.get(i);
            b.append(AsmUtil.formatLine(t, llvmenv, line, padding + 2));
        }
        return b.toString();
    }

    public void setFinalMetadata(Environment env) {
        Set<IRMetadata> metadataRefs = env.getEnv(LLVMEnvironment.class).getMetadataRegistry().getAllMetadata();
        for (IRMetadata d : metadataRefs) {
            this.metadata.add(d.getDefinition());
        }
    }

    public Gen generator(Target t, Environment env) {
        return new Gen(t, env);
    }

    public class Gen {
        Target t;
        Environment env;
        LLVMEnvironment llvmenv;

        Gen(Target t, Environment env) {
            this.t = t;
            this.env = env;
            this.llvmenv = env.getEnv(LLVMEnvironment.class);
        }

        public void alloca(int id, IRType type) {
            IRBuilder.this.appendLine(this.t, "%" + id + " = alloca " + type.getIRType());
        }

        public void store(IRType type, int id, int into) {
            this.store(type, type.getIRType() + " %" + id, into);
        }

        public void store(IRType type, String value, int into) {
            IRBuilder.this.appendLine(this.t, "store " + value + ", " + type.getIRType() + "* %" + into);
        }

        public void allocaAndStore(int allocaId, IRType type, int storeId) {
            this.alloca(allocaId, type);
            this.store(type, storeId, allocaId);
        }

        public void allocaAndStore(int allocaId, IRType type, String storeValue) {
            this.alloca(allocaId, type);
            this.store(type, storeValue, allocaId);
        }

        public void load(int loadInto, IRType type, int allocaId) {
            IRBuilder.this.appendLine(this.t, "%" + loadInto + " = load " + type.getIRType() + ", " + type.getIRType() + "* %" + allocaId);
        }

        public int allocaStoreAndLoad(int allocaId, IRType type, int storeId, int loadId) {
            this.allocaAndStore(allocaId, type, storeId);
            this.load(loadId, type, allocaId);
            return loadId;
        }

        public int allocaStoreAndLoad(int allocaId, IRType type, String storeValue, int loadId) {
            this.allocaAndStore(allocaId, type, storeValue);
            this.load(loadId, type, allocaId);
            return loadId;
        }
    }
}

