/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen.localization;

import com.laytonsmith.PureUtilities.Common.MutableObject;
import com.laytonsmith.PureUtilities.SAXDocument;
import com.laytonsmith.tools.docgen.localization.Locale;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.SAXException;

public class TranslationMemory
implements Comparable<TranslationMemory> {
    private static final String BEGIN_BLOCK = "<translations>\n<comment></comment>\n";
    private static final String END_BLOCK = "</translations>\n";
    private final int translationId;
    private final String englishKey;
    private final Locale locale;
    private String comment;
    private String translation;
    private String automaticTranslation;

    public TranslationMemory(String englishKey, Locale locale, String comment, String translation, String automaticTranslation, int id) {
        this.englishKey = englishKey;
        this.locale = locale;
        this.comment = comment;
        this.translation = translation;
        this.automaticTranslation = automaticTranslation;
        if (id <= 0) {
            throw new IllegalArgumentException("id must be above 0!");
        }
        this.translationId = id;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setTranslation(String translation) {
        this.translation = translation;
    }

    public void setAutomaticTranslation(String automaticTranslation) {
        this.automaticTranslation = automaticTranslation;
    }

    public String getEnglishKey() {
        return this.englishKey;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getComment() {
        return this.comment;
    }

    public int getId() {
        return this.translationId;
    }

    public String getMachineTranslation() {
        return this.automaticTranslation;
    }

    public String getTranslation() {
        return this.translation;
    }

    public String toString() {
        return "(" + String.valueOf((Object)this.locale) + ") " + this.englishKey + " ------> " + this.translation;
    }

    public String toTmemString() {
        StringBuilder b = new StringBuilder();
        b.append("<translationBlock>\n");
        b.append("\t<id>").append(this.locale.getLocale()).append("-").append(this.translationId).append("</id>\n");
        b.append("\t<key>").append(this.escape(this.englishKey)).append("</key>\n");
        b.append("\t<comment>").append(this.escape(this.comment)).append("</comment>\n");
        b.append("\t<translation>").append(this.escape(this.translation)).append("</translation>\n");
        b.append("\t<auto>").append(this.escape(this.automaticTranslation)).append("</auto>\n");
        b.append("</translationBlock>\n");
        return b.toString();
    }

    private String escape(String input) {
        if (input == null || "".equals(input)) {
            return "";
        }
        input = input.replace("]]>", "]]]]><![CDATA[>");
        return "<![CDATA[" + input + "]]>";
    }

    public static String generateTranslationFile(Map<String, TranslationMemory> memories) {
        StringBuilder b = new StringBuilder();
        ArrayList<TranslationMemory> values2 = new ArrayList<TranslationMemory>(memories.values());
        Collections.sort(values2);
        for (TranslationMemory tm : values2) {
            b.append(tm.toTmemString());
        }
        return BEGIN_BLOCK + b.toString() + END_BLOCK;
    }

    public static Map<String, TranslationMemory> fromTmemFile(Locale locale, String fileContents) throws IOException {
        HashMap<String, TranslationMemory> memories = new HashMap<String, TranslationMemory>();
        if ("".equals(fileContents)) {
            return memories;
        }
        SAXDocument sax = new SAXDocument(fileContents, "UTF-8");
        MutableObject id = new MutableObject();
        MutableObject key = new MutableObject();
        MutableObject comment = new MutableObject();
        MutableObject translation = new MutableObject();
        MutableObject automaticTranslation = new MutableObject();
        MutableObject overrideMaster = new MutableObject();
        sax.addListener("/translations/translationBlock/id", (xpath, tag, attr, contents) -> id.setObject(contents));
        sax.addListener("/translations/translationBlock/key", (xpath, tag, attr, contents) -> key.setObject(contents));
        sax.addListener("/translations/translationBlock/comment", (xpath, tag, attr, contents) -> comment.setObject(contents));
        sax.addListener("/translations/translationBlock/translation", (xpath, tag, attr, contents) -> translation.setObject(contents));
        sax.addListener("/translations/translationBlock/auto", (xpath, tag, attr, contents) -> automaticTranslation.setObject(contents));
        sax.addListener("/translations/translationBlock/overrideMaster", (xpath, tag, attr, contents) -> overrideMaster.setObject(Boolean.valueOf(contents)));
        sax.addListener("/translations/translationBlock", (xpath, tag, attr, contents) -> {
            int intId = Integer.parseInt(((String)id.getObject()).replaceAll(locale.getLocale() + "-(.*)", "$1"));
            TranslationMemory tm = new TranslationMemory((String)key.getObject(), locale, (String)comment.getObject(), (String)translation.getObject(), (String)automaticTranslation.getObject(), intId);
            memories.put((String)key.getObject(), tm);
            id.setObject(null);
            key.setObject(null);
            comment.setObject(null);
            translation.setObject(null);
            automaticTranslation.setObject(null);
            overrideMaster.setObject(null);
        });
        try {
            sax.parse();
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
        return memories;
    }

    @Override
    public int compareTo(TranslationMemory t) {
        return Integer.compare(this.translationId, t.translationId);
    }
}

