/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.VirtualFS;

import com.laytonsmith.PureUtilities.Common.Annotations.ForceImplementation;
import com.laytonsmith.PureUtilities.VirtualFS.VirtualFile;
import com.laytonsmith.PureUtilities.VirtualFS.VirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public abstract class FileSystemLayer {
    protected final VirtualFile path;
    protected final VirtualFileSystem fileSystem;

    @ForceImplementation
    protected FileSystemLayer(VirtualFile path, VirtualFileSystem fileSystem, String symlink) {
        this.path = path;
        this.fileSystem = fileSystem;
    }

    public abstract InputStream getInputStream() throws IOException;

    public abstract void writeByteArray(byte[] var1) throws IOException;

    public abstract VirtualFile[] listFiles() throws IOException;

    public abstract void delete() throws IOException;

    public abstract void deleteEventually() throws IOException;

    public abstract boolean exists() throws IOException;

    public abstract boolean canRead() throws IOException;

    public abstract boolean canWrite() throws IOException;

    public abstract boolean isDirectory() throws IOException;

    public abstract boolean isFile() throws IOException;

    public abstract void mkdirs() throws IOException;

    public abstract void createNewFile() throws IOException;

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface fslayer {
        public String value();
    }
}

