/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums;

import com.laytonsmith.annotations.MEnum;
import java.util.HashMap;
import java.util.Map;

@MEnum(value="com.commandhelper.ChatColor")
public enum MCChatColor {
    BLACK(0),
    DARK_BLUE(1),
    DARK_GREEN(2),
    DARK_AQUA(3),
    DARK_RED(4),
    DARK_PURPLE(5),
    GOLD(6),
    GRAY(7),
    DARK_GRAY(8),
    BLUE(9),
    GREEN(10),
    AQUA(11),
    RED(12),
    LIGHT_PURPLE(13),
    YELLOW(14),
    WHITE(15),
    RANDOM('k'),
    BOLD('l'),
    STRIKETHROUGH('m'),
    UNDERLINE('n'),
    ITALIC('o'),
    PLAIN_WHITE('r');

    private final char code;
    private static final Map<Character, MCChatColor> CHAR_COLORS;

    private MCChatColor(char code) {
        this.code = code;
    }

    private MCChatColor(int code) {
        this.code = Integer.toHexString(code).toLowerCase().charAt(0);
    }

    public char getChar() {
        return this.code;
    }

    public String toString() {
        return String.format("\u00a7%s", Character.valueOf(this.code));
    }

    public static MCChatColor getByChar(char code) {
        return CHAR_COLORS.get(Character.valueOf(code));
    }

    public static String fromRGBValue(String hexString) {
        if (hexString.length() > 7) {
            hexString = hexString.substring(0, 7);
        }
        if (!hexString.matches("(?i)^#[0-9A-F]{6}$")) {
            return null;
        }
        return "\u00a7x\u00a7" + String.join((CharSequence)"\u00a7", hexString.substring(1).split(""));
    }

    public static String stripColor(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("(?i)\u00a7[0-9A-Fklmnorx]", "");
    }

    static {
        CHAR_COLORS = new HashMap<Character, MCChatColor>();
        for (MCChatColor color2 : MCChatColor.values()) {
            CHAR_COLORS.put(Character.valueOf(color2.getChar()), color2);
        }
    }
}

