/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.json;

import com.laytonsmith.libs.com.google.gson.Gson;
import com.laytonsmith.libs.com.google.gson.GsonBuilder;
import com.laytonsmith.libs.com.google.gson.JsonElement;
import com.laytonsmith.libs.com.google.gson.JsonIOException;
import com.laytonsmith.libs.com.google.gson.JsonNull;
import com.laytonsmith.libs.com.google.gson.JsonParseException;
import com.laytonsmith.libs.com.google.gson.stream.JsonReader;
import com.laytonsmith.libs.com.google.gson.stream.JsonToken;
import com.laytonsmith.libs.com.google.gson.stream.JsonWriter;
import com.laytonsmith.libs.com.google.gson.stream.MalformedJsonException;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.json.adapters.CollectionTypeAdapter;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.json.adapters.EitherTypeAdapter;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.json.adapters.EnumTypeAdapter;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.json.adapters.MessageTypeAdapter;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.json.adapters.ThrowableTypeAdapter;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.json.adapters.TupleTypeAdapters;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.messages.CancelParams;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.messages.Message;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.messages.MessageIssue;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;

public class MessageJsonHandler {
    public static final JsonRpcMethod CANCEL_METHOD = JsonRpcMethod.notification("$/cancelRequest", new Type[]{CancelParams.class});
    private final Gson gson;
    private final Map<String, JsonRpcMethod> supportedMethods;
    private MethodProvider methodProvider;
    private static MessageJsonHandler toStringInstance;

    public MessageJsonHandler(Map<String, JsonRpcMethod> supportedMethods) {
        this.supportedMethods = supportedMethods;
        this.gson = this.getDefaultGsonBuilder().create();
    }

    public MessageJsonHandler(Map<String, JsonRpcMethod> supportedMethods, Consumer<GsonBuilder> configureGson) {
        this.supportedMethods = supportedMethods;
        GsonBuilder gsonBuilder = this.getDefaultGsonBuilder();
        configureGson.accept(gsonBuilder);
        this.gson = gsonBuilder.create();
    }

    public GsonBuilder getDefaultGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory(new CollectionTypeAdapter.Factory()).registerTypeAdapterFactory(new ThrowableTypeAdapter.Factory()).registerTypeAdapterFactory(new EitherTypeAdapter.Factory()).registerTypeAdapterFactory(new TupleTypeAdapters.TwoTypeAdapterFactory()).registerTypeAdapterFactory(new EnumTypeAdapter.Factory()).registerTypeAdapterFactory(new MessageTypeAdapter.Factory(this));
    }

    public Gson getGson() {
        return this.gson;
    }

    public JsonRpcMethod getJsonRpcMethod(String name) {
        JsonRpcMethod result = this.supportedMethods.get(name);
        if (result != null) {
            return result;
        }
        if (CANCEL_METHOD.getMethodName().equals(name)) {
            return CANCEL_METHOD;
        }
        return null;
    }

    public MethodProvider getMethodProvider() {
        return this.methodProvider;
    }

    public void setMethodProvider(MethodProvider methodProvider) {
        this.methodProvider = methodProvider;
    }

    public Message parseMessage(CharSequence input) throws JsonParseException {
        StringReader reader = new StringReader(input.toString());
        return this.parseMessage(reader);
    }

    public Message parseMessage(Reader input) throws JsonParseException {
        JsonReader jsonReader = new JsonReader(input);
        Message message = (Message)this.gson.fromJson(jsonReader, (Type)((Object)Message.class));
        if (message != null) {
            message.setJsonHandler(this);
            try {
                if (jsonReader.peek() != JsonToken.END_DOCUMENT) {
                    MessageIssue issue = new MessageIssue("JSON document was not fully consumed.", ResponseErrorCode.ParseError.getValue());
                    throw new MessageIssueException(message, issue);
                }
            }
            catch (MalformedJsonException e) {
                MessageIssue issue = new MessageIssue("Message could not be parsed.", ResponseErrorCode.ParseError.getValue(), e);
                throw new MessageIssueException(message, issue);
            }
            catch (IOException e) {
                throw new JsonIOException(e);
            }
        }
        return message;
    }

    public String serialize(Message message) {
        StringWriter writer = new StringWriter();
        this.serialize(message, writer);
        return writer.toString();
    }

    public void serialize(Message message, Writer output) throws JsonIOException {
        this.gson.toJson((Object)message, (Type)((Object)Message.class), output);
    }

    public String format(Object object) {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = null;
        try {
            jsonWriter = this.gson.newJsonWriter(writer);
            jsonWriter.setIndent("  ");
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
        if (object != null) {
            this.gson.toJson(object, object.getClass(), jsonWriter);
        } else {
            this.gson.toJson((JsonElement)JsonNull.INSTANCE, jsonWriter);
        }
        return writer.toString();
    }

    public static String toString(Object object) {
        if (toStringInstance == null) {
            toStringInstance = new MessageJsonHandler(Collections.emptyMap(), gsonBuilder -> gsonBuilder.setPrettyPrinting());
        }
        return MessageJsonHandler.toStringInstance.gson.toJson(object);
    }
}

