/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.laytonsmith.libs.com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Metadata about an artifact.")
public class BuildArtifact {
    @SerializedName(value="artifact")
    private String artifact = null;
    @SerializedName(value="buildId")
    private String buildId = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="date")
    private String date = null;
    @SerializedName(value="link")
    private String link = null;
    @SerializedName(value="fullLink")
    private String fullLink = null;
    @SerializedName(value="sha")
    private String sha = null;
    @SerializedName(value="commitDetails")
    private String commitDetails = null;
    @SerializedName(value="poisoned")
    private Boolean poisoned = null;

    public BuildArtifact artifact(String artifact) {
        this.artifact = artifact;
        return this;
    }

    @Schema(required=true, description="The artifact name.")
    public String getArtifact() {
        return this.artifact;
    }

    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }

    public BuildArtifact buildId(String buildId) {
        this.buildId = buildId;
        return this;
    }

    @Schema(required=true, description="The build id, i.e. \"build-123\".")
    public String getBuildId() {
        return this.buildId;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    public BuildArtifact name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="The full artifact name, i.e. \"build-123/artifact.jar\". This is what is used in the url to request the artifact.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BuildArtifact date(String date) {
        this.date = date;
        return this;
    }

    @Schema(required=true, description="The datetime when the artifact was built. yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public BuildArtifact link(String link) {
        this.link = link;
        return this;
    }

    @Schema(required=true, description="The path for the url, i.e. \"/builds/artifact/build-123%2Fartifact.jar\".")
    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public BuildArtifact fullLink(String fullLink) {
        this.fullLink = fullLink;
        return this;
    }

    @Schema(required=true, description="The full link to the artifact, including the host.")
    public String getFullLink() {
        return this.fullLink;
    }

    public void setFullLink(String fullLink) {
        this.fullLink = fullLink;
    }

    public BuildArtifact sha(String sha) {
        this.sha = sha;
        return this;
    }

    @Schema(required=true, description="The git sha hash of the commit that was used to make this build. May be an empty string, if the commit isn't known, never null.")
    public String getSha() {
        return this.sha;
    }

    public void setSha(String sha) {
        this.sha = sha;
    }

    public BuildArtifact commitDetails(String commitDetails) {
        this.commitDetails = commitDetails;
        return this;
    }

    @Schema(required=true, description="The git commit message of the commit used to make this build. May be an empty string, if the commit isn't known, never null.")
    public String getCommitDetails() {
        return this.commitDetails;
    }

    public void setCommitDetails(String commitDetails) {
        this.commitDetails = commitDetails;
    }

    public BuildArtifact poisoned(Boolean poisoned) {
        this.poisoned = poisoned;
        return this;
    }

    @Schema(required=true, description="A poisoned build shouldn't be recommended. This is a build that is known to have had problems, but was already published, and will not be taken down.")
    public Boolean isPoisoned() {
        return this.poisoned;
    }

    public void setPoisoned(Boolean poisoned) {
        this.poisoned = poisoned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildArtifact buildArtifact = (BuildArtifact)o;
        return Objects.equals(this.artifact, buildArtifact.artifact) && Objects.equals(this.buildId, buildArtifact.buildId) && Objects.equals(this.name, buildArtifact.name) && Objects.equals(this.date, buildArtifact.date) && Objects.equals(this.link, buildArtifact.link) && Objects.equals(this.fullLink, buildArtifact.fullLink) && Objects.equals(this.sha, buildArtifact.sha) && Objects.equals(this.commitDetails, buildArtifact.commitDetails) && Objects.equals(this.poisoned, buildArtifact.poisoned);
    }

    public int hashCode() {
        return Objects.hash(this.artifact, this.buildId, this.name, this.date, this.link, this.fullLink, this.sha, this.commitDetails, this.poisoned);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuildArtifact {\n");
        sb.append("    artifact: ").append(this.toIndentedString(this.artifact)).append("\n");
        sb.append("    buildId: ").append(this.toIndentedString(this.buildId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    link: ").append(this.toIndentedString(this.link)).append("\n");
        sb.append("    fullLink: ").append(this.toIndentedString(this.fullLink)).append("\n");
        sb.append("    sha: ").append(this.toIndentedString(this.sha)).append("\n");
        sb.append("    commitDetails: ").append(this.toIndentedString(this.commitDetails)).append("\n");
        sb.append("    poisoned: ").append(this.toIndentedString(this.poisoned)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

