/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.entities;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.abstraction.MCColor;
import com.laytonsmith.abstraction.MCLivingEntity;
import com.laytonsmith.abstraction.MCPotionData;
import com.laytonsmith.abstraction.MCProjectileSource;
import com.laytonsmith.abstraction.blocks.MCBlockProjectileSource;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCColor;
import com.laytonsmith.abstraction.bukkit.BukkitMCPotionData;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlockProjectileSource;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCEntity;
import com.laytonsmith.abstraction.entities.MCAreaEffectCloud;
import com.laytonsmith.abstraction.enums.MCParticle;
import com.laytonsmith.abstraction.enums.MCPotionType;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCParticle;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCPotionEffectType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCPotionType;
import com.laytonsmith.core.Static;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Particle;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;

public class BukkitMCAreaEffectCloud
extends BukkitMCEntity
implements MCAreaEffectCloud {
    AreaEffectCloud aec;

    public BukkitMCAreaEffectCloud(Entity aec) {
        super(aec);
        this.aec = (AreaEffectCloud)aec;
    }

    @Override
    public MCPotionData getBasePotionData() {
        return new BukkitMCPotionData(ReflectionUtils.invokeMethod(this.aec, "getBasePotionData"));
    }

    @Override
    public MCPotionType getBasePotionType() {
        PotionType type = this.aec.getBasePotionType();
        if (type == null) {
            return null;
        }
        return BukkitMCPotionType.valueOfConcrete(type);
    }

    @Override
    public MCColor getColor() {
        return BukkitMCColor.GetMCColor(this.aec.getColor());
    }

    @Override
    public List<MCLivingEntity.MCEffect> getCustomEffects() {
        ArrayList<MCLivingEntity.MCEffect> list = new ArrayList<MCLivingEntity.MCEffect>();
        for (PotionEffect pe : this.aec.getCustomEffects()) {
            list.add(new MCLivingEntity.MCEffect(BukkitMCPotionEffectType.valueOfConcrete(pe.getType()), pe.getAmplifier(), pe.getDuration(), pe.isAmbient(), pe.hasParticles(), pe.hasIcon()));
        }
        return list;
    }

    @Override
    public int getDuration() {
        return this.aec.getDuration();
    }

    @Override
    public int getDurationOnUse() {
        return this.aec.getDurationOnUse();
    }

    @Override
    public MCParticle getParticle() {
        return BukkitMCParticle.valueOfConcrete(this.aec.getParticle());
    }

    @Override
    public float getRadius() {
        return this.aec.getRadius();
    }

    @Override
    public float getRadiusOnUse() {
        return this.aec.getRadiusOnUse();
    }

    @Override
    public float getRadiusPerTick() {
        return this.aec.getRadiusPerTick();
    }

    @Override
    public int getReapplicationDelay() {
        return this.aec.getReapplicationDelay();
    }

    @Override
    public MCProjectileSource getSource() {
        ProjectileSource source = this.aec.getSource();
        if (source instanceof BlockProjectileSource) {
            return new BukkitMCBlockProjectileSource((BlockProjectileSource)source);
        }
        return (MCProjectileSource)((Object)BukkitConvertor.BukkitGetCorrectEntity((Entity)source));
    }

    @Override
    public int getWaitTime() {
        return this.aec.getWaitTime();
    }

    @Override
    public void addCustomEffect(MCLivingEntity.MCEffect effect) {
        int ticks = effect.getTicksRemaining();
        if (ticks < 0) {
            ticks = Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_19_4) ? -1 : Integer.MAX_VALUE;
        }
        PotionEffectType type = (PotionEffectType)effect.getPotionEffectType().getConcrete();
        PotionEffect pe = new PotionEffect(type, ticks, effect.getStrength(), effect.isAmbient(), effect.hasParticles(), effect.showIcon());
        this.aec.addCustomEffect(pe, true);
    }

    @Override
    public void clearCustomEffects() {
        this.aec.clearCustomEffects();
    }

    @Override
    public void setBasePotionData(MCPotionData pd) {
        ReflectionUtils.invokeMethod(this.aec, "setBasePotionData", pd.getHandle());
    }

    @Override
    public void setBasePotionType(MCPotionType type) {
        if (type == null) {
            this.aec.setBasePotionType(null);
        } else {
            this.aec.setBasePotionType((PotionType)type.getConcrete());
        }
    }

    @Override
    public void setColor(MCColor color2) {
        this.aec.setColor(BukkitMCColor.GetColor(color2));
    }

    @Override
    public void setDuration(int ticks) {
        this.aec.setDuration(ticks);
    }

    @Override
    public void setDurationOnUse(int ticks) {
        this.aec.setDurationOnUse(ticks);
    }

    @Override
    public void setParticle(MCParticle particle, Object data) {
        Particle type = (Particle)((BukkitMCParticle)particle).getConcrete();
        this.aec.setParticle(type, ((BukkitMCParticle)particle).getParticleData(this.getLocation(), data));
    }

    @Override
    public void setRadius(float radius) {
        this.aec.setRadius(radius);
    }

    @Override
    public void setRadiusOnUse(float radius) {
        this.aec.setRadiusOnUse(radius);
    }

    @Override
    public void setRadiusPerTick(float radius) {
        this.aec.setRadiusPerTick(radius);
    }

    @Override
    public void setReapplicationDelay(int ticks) {
        this.aec.setReapplicationDelay(ticks);
    }

    @Override
    public void setSource(MCProjectileSource source) {
        if (source == null) {
            this.aec.setSource(null);
        } else if (source instanceof MCBlockProjectileSource) {
            this.aec.setSource((ProjectileSource)((BlockProjectileSource)source.getHandle()));
        } else {
            this.aec.setSource((ProjectileSource)source.getHandle());
        }
    }

    @Override
    public void setWaitTime(int ticks) {
        this.aec.setWaitTime(ticks);
    }
}

