/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.pnviewer;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class ConfigurationLoaderDialog
extends JDialog {
    private LoaderDialogFinish finishAction = null;
    private JButton browseLocalFileButton;
    private JButton cancelButton;
    private JTextField hostField;
    private JLabel hostLabel;
    private JLabel jLabel1;
    private JSeparator jSeparator1;
    private JButton loadButton;
    private JTextField localFileField;
    private ButtonGroup localOrRemoteGroup;
    private JRadioButton localRadioButton;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JTextField portField;
    private JLabel portLabel;
    private JTextField remoteFileField;
    private JLabel remoteFileLabel;
    private JRadioButton remoteRadioButton;

    public ConfigurationLoaderDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setDefaultCloseOperation(1);
        this.setTitle("Load configuration...");
        this.setRemoteEnabled(false);
        ActionListener radioButtonChangedActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isLocal = false;
                if (ConfigurationLoaderDialog.this.localOrRemoteGroup.getSelection() == ConfigurationLoaderDialog.this.localRadioButton.getModel()) {
                    isLocal = true;
                }
                ConfigurationLoaderDialog.this.setLocalEnabled(isLocal);
                ConfigurationLoaderDialog.this.setRemoteEnabled(!isLocal);
            }
        };
        this.localRadioButton.addActionListener(radioButtonChangedActionListener);
        this.remoteRadioButton.addActionListener(radioButtonChangedActionListener);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigurationLoaderDialog.this.validateFields()) {
                    ConfigurationLoaderDialog.this.setVisible(false);
                    if (ConfigurationLoaderDialog.this.finishAction != null) {
                        if (ConfigurationLoaderDialog.this.localOrRemoteGroup.isSelected(ConfigurationLoaderDialog.this.localRadioButton.getModel())) {
                            ConfigurationLoaderDialog.this.finishAction.data(true, ConfigurationLoaderDialog.this.localFileField.getText(), "", 1, "", "");
                        } else {
                            ConfigurationLoaderDialog.this.finishAction.data(false, "", ConfigurationLoaderDialog.this.hostField.getText(), Integer.parseInt(ConfigurationLoaderDialog.this.portField.getText()), new String(ConfigurationLoaderDialog.this.passwordField.getPassword()), ConfigurationLoaderDialog.this.remoteFileField.getText());
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(ConfigurationLoaderDialog.this, ConfigurationLoaderDialog.this.getValidationError(), "Error", 0);
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationLoaderDialog.this.setVisible(false);
            }
        });
        this.registerShowFileLoader(this.localFileField, this.browseLocalFileButton);
        this.registerEnterHandler(this.loadButton, this.localFileField);
        this.registerEnterHandler(this.loadButton, this.hostField, this.portField, this.passwordField, this.remoteFileField);
    }

    private void registerShowFileLoader(final JTextField toPopulate, JButton browseButton) {
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showOpenDialog(ConfigurationLoaderDialog.this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    toPopulate.setText(file.getAbsolutePath());
                }
            }
        });
    }

    private void registerEnterHandler(final JButton button, JTextField ... fields) {
        for (JTextField field : fields) {
            field.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    button.doClick();
                }
            });
        }
    }

    private boolean validateFields() {
        return this.getValidationError() == null;
    }

    private String getValidationError() {
        if (this.localOrRemoteGroup.isSelected(this.localRadioButton.getModel())) {
            String localFile = this.localFileField.getText();
            if (!new File(localFile).exists()) {
                return "File specified doesn't exist.";
            }
        } else {
            int port;
            String host = this.hostField.getText();
            String sport = this.portField.getText();
            String remote = this.remoteFileField.getText().trim();
            try {
                new URI(host);
            }
            catch (URISyntaxException ex) {
                return ex.getMessage();
            }
            try {
                port = Integer.parseInt(sport);
            }
            catch (NumberFormatException ex) {
                return "Port must be a number.";
            }
            if (port < 1 || port > 65535) {
                return "Port must be between 1 and 65535";
            }
            if ("".equals(remote)) {
                return "No remote file specified.";
            }
        }
        return null;
    }

    private void setLocalEnabled(boolean state) {
        this.localFileField.setEnabled(state);
        this.browseLocalFileButton.setEnabled(state);
    }

    private void setRemoteEnabled(boolean state) {
        this.hostLabel.setEnabled(state);
        this.hostField.setEnabled(state);
        this.passwordLabel.setEnabled(state);
        this.passwordField.setEnabled(state);
        this.portLabel.setEnabled(state);
        this.portField.setEnabled(state);
        this.remoteFileLabel.setEnabled(state);
        this.remoteFileField.setEnabled(state);
    }

    public void setLoaderDialogFinish(LoaderDialogFinish finish) {
        this.finishAction = finish;
    }

    private void initComponents() {
        this.localOrRemoteGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.localRadioButton = new JRadioButton();
        this.localFileField = new JTextField();
        this.browseLocalFileButton = new JButton();
        this.remoteRadioButton = new JRadioButton();
        this.hostLabel = new JLabel();
        this.hostField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.jSeparator1 = new JSeparator();
        this.loadButton = new JButton();
        this.cancelButton = new JButton();
        this.portLabel = new JLabel();
        this.portField = new JTextField();
        this.remoteFileLabel = new JLabel();
        this.remoteFileField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Load Configuration from:");
        this.localOrRemoteGroup.add(this.localRadioButton);
        this.localRadioButton.setSelected(true);
        this.localRadioButton.setText("Local");
        this.browseLocalFileButton.setText("Browse...");
        this.localOrRemoteGroup.add(this.remoteRadioButton);
        this.remoteRadioButton.setText("Remote");
        this.hostLabel.setText("Host:");
        this.passwordLabel.setText("Password:");
        this.loadButton.setText("Load");
        this.cancelButton.setText("Cancel");
        this.portLabel.setText("Port:");
        this.remoteFileLabel.setText("Remote File:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.localFileField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseLocalFileButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostLabel).addComponent(this.portLabel)).addGap(54, 54, 54).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.portField).addComponent(this.hostField))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.passwordLabel).addGap(30, 30, 30)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.remoteFileLabel).addGap(18, 18, 18))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.remoteFileField).addComponent(this.passwordField))).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.localRadioButton).addComponent(this.jLabel1).addComponent(this.remoteRadioButton).addGroup(layout.createSequentialGroup().addComponent(this.loadButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addGap(0, 236, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.localRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.localFileField, -2, -1, -2).addComponent(this.browseLocalFileButton)).addGap(18, 18, 18).addComponent(this.remoteRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostLabel).addComponent(this.hostField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portLabel).addComponent(this.portField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordField, -2, -1, -2).addComponent(this.passwordLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.remoteFileField, -2, -1, -2).addComponent(this.remoteFileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ConfigurationLoaderDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigurationLoaderDialog dialog = new ConfigurationLoaderDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public static interface LoaderDialogFinish {
        public void data(boolean var1, String var2, String var3, int var4, String var5, String var6);
    }
}

