/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.events.prefilters;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.prefilters.PrefilterMatcher;
import com.laytonsmith.core.events.prefilters.StringPrefilterMatcher;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;

public abstract class MaterialPrefilterMatcher<T extends BindableEvent>
extends StringPrefilterMatcher<T> {
    @Override
    public PrefilterMatcher.PrefilterDocs getDocsObject() {
        return new MaterialPrefilterDocs();
    }

    @Override
    public void validate(ParseTree node, CClassType nodeType, Environment env) throws ConfigCompileException, ConfigCompileGroupException, ConfigRuntimeException {
        if (node.isConst() && !node.getData().equals(CNull.NULL)) {
            try {
                MCMaterial.MCVanillaMaterial.valueOf(node.getData().val());
            }
            catch (IllegalArgumentException ex) {
                env.getEnv(CompilerEnvironment.class).addCompilerWarning(node.getFileOptions(), new CompilerWarning("\"" + String.valueOf(node.getData()) + "\" is not a valid material type, this will never match. (This will eventually be a compile error)", node.getTarget(), null));
            }
        }
    }

    @Override
    protected String getProperty(T event) {
        MCMaterial material = this.getMaterial(event);
        if (material == null) {
            return null;
        }
        return material.getName();
    }

    protected abstract MCMaterial getMaterial(T var1);

    @Override
    public int getPriority() {
        return -1;
    }

    @api
    public static class MaterialPrefilterDocs
    implements PrefilterMatcher.PrefilterDocs {
        @Override
        public String getName() {
            return "material match";
        }

        @Override
        public String getNameWiki() {
            return "[[Prefilters#material match|Material Match]]";
        }

        @Override
        public String docs() {
            return "A material match is a simple string match against the list of materials in the game. For instance,\nSOUL_TORCH or STONE. Unlike a string match though, the compiler is aware of the material types, and\nwill be a compile error if the material doesn't exist.\n\n<%CODE|\n\tbind('player_interact', null, array(itemname: 'SOUL_TORCH', block: 'STONE'), @event) {\n\t\t# This code will run if a player clicks stone while holding a soul torch.\n\t}\n%>";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }
}

