/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.pnviewer;

import com.laytonsmith.PureUtilities.Common.UIUtils;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class ManageBookmarksDialog
extends JDialog {
    BookmarkList blist = new BookmarkList();
    private JList bookmarkList;
    private JButton deleteButton;
    private JTextField hostField;
    private JLabel hostLabel;
    private JScrollPane jScrollPane1;
    private JTextField localFileField;
    private JLabel localFileLabel;
    private ButtonGroup localOrRemoteGroup;
    private JRadioButton localRadioButton;
    private JTextField nameField;
    private JLabel nameLabel;
    private JButton newButton;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JTextField portField;
    private JLabel portLabel;
    private JTextField remoteFileField;
    private JLabel remoteFileLabel;
    private JRadioButton remoteRadioButton;
    private JButton saveButton;

    public ManageBookmarksDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setDefaultCloseOperation(2);
        ActionListener buttonGroupActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageBookmarksDialog.this.determineRadioButtons();
            }
        };
        this.localRadioButton.addActionListener(buttonGroupActionListener);
        this.remoteRadioButton.addActionListener(buttonGroupActionListener);
        this.setEnabledAll(false);
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageBookmarksDialog.this.setEnabledAll(true);
                Bookmark b = new Bookmark();
                b.name = "New Bookmark";
                ManageBookmarksDialog.this.populateFromBookmark(b);
                ManageBookmarksDialog.this.blist.addBookmark(b);
                ManageBookmarksDialog.this.bookmarkList.setListData(ManageBookmarksDialog.this.blist.getNameList());
                ManageBookmarksDialog.this.bookmarkList.setSelectedValue(b.name, true);
                ManageBookmarksDialog.this.nameField.requestFocus();
                ManageBookmarksDialog.this.nameField.setSelectionStart(0);
                ManageBookmarksDialog.this.nameField.setSelectionEnd(b.name.length());
            }
        });
    }

    private void determineRadioButtons() {
        boolean isLocal = this.localOrRemoteGroup.isSelected(this.localRadioButton.getModel());
        this.setEnabledLocal(isLocal);
        this.setEnabledRemote(!isLocal);
    }

    private void setEnabledAll(boolean enabled) {
        UIUtils.setEnabled(enabled, this.nameLabel, this.nameField, this.localRadioButton, this.localFileLabel, this.localFileField, this.remoteRadioButton, this.hostLabel, this.hostField, this.portLabel, this.portField, this.passwordLabel, this.passwordField, this.remoteFileLabel, this.remoteFileField, this.saveButton, this.deleteButton);
    }

    private void setEnabledLocal(boolean enabled) {
        UIUtils.setEnabled(enabled, this.localFileLabel, this.localFileField);
    }

    private void setEnabledRemote(boolean enabled) {
        UIUtils.setEnabled(enabled, this.hostLabel, this.hostField, this.portLabel, this.portField, this.passwordLabel, this.passwordField, this.remoteFileLabel, this.remoteFileField);
    }

    private void populateFromBookmark(Bookmark b) {
        this.localRadioButton.setSelected(b.isLocal);
        this.remoteRadioButton.setSelected(!b.isLocal);
        this.determineRadioButtons();
        this.nameField.setText(b.name);
        this.localFileField.setText(b.localFile);
        this.hostField.setText(b.host);
        this.portField.setText(b.port);
        this.passwordField.setText(b.password);
        this.remoteFileField.setText(b.remoteFile);
    }

    private void initComponents() {
        this.localOrRemoteGroup = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.bookmarkList = new JList();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.nameLabel = new JLabel();
        this.localRadioButton = new JRadioButton();
        this.localFileLabel = new JLabel();
        this.remoteRadioButton = new JRadioButton();
        this.hostLabel = new JLabel();
        this.portLabel = new JLabel();
        this.passwordLabel = new JLabel();
        this.remoteFileLabel = new JLabel();
        this.localFileField = new JTextField();
        this.hostField = new JTextField();
        this.portField = new JTextField();
        this.passwordField = new JPasswordField();
        this.remoteFileField = new JTextField();
        this.saveButton = new JButton();
        this.nameField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.jScrollPane1.setViewportView(this.bookmarkList);
        this.newButton.setText("New");
        this.deleteButton.setText("Delete");
        this.nameLabel.setText("Name");
        this.localOrRemoteGroup.add(this.localRadioButton);
        this.localRadioButton.setSelected(true);
        this.localRadioButton.setText("Local");
        this.localFileLabel.setText("Local File");
        this.localOrRemoteGroup.add(this.remoteRadioButton);
        this.remoteRadioButton.setText("Remote");
        this.hostLabel.setText("Host");
        this.portLabel.setText("Port");
        this.passwordLabel.setText("Password");
        this.remoteFileLabel.setText("Remote File");
        this.saveButton.setText("Save");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 144, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.localFileLabel).addGap(43, 43, 43).addComponent(this.localFileField, -1, 249, Short.MAX_VALUE)).addComponent(this.remoteRadioButton).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostLabel).addComponent(this.localRadioButton).addComponent(this.portLabel).addComponent(this.passwordLabel).addComponent(this.remoteFileLabel).addComponent(this.nameLabel)).addGap(29, 29, 29).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostField).addComponent(this.portField).addComponent(this.passwordField).addComponent(this.remoteFileField).addComponent(this.nameField))))).addGroup(layout.createSequentialGroup().addComponent(this.newButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.deleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.saveButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.localFileLabel).addComponent(this.localFileField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.remoteRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostLabel).addComponent(this.hostField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portLabel).addComponent(this.portField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.remoteFileLabel).addComponent(this.remoteFileField, -2, -1, -2)).addGap(0, 7, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newButton).addComponent(this.deleteButton).addComponent(this.saveButton)).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ManageBookmarksDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ManageBookmarksDialog dialog = new ManageBookmarksDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private static class BookmarkList {
        private final List<Bookmark> bookmarks = new ArrayList<Bookmark>();

        private BookmarkList() {
        }

        private void addBookmark(Bookmark b) {
            this.bookmarks.add(b);
        }

        private String[] getNameList() {
            Object[] ret = new String[this.bookmarks.size()];
            for (int i = 0; i < this.bookmarks.size(); ++i) {
                ret[i] = this.bookmarks.get((int)i).name;
            }
            Arrays.sort(ret);
            return ret;
        }

        private Bookmark getBookmark(String name) {
            for (Bookmark b : this.bookmarks) {
                if (!name.equals(b.name)) continue;
                return b;
            }
            return null;
        }
    }

    private static class Bookmark {
        public String name = "";
        public boolean isLocal = true;
        public String localFile = "";
        public String host = "";
        public String port = "";
        public String password = "";
        public String remoteFile = "";

        private Bookmark() {
        }
    }
}

