/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.redis.clients.jedis.params;

import com.laytonsmith.libs.redis.clients.jedis.CommandArguments;
import com.laytonsmith.libs.redis.clients.jedis.Protocol;
import com.laytonsmith.libs.redis.clients.jedis.StreamEntryID;
import com.laytonsmith.libs.redis.clients.jedis.args.Rawable;
import com.laytonsmith.libs.redis.clients.jedis.args.RawableFactory;
import com.laytonsmith.libs.redis.clients.jedis.params.IParams;

public class XAddParams
implements IParams {
    private Rawable id;
    private Long maxLen;
    private boolean approximateTrimming;
    private boolean exactTrimming;
    private boolean nomkstream;
    private String minId;
    private Long limit;

    public static XAddParams xAddParams() {
        return new XAddParams();
    }

    public XAddParams noMkStream() {
        this.nomkstream = true;
        return this;
    }

    public XAddParams id(byte[] id) {
        this.id = RawableFactory.from(id);
        return this;
    }

    public XAddParams id(String id) {
        this.id = RawableFactory.from(id);
        return this;
    }

    public XAddParams id(StreamEntryID id) {
        return this.id(id.toString());
    }

    public XAddParams id(long time2, long sequence2) {
        return this.id(time2 + "-" + sequence2);
    }

    public XAddParams id(long time2) {
        return this.id(time2 + "-*");
    }

    public XAddParams maxLen(long maxLen) {
        this.maxLen = maxLen;
        return this;
    }

    public XAddParams minId(String minId) {
        this.minId = minId;
        return this;
    }

    public XAddParams approximateTrimming() {
        this.approximateTrimming = true;
        return this;
    }

    public XAddParams exactTrimming() {
        this.exactTrimming = true;
        return this;
    }

    public XAddParams limit(long limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.nomkstream) {
            args.add(Protocol.Keyword.NOMKSTREAM);
        }
        if (this.maxLen != null) {
            args.add(Protocol.Keyword.MAXLEN);
            if (this.approximateTrimming) {
                args.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                args.add(Protocol.BYTES_EQUAL);
            }
            args.add(this.maxLen);
        } else if (this.minId != null) {
            args.add(Protocol.Keyword.MINID);
            if (this.approximateTrimming) {
                args.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                args.add(Protocol.BYTES_EQUAL);
            }
            args.add(this.minId);
        }
        if (this.limit != null) {
            args.add(Protocol.Keyword.LIMIT).add(this.limit);
        }
        args.add(this.id != null ? this.id : StreamEntryID.NEW_ENTRY);
    }
}

