/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.util;

import com.laytonsmith.libs.org.postgresql.util.GT;
import com.laytonsmith.libs.org.postgresql.util.PGobject;
import com.laytonsmith.libs.org.postgresql.util.PGtokenizer;
import com.laytonsmith.libs.org.postgresql.util.PSQLException;
import com.laytonsmith.libs.org.postgresql.util.PSQLState;
import java.io.Serializable;
import java.sql.SQLException;

public class PGmoney
extends PGobject
implements Serializable,
Cloneable {
    public double val;

    public PGmoney(double value) {
        this();
        this.val = value;
    }

    public PGmoney(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    public PGmoney() {
        this.setType("money");
    }

    @Override
    public void setValue(String s) throws SQLException {
        try {
            boolean negative = s.charAt(0) == '(';
            String s1 = PGtokenizer.removePara(s).substring(1);
            int pos = s1.indexOf(44);
            while (pos != -1) {
                s1 = s1.substring(0, pos) + s1.substring(pos + 1);
                pos = s1.indexOf(44);
            }
            this.val = Double.valueOf(s1);
            this.val = negative ? -this.val : this.val;
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr("Conversion of money failed."), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE, (Throwable)e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PGmoney) {
            PGmoney p2 = (PGmoney)obj;
            return this.val == p2.val;
        }
        return false;
    }

    @Override
    public String getValue() {
        if (this.val < 0.0) {
            return "-$" + -this.val;
        }
        return "$" + this.val;
    }
}

