/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence.io;

import com.laytonsmith.persistence.DataSource;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.io.ConnectionMixin;
import com.laytonsmith.persistence.io.ReadOnlyFileConnection;
import com.laytonsmith.persistence.io.ReadWriteFileConnection;
import com.laytonsmith.persistence.io.SSHConnection;
import com.laytonsmith.persistence.io.WebConnection;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Objects;
import java.util.Set;

public final class ConnectionMixinFactory {
    private ConnectionMixinFactory() {
    }

    public static ConnectionMixin GetConnectionMixin(URI uri, Set<DataSource.DataSourceModifier> modifiers, ConnectionMixinOptions options, String blankDataModel) throws DataSourceException {
        if (modifiers.contains(DataSource.DataSourceModifier.HTTP) || modifiers.contains(DataSource.DataSourceModifier.HTTPS)) {
            try {
                return new WebConnection(uri, !modifiers.contains(DataSource.DataSourceModifier.HTTP));
            }
            catch (MalformedURLException ex) {
                throw new DataSourceException("Malformed URL.", ex);
            }
        }
        if (modifiers.contains(DataSource.DataSourceModifier.SSH)) {
            return new SSHConnection(uri);
        }
        try {
            if (modifiers.contains(DataSource.DataSourceModifier.READONLY)) {
                return new ReadOnlyFileConnection(uri, options.workingDirectory, blankDataModel);
            }
            return new ReadWriteFileConnection(uri, options.workingDirectory, blankDataModel);
        }
        catch (IOException ex) {
            throw new DataSourceException("IOException: " + ex.getMessage(), ex);
        }
    }

    public static class ConnectionMixinOptions {
        File workingDirectory = null;

        public void setWorkingDirectory(File workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectionMixinOptions other = (ConnectionMixinOptions)obj;
            return Objects.equals(this.workingDirectory, other.workingDirectory);
        }

        public int hashCode() {
            int hash2 = 7;
            hash2 = 41 * hash2 + Objects.hashCode(this.workingDirectory);
            return hash2;
        }
    }
}

