/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.json.adapters;

import com.laytonsmith.libs.com.google.gson.Gson;
import com.laytonsmith.libs.com.google.gson.JsonParseException;
import com.laytonsmith.libs.com.google.gson.TypeAdapter;
import com.laytonsmith.libs.com.google.gson.TypeAdapterFactory;
import com.laytonsmith.libs.com.google.gson.reflect.TypeToken;
import com.laytonsmith.libs.com.google.gson.stream.JsonReader;
import com.laytonsmith.libs.com.google.gson.stream.JsonToken;
import com.laytonsmith.libs.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class ThrowableTypeAdapter
extends TypeAdapter<Throwable> {
    private final TypeToken<Throwable> typeToken;

    public ThrowableTypeAdapter(TypeToken<Throwable> typeToken) {
        this.typeToken = typeToken;
    }

    @Override
    public Throwable read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        in.beginObject();
        String message = null;
        Throwable cause = null;
        block11: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "message": {
                    message = in.nextString();
                    continue block11;
                }
                case "cause": {
                    cause = this.read(in);
                    continue block11;
                }
            }
            in.skipValue();
        }
        in.endObject();
        try {
            Constructor<Throwable> constructor;
            if (message == null && cause == null) {
                constructor = this.typeToken.getRawType().getDeclaredConstructor(new Class[0]);
                return constructor.newInstance(new Object[0]);
            }
            if (message == null) {
                constructor = this.typeToken.getRawType().getDeclaredConstructor(Throwable.class);
                return constructor.newInstance(cause);
            }
            if (cause == null) {
                constructor = this.typeToken.getRawType().getDeclaredConstructor(String.class);
                return constructor.newInstance(message);
            }
            constructor = this.typeToken.getRawType().getDeclaredConstructor(String.class, Throwable.class);
            return constructor.newInstance(message, cause);
        }
        catch (NoSuchMethodException e) {
            if (message == null && cause == null) {
                return new RuntimeException();
            }
            if (message == null) {
                return new RuntimeException(cause);
            }
            if (cause == null) {
                return new RuntimeException(message);
            }
            return new RuntimeException(message, cause);
        }
        catch (Exception e) {
            throw new JsonParseException(e);
        }
    }

    @Override
    public void write(JsonWriter out, Throwable throwable) throws IOException {
        if (throwable == null) {
            out.nullValue();
        } else if (throwable.getMessage() == null && throwable.getCause() != null) {
            this.write(out, throwable.getCause());
        } else {
            out.beginObject();
            if (throwable.getMessage() != null) {
                out.name("message");
                out.value(throwable.getMessage());
            }
            if (this.shouldWriteCause(throwable)) {
                out.name("cause");
                this.write(out, throwable.getCause());
            }
            out.endObject();
        }
    }

    private boolean shouldWriteCause(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause == null || cause.getMessage() == null || cause == throwable) {
            return false;
        }
        return throwable.getMessage() == null || !throwable.getMessage().contains(cause.getMessage());
    }

    public static class Factory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!Throwable.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return new ThrowableTypeAdapter(typeToken);
        }
    }
}

