/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.entities;

import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCProjectileSource;
import com.laytonsmith.abstraction.blocks.MCBlockProjectileSource;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlockProjectileSource;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCEntity;
import com.laytonsmith.abstraction.entities.MCProjectile;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;

public class BukkitMCProjectile
extends BukkitMCEntity
implements MCProjectile {
    public BukkitMCProjectile(Entity e) {
        super(e);
    }

    @Override
    public boolean doesBounce() {
        if (this.getHandle() instanceof Projectile) {
            return ((Projectile)this.getHandle()).doesBounce();
        }
        return false;
    }

    @Override
    public MCProjectileSource getShooter() {
        if (this.getHandle() instanceof Projectile) {
            MCEntity e;
            ProjectileSource source = ((Projectile)this.getHandle()).getShooter();
            if (source instanceof BlockProjectileSource) {
                return new BukkitMCBlockProjectileSource((BlockProjectileSource)source);
            }
            if (source instanceof Entity && (e = BukkitConvertor.BukkitGetCorrectEntity((Entity)source)) instanceof MCProjectileSource) {
                return (MCProjectileSource)((Object)e);
            }
        }
        return null;
    }

    @Override
    public void setBounce(boolean doesBounce) {
        if (this.getHandle() instanceof Projectile) {
            ((Projectile)this.getHandle()).setBounce(doesBounce);
        }
    }

    @Override
    public void setShooter(MCProjectileSource shooter) {
        if (this.getHandle() instanceof Projectile) {
            if (shooter == null) {
                ((Projectile)this.getHandle()).setShooter(null);
            } else if (shooter instanceof MCBlockProjectileSource) {
                ((Projectile)this.getHandle()).setShooter((ProjectileSource)((BlockProjectileSource)shooter.getHandle()));
            } else {
                ((Projectile)this.getHandle()).setShooter((ProjectileSource)shooter.getHandle());
            }
        }
    }
}

