/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.federation;

import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class FederationRegistration {
    private final String serverName;
    private int port;
    private long lastUpdated;

    public FederationRegistration(String serverName) {
        this.serverName = serverName;
        this.lastUpdated = System.currentTimeMillis();
    }

    public String getServerName() {
        return this.serverName;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public void updateLastUpdated() {
        this.lastUpdated = System.currentTimeMillis();
    }

    public int getPort() {
        return this.port;
    }

    public boolean updatedSince(long time2) {
        return this.lastUpdated > System.currentTimeMillis() - time2;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String toJSON() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("server_name", this.serverName);
        values.put("port", Integer.toString(this.port));
        values.put("last_updated", Long.toString(System.currentTimeMillis()));
        return JSONObject.toJSONString(values);
    }

    public static FederationRegistration fromJSON(String json) {
        Map map = (Map)JSONValue.parse((String)json);
        String serverName = (String)map.get("server_name");
        int port = Integer.parseInt((String)map.get("port"));
        long lastUpdated = Long.parseLong((String)map.get("last_updated"));
        FederationRegistration reg = new FederationRegistration(serverName);
        reg.setPort(port);
        reg.lastUpdated = lastUpdated;
        return reg;
    }
}

