/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.eclipse.lsp4j;

import com.laytonsmith.libs.com.google.gson.annotations.JsonAdapter;
import com.laytonsmith.libs.org.eclipse.lsp4j.MarkedString;
import com.laytonsmith.libs.org.eclipse.lsp4j.MarkupContent;
import com.laytonsmith.libs.org.eclipse.lsp4j.Range;
import com.laytonsmith.libs.org.eclipse.lsp4j.adapters.HoverTypeAdapter;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.messages.Either;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import java.util.Arrays;
import java.util.List;

@JsonAdapter(value=HoverTypeAdapter.Factory.class)
public class Hover {
    @NonNull
    private Either<List<Either<String, MarkedString>>, MarkupContent> contents;
    private Range range;

    public Hover() {
    }

    public Hover(@NonNull List<Either<String, MarkedString>> contents) {
        this.setContents(Preconditions.checkNotNull(contents, "contents"));
    }

    public Hover(@NonNull List<Either<String, MarkedString>> contents, Range range2) {
        this.setContents(Preconditions.checkNotNull(contents, "contents"));
        this.range = range2;
    }

    public Hover(@NonNull MarkupContent contents) {
        this.setContents(Preconditions.checkNotNull(contents, "contents"));
    }

    public Hover(@NonNull MarkupContent contents, Range range2) {
        this.setContents(Preconditions.checkNotNull(contents, "contents"));
        this.range = range2;
    }

    public Hover(@NonNull Either<String, MarkedString> contents) {
        this.setContents(Arrays.asList(Preconditions.checkNotNull(contents, "contents")));
    }

    @NonNull
    public Either<List<Either<String, MarkedString>>, MarkupContent> getContents() {
        return this.contents;
    }

    public void setContents(@NonNull Either<List<Either<String, MarkedString>>, MarkupContent> contents) {
        this.contents = Preconditions.checkNotNull(contents, "contents");
    }

    public void setContents(List<Either<String, MarkedString>> contents) {
        if (contents == null) {
            Preconditions.checkNotNull(contents, "contents");
            this.contents = null;
            return;
        }
        this.contents = Either.forLeft(contents);
    }

    public void setContents(MarkupContent contents) {
        if (contents == null) {
            Preconditions.checkNotNull(contents, "contents");
            this.contents = null;
            return;
        }
        this.contents = Either.forRight(contents);
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range2) {
        this.range = range2;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder(this);
        b.add("contents", this.contents);
        b.add("range", this.range);
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hover other = (Hover)obj;
        if (this.contents == null ? other.contents != null : !this.contents.equals(other.contents)) {
            return false;
        }
        return !(this.range == null ? other.range != null : !this.range.equals(other.range));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contents == null ? 0 : this.contents.hashCode());
        return 31 * result + (this.range == null ? 0 : this.range.hashCode());
    }
}

