/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;

public class RSAEncrypt {
    private static final String ALGORITHM = "RSA";
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private String label;

    public static RSAEncrypt generateKey(String label) {
        KeyPairGenerator keyGen;
        try {
            keyGen = KeyPairGenerator.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        keyGen.initialize(1024);
        KeyPair key = keyGen.generateKeyPair();
        RSAEncrypt enc = new RSAEncrypt(RSAEncrypt.toString(key.getPrivate()), RSAEncrypt.toString(key.getPublic(), label));
        return enc;
    }

    public static String toString(PublicKey key, String label) {
        Objects.requireNonNull(label);
        ByteArrayOutputStream pubBOS = new ByteArrayOutputStream();
        try {
            ObjectOutputStream publicKeyOS = new ObjectOutputStream(pubBOS);
            publicKeyOS.writeObject(key);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        Object publicKey = Base64.encodeBase64String((byte[])pubBOS.toByteArray());
        publicKey = "ssh-rsa " + (String)publicKey + " " + label;
        return publicKey;
    }

    private static String toString(PrivateKey key) {
        ByteArrayOutputStream privBOS = new ByteArrayOutputStream();
        try {
            ObjectOutputStream privateKeyOS = new ObjectOutputStream(privBOS);
            privateKeyOS.writeObject(key);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        String privateKey = Base64.encodeBase64String((byte[])privBOS.toByteArray());
        StringBuilder privBuilder = new StringBuilder();
        privBuilder.append("-----BEGIN RSA PRIVATE KEY-----");
        for (int i = 0; i < privateKey.length(); ++i) {
            if (i % 64 == 0) {
                privBuilder.append(StringUtils.nl());
            }
            privBuilder.append(privateKey.charAt(i));
        }
        privBuilder.append(StringUtils.nl()).append("-----END RSA PRIVATE KEY-----").append(StringUtils.nl());
        privateKey = privBuilder.toString();
        return privateKey;
    }

    public RSAEncrypt(String privateKey, String publicKey) throws IllegalArgumentException {
        if (privateKey != null) {
            privateKey = privateKey.replaceAll("\r", "");
            privateKey = privateKey.replaceAll("\n", "");
            privateKey = privateKey.replace("-----BEGIN RSA PRIVATE KEY-----", "");
            privateKey = privateKey.replace("-----END RSA PRIVATE KEY-----", "");
            try {
                ObjectInputStream privOIS = new ObjectInputStream(new ByteArrayInputStream(Base64.decodeBase64((String)privateKey)));
                this.privateKey = (PrivateKey)privOIS.readObject();
            }
            catch (IOException | ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (publicKey != null) {
            String[] split2 = publicKey.split(" ");
            if (split2.length != 3) {
                throw new IllegalArgumentException("Invalid public key passed in.");
            }
            if (!"ssh-rsa".equals(split2[0])) {
                throw new IllegalArgumentException("Invalid public key type. Expecting ssh-rsa, but found \"" + split2[0] + "\"");
            }
            this.label = split2[2];
            try {
                ObjectInputStream pubOIS = new ObjectInputStream(new ByteArrayInputStream(Base64.decodeBase64((String)split2[1])));
                this.publicKey = (PublicKey)pubOIS.readObject();
            }
            catch (IOException | ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public byte[] encryptWithPublic(byte[] data) {
        Objects.requireNonNull(this.publicKey);
        return this.crypt(data, this.publicKey, 1);
    }

    public byte[] encryptWithPrivate(byte[] data) throws InvalidKeyException {
        Objects.requireNonNull(this.privateKey);
        return this.crypt(data, this.privateKey, 1);
    }

    public byte[] decryptWithPublic(byte[] data) {
        Objects.requireNonNull(this.publicKey);
        return this.crypt(data, this.publicKey, 2);
    }

    public byte[] decryptWithPrivate(byte[] data) {
        Objects.requireNonNull(this.privateKey);
        return this.crypt(data, this.privateKey, 2);
    }

    private byte[] crypt(byte[] data, Key key, int cryptMode) {
        byte[] cipherValue = null;
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(cryptMode, key);
            cipherValue = cipher.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new RuntimeException(ex);
        }
        return cipherValue;
    }

    public String getPrivateKey() {
        return RSAEncrypt.toString(this.privateKey);
    }

    public String getPublicKey() {
        return RSAEncrypt.toString(this.publicKey, this.label);
    }

    public String getLabel() {
        return this.label;
    }
}

