/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.GCUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class ZipMaker {
    private ZipMaker() {
    }

    public static void MakeZip(File startingDir, String filename) throws IOException {
        ZipMaker.MakeZip(startingDir, filename, false);
    }

    public static void MakeZip(File startingDir, String filename, boolean createTopLevelFolder) throws IOException {
        Object topLevel = "";
        if (createTopLevelFolder) {
            topLevel = filename.lastIndexOf(".") == -1 ? filename + "/" : filename.substring(0, filename.lastIndexOf(".")) + "/";
        }
        if (startingDir.isDirectory()) {
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            ZipMaker.GetFiles(files, startingDir.getCanonicalFile(), startingDir.getCanonicalFile());
            ZipMaker.MakeZip(files, new File(startingDir.getParentFile(), filename), startingDir, (String)topLevel);
        } else {
            ZipMaker.MakeZip(new LinkedHashSet<File>(Arrays.asList(startingDir)), new File(startingDir.getParentFile(), filename), startingDir, (String)topLevel);
        }
    }

    private static void MakeZip(Set<File> files, File output, File base, String topLevel) throws IOException {
        byte[] buf = new byte[1024];
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(output));
        for (File f : files) {
            int len;
            FileInputStream in = new FileInputStream(new File(base, f.getPath()));
            out.putNextEntry(new ZipEntry(topLevel + ZipMaker.GetUnabsoluteFile(base, f).getPath()));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            in.close();
            in = null;
            GCUtil.BlockUntilGC();
        }
        out.close();
    }

    private static void GetFiles(Set<File> ongoing, File directory, File base) throws IOException {
        if (directory.isDirectory()) {
            for (File f : directory.listFiles()) {
                ZipMaker.GetFiles(ongoing, f, base);
            }
        } else {
            File file = new File(directory.getAbsolutePath().replaceFirst(Pattern.quote(base.getAbsolutePath() + "/"), ""));
            ongoing.add(file);
        }
    }

    private static File GetUnabsoluteFile(File base, File child) throws IOException {
        String path = new File(base, child.getPath()).getCanonicalPath().replaceFirst(Pattern.quote(base.getCanonicalPath() + File.separatorChar), "");
        return new File(path);
    }
}

