/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCRecipeChoice;
import com.laytonsmith.abstraction.MCShapedRecipe;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCRecipe;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCMaterial;
import com.laytonsmith.abstraction.enums.MCRecipeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class BukkitMCShapedRecipe
extends BukkitMCRecipe
implements MCShapedRecipe {
    private final ShapedRecipe recipe;

    public BukkitMCShapedRecipe(ShapedRecipe recipe) {
        super((Recipe)recipe);
        this.recipe = recipe;
    }

    @Override
    public String getKey() {
        return this.recipe.getKey().getKey();
    }

    @Override
    public MCRecipeType getRecipeType() {
        return MCRecipeType.SHAPED;
    }

    @Override
    public String getGroup() {
        return this.recipe.getGroup();
    }

    @Override
    public void setGroup(String group) {
        this.recipe.setGroup(group);
    }

    @Override
    public Object getHandle() {
        return this.recipe;
    }

    @Override
    public Map<Character, MCRecipeChoice> getIngredientMap() {
        HashMap<Character, MCRecipeChoice> ret = new HashMap<Character, MCRecipeChoice>();
        for (Map.Entry entry : this.recipe.getChoiceMap().entrySet()) {
            Object choice;
            if (entry.getValue() == null) {
                ret.put((Character)entry.getKey(), null);
                continue;
            }
            Object v = entry.getValue();
            if (v instanceof RecipeChoice.MaterialChoice) {
                RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)v;
                choice = new MCRecipeChoice.MaterialChoice();
                for (Material material : materialChoice.getChoices()) {
                    ((MCRecipeChoice.MaterialChoice)choice).addMaterial(BukkitMCMaterial.valueOfConcrete(material));
                }
                ret.put((Character)entry.getKey(), (MCRecipeChoice)choice);
                continue;
            }
            choice = entry.getValue();
            if (!(choice instanceof RecipeChoice.ExactChoice)) continue;
            RecipeChoice.ExactChoice exactChoice = (RecipeChoice.ExactChoice)choice;
            choice = new MCRecipeChoice.ExactChoice();
            for (ItemStack itemStack : exactChoice.getChoices()) {
                ((MCRecipeChoice.ExactChoice)choice).addItem(new BukkitMCItemStack(itemStack));
            }
            ret.put((Character)entry.getKey(), (MCRecipeChoice)choice);
        }
        return ret;
    }

    @Override
    public MCItemStack getResult() {
        return new BukkitMCItemStack(this.recipe.getResult());
    }

    @Override
    public String[] getShape() {
        return this.recipe.getShape();
    }

    @Override
    public void setIngredient(char key, MCItemStack ingredient) {
        this.recipe.setIngredient(key, (RecipeChoice)new RecipeChoice.ExactChoice((ItemStack)ingredient.getHandle()));
    }

    @Override
    public void setIngredient(char key, MCRecipeChoice ingredients) {
        if (ingredients instanceof MCRecipeChoice.ExactChoice) {
            ArrayList<ItemStack> choice = new ArrayList<ItemStack>();
            for (MCItemStack itemStack : ((MCRecipeChoice.ExactChoice)ingredients).getItems()) {
                choice.add((ItemStack)itemStack.getHandle());
            }
            this.recipe.setIngredient(key, (RecipeChoice)new RecipeChoice.ExactChoice(choice));
        } else if (ingredients instanceof MCRecipeChoice.MaterialChoice) {
            ArrayList<Material> choice = new ArrayList<Material>();
            for (MCMaterial material : ((MCRecipeChoice.MaterialChoice)ingredients).getMaterials()) {
                choice.add((Material)material.getHandle());
            }
            this.recipe.setIngredient(key, (RecipeChoice)new RecipeChoice.MaterialChoice(choice));
        }
    }

    @Override
    public void setIngredient(char key, MCMaterial mat) {
        this.recipe.setIngredient(key, (Material)mat.getHandle());
    }

    @Override
    public void setShape(String[] shape) {
        this.recipe.shape(shape);
    }
}

