/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassMirror;
import com.laytonsmith.PureUtilities.ClassLoading.DynamicEnum;
import com.laytonsmith.PureUtilities.Common.Annotations.InterfaceRunnerFor;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.annotations.MDynamicEnum;
import com.laytonsmith.annotations.MEnum;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.natives.interfaces.MEnumType;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.natives.interfaces.MixedInterfaceRunner;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class NativeTypeList {
    private static final Object NATIVE_TYPE_LOCK = new Object();
    private static volatile Set<String> nativeTypes;
    private static Set<FullyQualifiedClassName> fqNativeTypes;
    public static final String INVALID_INSTANCE_METHOD_NAME = "ConstructInvalidInstance";
    private static final Map<FullyQualifiedClassName, Mixed> INVALID_INSTANCE_CACHE;
    private static final Map<FullyQualifiedClassName, Class<? extends Mixed>> NATIVE_CLASS_CACHE;
    private static final Class<? extends Mixed> NULL_CLASS_OBJECT;

    public static String resolveNativeType(String simpleName) {
        if (nativeTypes == null) {
            NativeTypeList.getNativeTypeList();
        }
        HashSet<String> defaultPackages = new HashSet<String>(Arrays.asList("", "ms.lang.", "com.commandhelper."));
        for (String pack : defaultPackages) {
            for (String type : nativeTypes) {
                if (!(pack + simpleName).equals(type)) continue;
                return type;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<FullyQualifiedClassName> getNativeTypeList() {
        Set<String> nativeTypes = NativeTypeList.nativeTypes;
        if (nativeTypes == null) {
            Object object = NATIVE_TYPE_LOCK;
            synchronized (object) {
                nativeTypes = NativeTypeList.nativeTypes;
                if (nativeTypes == null) {
                    String name;
                    HashSet<FullyQualifiedClassName> fqNativeTypesPrivate = new HashSet<FullyQualifiedClassName>();
                    nativeTypes = new HashSet<String>();
                    ClassDiscovery.getDefaultInstance().addDiscoveryLocation(ClassDiscovery.GetClassContainer(Mixed.class));
                    for (ClassMirror<Mixed> classMirror : ClassDiscovery.getDefaultInstance().getClassesWithAnnotationThatExtend(typeof.class, Mixed.class)) {
                        nativeTypes.add((String)classMirror.getAnnotation(typeof.class).getValue("value"));
                        fqNativeTypesPrivate.add(FullyQualifiedClassName.forNativeClass(classMirror.loadClass()));
                    }
                    for (ClassMirror<Object> classMirror : ClassDiscovery.getDefaultInstance().getClassesWithAnnotationThatExtend(MEnum.class, Enum.class)) {
                        name = (String)classMirror.getAnnotation(MEnum.class).getValue("value");
                        nativeTypes.add(name);
                        fqNativeTypesPrivate.add(FullyQualifiedClassName.forFullyQualifiedClass(name));
                    }
                    for (ClassMirror<Object> classMirror : ClassDiscovery.getDefaultInstance().getClassesWithAnnotationThatExtend(MDynamicEnum.class, DynamicEnum.class)) {
                        name = (String)classMirror.getAnnotation(MDynamicEnum.class).getValue("value");
                        nativeTypes.add(name);
                        fqNativeTypesPrivate.add(FullyQualifiedClassName.forFullyQualifiedClass(name));
                    }
                    fqNativeTypes = fqNativeTypesPrivate;
                    NativeTypeList.nativeTypes = nativeTypes;
                }
            }
        }
        return new HashSet<FullyQualifiedClassName>(fqNativeTypes);
    }

    public static Class<? extends Mixed> getNativeClass(FullyQualifiedClassName fqcn) throws ClassNotFoundException {
        Class<?> c;
        if (fqcn.getNativeClass() != null) {
            return fqcn.getNativeClass();
        }
        if (NATIVE_CLASS_CACHE.containsKey(fqcn) && (c = NATIVE_CLASS_CACHE.get(fqcn)) == NULL_CLASS_OBJECT) {
            throw new ClassNotFoundException("Could not find the class of type " + String.valueOf(fqcn));
        }
        if ("auto".equals(fqcn.getFQCN())) {
            throw new ClassNotFoundException("auto is not a real type, and cannot be retrieved");
        }
        for (ClassMirror classMirror : ClassDiscovery.getDefaultInstance().getClassesWithAnnotationThatExtend(typeof.class, Mixed.class)) {
            if (!classMirror.getAnnotation(typeof.class).getProxy(typeof.class).value().equals(fqcn.getFQCN())) continue;
            NATIVE_CLASS_CACHE.put(fqcn, classMirror.loadClass());
            return classMirror.loadClass();
        }
        try {
            c = NativeTypeList.getNativeEnumType(fqcn).getClass();
            NATIVE_CLASS_CACHE.put(fqcn, c);
            return c;
        }
        catch (ClassNotFoundException classNotFoundException) {
            NATIVE_CLASS_CACHE.put(fqcn, NULL_CLASS_OBJECT);
            throw new ClassNotFoundException("Could not find the class of type " + String.valueOf(fqcn));
        }
    }

    public static Class<? extends Enum<?>> getNativeEnum(FullyQualifiedClassName fqcn) throws ClassNotFoundException {
        if ("ms.lang.enum".equals(fqcn.getFQCN())) {
            throw new ClassNotFoundException("ms.lang.enum is not an actual enum, and cannot be converted to one");
        }
        for (ClassMirror<Enum> c : ClassDiscovery.getDefaultInstance().getClassesWithAnnotationThatExtend(MEnum.class, Enum.class)) {
            if (!c.getAnnotation(MEnum.class).getProxy(MEnum.class).value().equals(fqcn.getFQCN())) continue;
            return c.loadClass();
        }
        throw new ClassNotFoundException("Could not find the class of type " + String.valueOf(fqcn));
    }

    public static MEnumType getNativeEnumType(FullyQualifiedClassName fqcn) throws ClassNotFoundException {
        if ("ms.lang.enum".equals(fqcn.getFQCN())) {
            return MEnumType.getRootEnumType();
        }
        try {
            Class<Enum<?>> e2 = NativeTypeList.getNativeEnum(fqcn);
            return MEnumType.FromEnum(fqcn, e2, null, null);
        }
        catch (ClassNotFoundException ex) {
            for (ClassMirror<DynamicEnum> c : ClassDiscovery.getDefaultInstance().getClassesWithAnnotationThatExtend(MDynamicEnum.class, DynamicEnum.class)) {
                List values;
                if (!c.getAnnotation(MDynamicEnum.class).getProxy(MDynamicEnum.class).value().equals(fqcn.getFQCN())) continue;
                try {
                    values = (List)c.getMethod("values", new Class[0]).loadMethod().invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex1) {
                    throw new RuntimeException(ex1);
                }
                Enum[] constants = values.stream().map(e -> (Enum)ReflectionUtils.get(DynamicEnum.class, e, "abstracted")).collect(Collectors.toList()).toArray(new Enum[values.size()]);
                return MEnumType.FromPartialEnum(fqcn, c.loadClass(), constants, null, null);
            }
            throw new ClassNotFoundException("Could not find the class of type " + String.valueOf(fqcn));
        }
    }

    public static Class<? extends Mixed> getNativeClassOrInterfaceRunner(FullyQualifiedClassName fqcn) throws ClassNotFoundException {
        try {
            return NativeTypeList.getInterfaceRunnerFor(fqcn);
        }
        catch (ClassNotFoundException | IllegalArgumentException ex) {
            return NativeTypeList.getNativeClass(fqcn);
        }
    }

    public static Class<? extends MixedInterfaceRunner> getInterfaceRunnerFor(FullyQualifiedClassName fqcn) throws ClassNotFoundException, IllegalArgumentException {
        Class<? extends Mixed> c = NativeTypeList.getNativeClass(fqcn);
        if (!c.isInterface() && (c.getModifiers() & 0x400) == 0) {
            throw new IllegalArgumentException(String.valueOf(fqcn) + " does not represent a java interface or abstract class");
        }
        Set<Class<MixedInterfaceRunner>> set = ClassDiscovery.getDefaultInstance().loadClassesWithAnnotationThatExtend(InterfaceRunnerFor.class, MixedInterfaceRunner.class);
        for (Class<MixedInterfaceRunner> cl : set) {
            if (cl == MixedInterfaceRunner.class || cl.getAnnotation(InterfaceRunnerFor.class).value() != c) continue;
            return cl;
        }
        throw new ClassNotFoundException("Could not find the runner for interface of type " + String.valueOf(fqcn));
    }

    public static Mixed getInvalidInstanceForUse(FullyQualifiedClassName fqcn) throws ClassNotFoundException {
        if (INVALID_INSTANCE_CACHE.containsKey(fqcn)) {
            return INVALID_INSTANCE_CACHE.get(fqcn);
        }
        Class<? extends Mixed> c = NativeTypeList.getNativeClassOrInterfaceRunner(fqcn);
        if (ReflectionUtils.hasMethod(c, INVALID_INSTANCE_METHOD_NAME, Mixed.class, new Class[0])) {
            Mixed m = (Mixed)ReflectionUtils.invokeMethod(c, null, INVALID_INSTANCE_METHOD_NAME);
            INVALID_INSTANCE_CACHE.put(fqcn, m);
            return m;
        }
        Mixed m = MEnumType.class.isAssignableFrom(c) ? NativeTypeList.getNativeEnumType(fqcn) : ReflectionUtils.instantiateUnsafe(c);
        INVALID_INSTANCE_CACHE.put(fqcn, m);
        return m;
    }

    public static Mixed getNativeInvalidInstanceForUse(Class<? extends Mixed> clazz) {
        if (ClassDiscovery.GetClassAnnotation(clazz, typeof.class) == null) {
            throw new RuntimeException(String.valueOf(clazz) + " is missing typeof annotation!");
        }
        try {
            return NativeTypeList.getInvalidInstanceForUse(FullyQualifiedClassName.forNativeClass(clazz));
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }

    static {
        INVALID_INSTANCE_CACHE = new ConcurrentHashMap<FullyQualifiedClassName, Mixed>();
        NATIVE_CLASS_CACHE = new ConcurrentHashMap<FullyQualifiedClassName, Class<? extends Mixed>>();
        NULL_CLASS_OBJECT = NullClass.class;
    }

    private static interface NullClass
    extends Mixed {
    }
}

