/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.database;

import com.laytonsmith.core.Profiles;
import com.laytonsmith.database.SQLProfile;
import com.mysql.cj.jdbc.Driver;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Map;

@Profiles.ProfileType(type="mysql")
public class MySQLProfile
extends SQLProfile {
    private final String host;
    private final int port;
    private final String database;
    private final String username;
    private final String password;
    private final Boolean useSSL;

    public MySQLProfile(String id, Map<String, String> elements) throws Profiles.InvalidProfileException {
        super(id, elements);
        if (!elements.containsKey("database")) {
            throw new Profiles.InvalidProfileException("Required \"database\" tag is missing for profile \"" + id + "\"");
        }
        this.database = elements.get("database");
        this.username = elements.containsKey("username") ? elements.get("username") : null;
        this.password = elements.containsKey("password") ? elements.get("password") : null;
        this.host = elements.containsKey("host") ? elements.get("host") : "localhost";
        if (elements.containsKey("port")) {
            try {
                this.port = Integer.parseInt(elements.get("port"));
            }
            catch (NumberFormatException ex) {
                throw new Profiles.InvalidProfileException(ex.getMessage());
            }
        } else {
            this.port = 3306;
        }
        this.useSSL = elements.containsKey("useSSL") ? Boolean.valueOf(Boolean.parseBoolean(elements.get("useSSL"))) : null;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public String getConnectionString() throws SQLException {
        try {
            Class.forName(Driver.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException("Cannot load MySQL. Check your installation and try again");
        }
        try {
            return "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?generateSimpleParameterMetadata=true&jdbcCompliantTruncation=false&autoReconnect=true" + (String)(this.username == null ? "" : "&user=" + URLEncoder.encode(this.username, "UTF-8")) + (String)(this.password == null ? "" : "&password=" + URLEncoder.encode(this.password, "UTF-8")) + (String)(this.useSSL == null ? "" : "&useSSL=" + this.useSSL);
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error();
        }
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.host + ":" + this.port + " username=" + this.username;
    }
}

