/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.core.types;

import com.laytonsmith.libs.org.postgresql.core.types.PGBoolean;
import com.laytonsmith.libs.org.postgresql.core.types.PGInteger;
import com.laytonsmith.libs.org.postgresql.core.types.PGLong;
import com.laytonsmith.libs.org.postgresql.core.types.PGShort;
import com.laytonsmith.libs.org.postgresql.core.types.PGString;
import com.laytonsmith.libs.org.postgresql.core.types.PGType;
import com.laytonsmith.libs.org.postgresql.core.types.PGUnknown;
import com.laytonsmith.libs.org.postgresql.util.GT;
import com.laytonsmith.libs.org.postgresql.util.PSQLException;
import com.laytonsmith.libs.org.postgresql.util.PSQLState;
import java.math.BigDecimal;

public class PGBigDecimal
implements PGType {
    private BigDecimal val;

    protected PGBigDecimal(BigDecimal x) {
        this.val = new BigDecimal(x.toString());
    }

    public static PGType castToServerType(BigDecimal val, int targetType) throws PSQLException {
        try {
            switch (targetType) {
                case -7: {
                    return new PGBoolean(val.doubleValue() == 0.0 ? Boolean.FALSE : Boolean.TRUE);
                }
                case -5: {
                    return new PGLong(new Long(val.longValue()));
                }
                case 4: {
                    return new PGInteger(new Integer(val.intValue()));
                }
                case -6: 
                case 5: {
                    return new PGShort(new Short(val.shortValue()));
                }
                case -1: 
                case 12: {
                    return new PGString(val.toString());
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    return new PGBigDecimal(val);
                }
            }
            return new PGUnknown(val);
        }
        catch (Exception ex) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{val.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        return this.val.toString();
    }
}

