/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.geometric;

import com.laytonsmith.libs.org.postgresql.util.GT;
import com.laytonsmith.libs.org.postgresql.util.PGobject;
import com.laytonsmith.libs.org.postgresql.util.PGtokenizer;
import com.laytonsmith.libs.org.postgresql.util.PSQLException;
import com.laytonsmith.libs.org.postgresql.util.PSQLState;
import java.awt.Point;
import java.io.Serializable;
import java.sql.SQLException;

public class PGpoint
extends PGobject
implements Serializable,
Cloneable {
    public double x;
    public double y;

    public PGpoint(double x, double y) {
        this();
        this.x = x;
        this.y = y;
    }

    public PGpoint(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    public PGpoint() {
        this.setType("point");
    }

    @Override
    public void setValue(String s) throws SQLException {
        PGtokenizer t = new PGtokenizer(PGtokenizer.removePara(s), ',');
        try {
            this.x = Double.valueOf(t.getToken(0));
            this.y = Double.valueOf(t.getToken(1));
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", new Object[]{this.type, s}), PSQLState.DATA_TYPE_MISMATCH, (Throwable)e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PGpoint) {
            PGpoint p2 = (PGpoint)obj;
            return this.x == p2.x && this.y == p2.y;
        }
        return false;
    }

    public int hashCode() {
        long v1 = Double.doubleToLongBits(this.x);
        long v2 = Double.doubleToLongBits(this.y);
        return (int)(v1 ^ v2 ^ v1 >>> 32 ^ v2 >>> 32);
    }

    @Override
    public String getValue() {
        return "(" + this.x + "," + this.y + ")";
    }

    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    public void translate(double x, double y) {
        this.x += x;
        this.y += y;
    }

    public void move(int x, int y) {
        this.setLocation(x, y);
    }

    public void move(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(int x, int y) {
        this.move((double)x, (double)y);
    }

    public void setLocation(Point p2) {
        this.setLocation(p2.x, p2.y);
    }
}

