/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction;

import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.StaticLayer;
import java.util.ArrayList;
import java.util.List;

public abstract class MCPluginMeta {
    private List<String> openOutgoingChannels = new ArrayList<String>();
    private List<String> openIncomingChannels = new ArrayList<String>();

    protected MCPluginMeta() {
        StaticLayer.GetConvertor().addShutdownHook(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> copyOutgoing = new ArrayList<String>(MCPluginMeta.this.openOutgoingChannels);
                for (String s : copyOutgoing) {
                    MCPluginMeta.this.closeOutgoingChannel(s);
                }
                ArrayList<String> copyIncoming = new ArrayList<String>(MCPluginMeta.this.openIncomingChannels);
                for (String s : copyIncoming) {
                    MCPluginMeta.this.closeIncomingChannel(s);
                }
            }
        });
    }

    public void closeOutgoingChannel(String channel) {
        if (this.openOutgoingChannels.contains(channel)) {
            this.closeOutgoingChannel0(channel);
            this.openOutgoingChannels.remove(channel);
        }
    }

    public void openOutgoingChannel(String channel) {
        if (!this.openOutgoingChannels.contains(channel)) {
            this.openOutgoingChannel0(channel);
            this.openOutgoingChannels.add(channel);
        }
    }

    public void registerChannelListener(String channel, PluginMessageListener listener) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected void triggerOnMessage(MCPlayer player2, String channel, byte[] message) {
    }

    public abstract void closeOutgoingChannel0(String var1);

    public abstract void openOutgoingChannel0(String var1);

    public void closeIncomingChannel(String channel) {
        if (this.openIncomingChannels.contains(channel)) {
            this.closeIncomingChannel0(channel);
            this.openIncomingChannels.remove(channel);
        }
    }

    public void openIncomingChannel(String channel) {
        if (!this.openIncomingChannels.contains(channel)) {
            this.openIncomingChannel0(channel);
            this.openIncomingChannels.add(channel);
        }
    }

    public final void fakeIncomingMessage(MCPlayer from, String channel, byte[] message) {
        this.openOutgoingChannel(channel);
        this.sendIncomingMessage0(from, channel, message);
    }

    public abstract void closeIncomingChannel0(String var1);

    public abstract void openIncomingChannel0(String var1);

    protected abstract void sendIncomingMessage0(MCPlayer var1, String var2, byte[] var3);

    public static interface PluginMessageListener {
        public void trigger(MCPlayer var1, byte[] var2);
    }
}

