/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.Version;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleVersion
implements Version {
    private int major;
    private int minor;
    private int supplemental;
    private String tag;
    private static final Pattern PATTERN = Pattern.compile("(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\s+(.*))?");

    public SimpleVersion(String version) {
        Matcher m = PATTERN.matcher(version);
        if (m.find()) {
            try {
                this.major = Integer.parseInt(m.group(1) == null ? "0" : m.group(1));
                this.minor = Integer.parseInt(m.group(2) == null ? "0" : m.group(2));
                this.supplemental = Integer.parseInt(m.group(3) == null ? "0" : m.group(3));
                this.tag = m.group(4) == null ? "" : m.group(4);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Version numbers must be integers", e);
            }
        } else {
            throw new IllegalArgumentException("Invalid version string provided");
        }
    }

    public SimpleVersion(int major, int minor, int supplemental, String tag) {
        this.major = major;
        this.minor = minor;
        this.supplemental = supplemental;
        this.tag = tag;
    }

    public SimpleVersion(int major, int minor, int supplemental) {
        this(major, minor, supplemental, "");
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getSupplemental() {
        return this.supplemental;
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    public String toString() {
        return (this.major + "." + this.minor + "." + this.supplemental + " " + this.tag).trim();
    }

    public int compareTo(Version o) {
        int[] thisParts = new int[]{this.major, this.minor, this.supplemental};
        int[] otherParts = new int[]{o.getMajor(), o.getMinor(), o.getSupplemental()};
        for (int i = 0; i < thisParts.length; ++i) {
            int n1 = thisParts[i];
            int n2 = otherParts[i];
            if (n1 < n2) {
                return -1;
            }
            if (n1 <= n2) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version v = (Version)obj;
            return this.major == v.getMajor() && this.minor == v.getMinor() && this.supplemental == v.getSupplemental();
        }
        return false;
    }

    public int hashCode() {
        int hash2 = 5;
        hash2 = 97 * hash2 + this.major;
        hash2 = 97 * hash2 + this.minor;
        hash2 = 97 * hash2 + this.supplemental;
        return hash2;
    }

    @Override
    public boolean lt(Version other) {
        return SimpleVersion.checkLT(this, other);
    }

    @Override
    public boolean lte(Version other) {
        return SimpleVersion.checkLTE(this, other);
    }

    @Override
    public boolean gt(Version other) {
        return SimpleVersion.checkGT(this, other);
    }

    @Override
    public boolean gte(Version other) {
        return SimpleVersion.checkGTE(this, other);
    }

    public static boolean checkLT(Version lhs, Version rhs) {
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        if (lhs.getMajor() == rhs.getMajor()) {
            if (lhs.getMinor() == rhs.getMinor()) {
                if (lhs.getSupplemental() == rhs.getSupplemental()) {
                    return false;
                }
                if (lhs.getSupplemental() < rhs.getSupplemental()) {
                    return true;
                }
            } else if (lhs.getMinor() < rhs.getMinor()) {
                return true;
            }
        } else if (lhs.getMajor() < rhs.getMajor()) {
            return true;
        }
        return false;
    }

    public static boolean checkLTE(Version lhs, Version rhs) {
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        if (lhs.equals(rhs)) {
            return true;
        }
        return SimpleVersion.checkLT(lhs, rhs);
    }

    public static boolean checkGT(Version lhs, Version rhs) {
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        if (lhs.getMajor() == rhs.getMajor()) {
            if (lhs.getMinor() == rhs.getMinor()) {
                if (lhs.getSupplemental() == rhs.getSupplemental()) {
                    return false;
                }
                if (lhs.getSupplemental() > rhs.getSupplemental()) {
                    return true;
                }
            } else if (lhs.getMinor() > rhs.getMinor()) {
                return true;
            }
        } else if (lhs.getMajor() > rhs.getMajor()) {
            return true;
        }
        return false;
    }

    public static boolean checkGTE(Version lhs, Version rhs) {
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        if (lhs.equals(rhs)) {
            return true;
        }
        return SimpleVersion.checkGT(lhs, rhs);
    }
}

