/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.keywords;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.Keyword;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CKeyword;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import java.util.List;

@Keyword.keyword(value="for")
public class ForKeyword
extends Keyword {
    @Override
    public int process(List<ParseTree> list, int keywordPosition) throws ConfigCompileException {
        ParseTree elseKeyword;
        ParseTree codeBlock;
        ParseTree forTree = list.get(keywordPosition);
        Target t = forTree.getTarget();
        if (list.size() > keywordPosition + 1 && ForKeyword.isCodeBlock(codeBlock = list.get(keywordPosition + 1))) {
            this.validateCodeBlock(codeBlock, "");
            forTree.addChild(ForKeyword.getArgumentOrNoop(codeBlock));
            list.remove(keywordPosition + 1);
        }
        if (list.size() > keywordPosition + 1 && (elseKeyword = list.get(keywordPosition + 1)).getData() instanceof CKeyword && elseKeyword.getData().val().equals("else")) {
            list.remove(keywordPosition + 1);
            ParseTree codeBlock2 = list.get(keywordPosition + 1);
            if (ForKeyword.isCodeBlock(codeBlock2)) {
                this.validateCodeBlock(codeBlock2, "");
                forTree.addChild(ForKeyword.getArgumentOrNoop(codeBlock2));
            }
            list.get(keywordPosition).setData(new CFunction("forelse", t));
            list.remove(keywordPosition + 1);
        }
        return keywordPosition;
    }

    @Override
    public String docs() {
        return "Creates a block that loops over the given inputs, running the code in the block as appropriate.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }
}

