/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen.localization;

import com.laytonsmith.PureUtilities.Common.MutableObject;
import com.laytonsmith.PureUtilities.Web.HTTPHeaders;
import com.laytonsmith.PureUtilities.Web.HTTPMethod;
import com.laytonsmith.PureUtilities.Web.HTTPResponse;
import com.laytonsmith.PureUtilities.Web.RequestSettings;
import com.laytonsmith.PureUtilities.Web.WebUtility;
import com.laytonsmith.libs.org.json.simple.JSONArray;
import com.laytonsmith.libs.org.json.simple.JSONObject;
import com.laytonsmith.libs.org.json.simple.JSONValue;
import com.laytonsmith.tools.docgen.localization.MachineTranslation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AzureMachineTranslation
implements MachineTranslation {
    private static final int PAGE_SIZE = 100;
    private static final int MAX_TEXT_SIZE = 5000;
    private static final String AZURE_TRANSLATE_ENDPOINT = "https://api.cognitive.microsofttranslator.com/translate";
    private static final Map<Integer, ErrorType> RESPONSE_CODES = new HashMap<Integer, ErrorType>(){
        {
            this.put(400, new ErrorType(400, "One of the query parameters is missing or not valid. Correct request parameters before retrying.", true));
            this.put(401, new ErrorType(401, "The request could not be authenticated. Check that credentials are specified and valid.", true));
            this.put(403, new ErrorType(403, "The request is not authorized. Check the details error message. This often indicates that all free translations provided with a trial subscription have been used up.", true));
            this.put(408, new ErrorType(408, "The request could not be fulfilled because a resource is missing. Check the details error message. When using a custom category, this often indicates that the custom translation system is not yet available to serve requests. The request should be retried after a waiting period (e.g. 1 minute).", true));
            this.put(429, new ErrorType(429, "The server rejected the request because the client has exceeded request limits.", true));
            this.put(500, new ErrorType(500, "An unexpected error occurred. If the error persists, report it with: date and time of the failure, request identifier from response header X-RequestId, and client identifier from request header X-ClientTraceId.", false));
            this.put(503, new ErrorType(503, "Server temporarily unavailable. Retry the request. If the error persists, report it with: date and time of the failure, request identifier from response header X-RequestId, and client identifier from request header X-ClientTraceId.", false));
        }
    };
    private final URL endpoint;
    private final String key;

    public AzureMachineTranslation(String key) {
        try {
            this.endpoint = new URL(AZURE_TRANSLATE_ENDPOINT);
        }
        catch (MalformedURLException ex) {
            throw new Error(ex);
        }
        this.key = key;
    }

    @Override
    public String translate(String locale, String english) throws MachineTranslation.TranslationException {
        MutableObject ex = new MutableObject();
        Map<String, String> ret = this.bulkTranslate(locale, new HashSet<String>(Arrays.asList(english)), e -> ex.setObject(e));
        if (ex.getObject() != null) {
            throw (MachineTranslation.TranslationException)ex.getObject();
        }
        return ret.get(english);
    }

    @Override
    public Map<String, String> bulkTranslate(String locale, Set<String> english, MachineTranslation.ErrorCallback callback) {
        if ("art".equals(locale)) {
            return MachineTranslation.ArtMachineTranslation.doArtTranslation(english);
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        Iterator<String> it = english.iterator();
        int itemCount = 0;
        int charCount = 0;
        HashSet<String> section = new HashSet<String>();
        while (it.hasNext()) {
            String next = it.next();
            if (next.length() > 5000) continue;
            if (itemCount + 1 >= 100 || charCount + next.length() >= 5000) {
                try {
                    ret.putAll(this.doRequest(locale, section));
                }
                catch (MachineTranslation.TranslationException ex) {
                    callback.error(ex);
                    break;
                }
                section = new HashSet();
                itemCount = 0;
                charCount = 0;
                continue;
            }
            section.add(next);
        }
        if (!section.isEmpty()) {
            try {
                ret.putAll(this.doRequest(locale, section));
            }
            catch (MachineTranslation.TranslationException ex) {
                callback.error(ex);
            }
        }
        return ret;
    }

    private Map<String, String> doRequest(String locale, Set<String> english) throws MachineTranslation.TranslationException {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("api-version", "3.0");
            parameters.put("from", "en");
            parameters.put("to", locale);
            parameters.put("textType", "plain");
            parameters.put("includeAlignment", "true");
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            headers.put("Content-Type", Arrays.asList("application/json"));
            headers.put("Ocp-Apim-Subscription-Key", Arrays.asList(this.key));
            ArrayList<String> requestStrings = new ArrayList<String>(english);
            ArrayList body = new ArrayList();
            for (String e : requestStrings) {
                HashMap<String, String> tr = new HashMap<String, String>();
                tr.put("Text", e);
                body.add(tr);
            }
            RequestSettings rs = new RequestSettings();
            rs.setParameters(parameters);
            rs.setRawParameter(JSONValue.toJSONString(body).getBytes("UTF-8"));
            rs.setMethod(HTTPMethod.POST);
            rs.setHeaders(headers);
            HTTPResponse response = WebUtility.GetPage(this.endpoint, rs);
            if (response.getResponseCode() != 200) {
                String exceptionText = response.getResponseCode() + " " + response.getResponseText() + "\n";
                String detailedErrorMessage = "No further information is available.";
                boolean fatal = true;
                if (RESPONSE_CODES.containsKey(response.getResponseCode())) {
                    ErrorType t = RESPONSE_CODES.get(response.getResponseCode());
                    detailedErrorMessage = t.detailMessage;
                    fatal = t.fatal;
                }
                exceptionText = exceptionText + "RequestId: " + response.getFirstHeader("X-RequestId") + "\n";
                exceptionText = exceptionText + detailedErrorMessage + "\n";
                exceptionText = exceptionText + response.getContentAsString();
                throw new MachineTranslation.TranslationException(exceptionText, fatal);
            }
            HashMap<String, String> ret = new HashMap<String, String>();
            try {
                String payload;
                JSONArray array2;
                String charset = "ISO-8859-1";
                HTTPHeaders.ContentType contentType = response.getHeaderObject().getContentType();
                if (contentType != null && contentType.charset != null) {
                    charset = contentType.charset;
                }
                if ((array2 = (JSONArray)JSONValue.parse(payload = response.getContentAsString(charset))).size() != requestStrings.size()) {
                    throw new MachineTranslation.TranslationException("Returned results were not the size expected, unsure how to correlate, so stopping. Here's the response text:\n" + response.getContentAsString(), true);
                }
                for (int i = 0; i < array2.size(); ++i) {
                    JSONObject tr = (JSONObject)array2.get(i);
                    JSONArray translations = (JSONArray)tr.get("translations");
                    String text = (String)((JSONObject)translations.get(0)).get("text");
                    ret.put((String)requestStrings.get(i), text);
                }
            }
            catch (ClassCastException cce) {
                throw new MachineTranslation.TranslationException("While parsing the request, it was not in the expected format. Here's the returned value:\n" + response.getContentAsString(), true);
            }
            return ret;
        }
        catch (IOException ex) {
            throw new MachineTranslation.TranslationException(ex, true);
        }
    }

    private static class ErrorType {
        public final int code;
        public final String detailMessage;
        public final boolean fatal;

        public ErrorType(int code, String detailMessage, boolean fatal) {
            this.code = code;
            this.detailMessage = detailMessage;
            this.fatal = fatal;
        }
    }
}

