/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.events.prefilters;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.compiler.analysis.StaticAnalysis;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CEntry;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CNumber;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.prefilters.AbstractPrefilterMatcher;
import com.laytonsmith.core.events.prefilters.PrefilterMatcher;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public abstract class MathPrefilterMatcher<T extends BindableEvent>
extends AbstractPrefilterMatcher<T> {
    private static final List<String> VALID_KEYS = Arrays.asList("value", "tolerance");

    @Override
    public PrefilterMatcher.PrefilterDocs getDocsObject() {
        return new MathPrefilterDocs();
    }

    @Override
    public CClassType typecheck(StaticAnalysis analysis, ParseTree prefilterValueParseTree, Environment env, Set<ConfigCompileException> exceptions) {
        if (prefilterValueParseTree.getData() instanceof CFunction && prefilterValueParseTree.getData().val().equals("array")) {
            for (ParseTree entry : prefilterValueParseTree.getChildren()) {
                Mixed mixed = entry.getData();
                if (mixed instanceof CEntry) {
                    CEntry centry2 = (CEntry)mixed;
                    String key = entry.getChildAt(0).getData().val();
                    ParseTree valParseTree = entry.getChildAt(1);
                    CClassType valType = analysis.typecheck(valParseTree, env, exceptions);
                    if (!VALID_KEYS.contains(key)) {
                        env.getEnv(CompilerEnvironment.class).addCompilerWarning(prefilterValueParseTree.getFileOptions(), new CompilerWarning("Unexpected key, this will be ignored.", centry2.ckey().getTarget(), null));
                        continue;
                    }
                    if (key.equals("value") && !valType.doesExtend(CNumber.TYPE)) {
                        env.getEnv(CompilerEnvironment.class).addCompilerWarning(prefilterValueParseTree.getFileOptions(), new CompilerWarning("Value should be a double", centry2.ckey().getTarget(), null));
                    }
                    if (!key.equals("tolerance") || valType.doesExtend(CNumber.TYPE)) continue;
                    env.getEnv(CompilerEnvironment.class).addCompilerWarning(prefilterValueParseTree.getFileOptions(), new CompilerWarning("Tolerance should be a number", centry2.ckey().getTarget(), null));
                    continue;
                }
                analysis.typecheck(entry, env, exceptions);
            }
            return CArray.TYPE;
        }
        return super.typecheck(analysis, prefilterValueParseTree, env, exceptions);
    }

    @Override
    public void validate(ParseTree node, CClassType nodeType, Environment env) throws ConfigCompileException, ConfigCompileGroupException, ConfigRuntimeException {
        if (!nodeType.doesExtend(CNumber.TYPE) && !nodeType.doesExtend(CArray.TYPE)) {
            env.getEnv(CompilerEnvironment.class).addCompilerWarning(node.getFileOptions(), new CompilerWarning("Expecting a number or array here, this may not perform as expected.", node.getTarget(), null));
        }
    }

    @Override
    public boolean matches(String key, Mixed value, T event, Target t) {
        double val;
        double tolerance = this.getTolerance();
        if (value instanceof CArray) {
            CArray array2 = (CArray)value;
            val = ArgumentValidation.getDouble(array2.get("value", t), t);
            tolerance = ArgumentValidation.getDouble(array2.get("tolerance", t), t);
        } else {
            val = ArgumentValidation.getDouble(value, t);
        }
        return Math.abs(val - this.getProperty(event)) <= tolerance;
    }

    protected abstract double getProperty(T var1);

    protected abstract double getTolerance();

    @Override
    public int getPriority() {
        return -1;
    }

    @api
    public static class MathPrefilterDocs
    implements PrefilterMatcher.PrefilterDocs {
        @Override
        public String getName() {
            return "math match";
        }

        @Override
        public String getNameWiki() {
            return "[[Prefilters#math match|Math Match]]";
        }

        @Override
        public String docs() {
            return "\tA math match is a simple match against a double value. By default, the prefilter will provide a\n\ttolerance, but this can be overridden by providing an array with the keys \"value\" and\n\t\"tolerance\", and then the tolerance can be set as necessary.\n\n\t<%CODE|\n\t\tbind('event', null, array(prefilter: 5), @event) {\n\t\t\t// Will fire if prefilter is 5.0\n\t\t}\n\n\t\tbind('event', null, array(prefilter: array(value: 5, tolerance: 2)), @event) {\n\t\t\t// Will fire if prefilter is 5.0, 6.5, or 4.3 for instance\n\t\t}\n\t%>\n";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_5;
        }
    }
}

