/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools;

import com.laytonsmith.PureUtilities.Common.UIUtils;
import com.laytonsmith.tools.docgen.localization.LocalizationUI;
import com.laytonsmith.tools.pnviewer.PNViewer;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class UILauncher
extends JFrame {
    private List<UI> uis = new ArrayList<UI>();
    private UI selectedUI = null;
    private JTextArea descriptionTextArea;
    private JButton exitButton;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton launchButton;
    private JList launcherList;

    public UILauncher() {
        String[] args = new String[]{};
        this.uis.add(new UI("Persistence Network Viewer", "Allows easier visualization of the Persistence Network", () -> PNViewer.main(args)));
        this.uis.add(new UI("Localization (L10n) UI", "Provides an easy to use UI to correctly edit localization files", () -> LocalizationUI.launch(null)));
        this.initComponents();
        this.setTitle("MethodScript UI Tool Launcher");
        this.setDefaultCloseOperation(3);
        this.launchButton.addActionListener(e -> {
            if (this.selectedUI == null) {
                JOptionPane.showMessageDialog(this, "Please select a tool from the list on the left.", "Error", 0);
                return;
            }
            this.selectedUI.getLauncher().run();
            this.setVisible(false);
        });
        this.exitButton.addActionListener(e -> System.exit(0));
        this.launcherList.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return UILauncher.this.uis.size();
            }

            @Override
            public Object getElementAt(int index) {
                return UILauncher.this.uis.get(index);
            }
        });
        this.launcherList.addListSelectionListener(e -> {
            UI ui = this.uis.get(e.getFirstIndex());
            this.descriptionTextArea.setText(ui.getTooltip());
            this.selectedUI = ui;
        });
        this.launcherList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UILauncher.this.launchButton.doClick();
                }
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.launcherList = new JList();
        this.launchButton = new JButton();
        this.exitButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.launcherList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.launcherList);
        this.launchButton.setText("Launch");
        this.exitButton.setText("Exit");
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setColumns(20);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setRows(5);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setEnabled(false);
        this.jScrollPane2.setViewportView(this.descriptionTextArea);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 270, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 264, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.launchButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.exitButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 325, Short.MAX_VALUE).addComponent(this.jScrollPane2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.launchButton).addComponent(this.exitButton)).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(UILauncher.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UILauncher ui = new UILauncher();
                UIUtils.centerWindow(ui);
                ui.setVisible(true);
            }
        });
    }

    private static class UI {
        private final String name;
        private final String tooltip;
        private final Runnable launch;

        public UI(String name, String tooltip, Runnable launch) {
            this.name = name;
            this.tooltip = tooltip;
            this.launch = launch;
        }

        public String getName() {
            return this.name;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public Runnable getLauncher() {
            return this.launch;
        }

        public String toString() {
            return this.name;
        }
    }
}

