/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen.localization;

import com.laytonsmith.PureUtilities.CommandExecutor;
import com.laytonsmith.PureUtilities.Common.Annotations.CheckOverrides;
import com.laytonsmith.PureUtilities.Common.UIUtils;
import com.laytonsmith.PureUtilities.GithubUtil;
import com.laytonsmith.tools.docgen.localization.LocalizationUI;
import com.laytonsmith.tools.docgen.localization.LogViewer;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

@CheckOverrides.SuppressCheckOverrides
public class ForkDatabaseWizard
extends JDialog {
    private static final String REPO = "git@github.com:LadyCailin/MethodScriptTranslationDB.git";
    private static final String MASTER_REPO_OWNER = "LadyCailin";
    private static final String MASTER_REPO_NAME = "MethodScriptTranslationDB";
    private final LocalizationUI parent;
    private final StateOptions stateOptions = new StateOptions();
    private final LogViewer logViewer;
    private JButton authorizeGithubButton;
    private JButton backButton;
    private JButton browseFileButton;
    private JButton cancelButton;
    private JRadioButton copyRepoRadioButton;
    private JRadioButton createForkRadioButton;
    private JTextField fileLocation;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JButton nextButton;
    private JTextArea outputWindow;
    private JScrollPane outputWindowScrollPanel;
    private JProgressBar progressBar;
    private ButtonGroup step1ButtonGroup;
    private JPanel step1Panel;
    private JPanel step2Panel;
    private JLabel step3ErrorLabel;
    private JPanel step3Panel;
    private JTabbedPane tabbedPanel;

    public ForkDatabaseWizard(LocalizationUI parent, LogViewer logViewer) {
        super((Frame)parent, true);
        this.parent = parent;
        this.initComponents();
        this.logViewer = logViewer;
        this.step3ErrorLabel.setText("");
        UIUtils.centerWindowOnWindow(this, parent);
        for (int i = 0; i < this.tabbedPanel.getTabCount(); ++i) {
            this.tabbedPanel.setEnabledAt(i, false);
        }
        this.writeStatus("---- Log ----");
    }

    private void validateStep() {
        int index = this.tabbedPanel.getSelectedIndex();
        boolean setEnabled = (Boolean)(new BooleanCallable[]{() -> this.createForkRadioButton.isSelected() || this.copyRepoRadioButton.isSelected(), () -> this.stateOptions.githubToken != null, () -> {
            String fl = this.fileLocation.getText();
            boolean subpathExists = new File(new File(this.fileLocation.getText()), MASTER_REPO_NAME).exists();
            if (subpathExists) {
                this.step3ErrorLabel.setText("The directory already contains a folder named MethodScriptTranslationDB");
            } else {
                this.step3ErrorLabel.setText("");
            }
            return new File(fl).exists() && !subpathExists;
        }})[index].call();
        this.nextButton.setEnabled(setEnabled);
    }

    private void stepTransition(boolean forward) {
        int next;
        int current = this.tabbedPanel.getSelectedIndex();
        if (forward) {
            if (current == this.tabbedPanel.getTabCount() - 1) {
                this.doFinish();
                return;
            }
            next = (Integer)(new IntCallable[]{() -> {
                this.stateOptions.doFork = this.createForkRadioButton.isSelected();
                if (this.createForkRadioButton.isSelected()) {
                    return 1;
                }
                return 2;
            }, () -> 2})[current].call();
        } else {
            next = (Integer)(new IntCallable[]{() -> 0, () -> 0, () -> 0})[current].call();
        }
        this.tabbedPanel.setSelectedIndex(next);
        if (next == 0) {
            this.backButton.setEnabled(false);
        } else {
            this.backButton.setEnabled(true);
        }
        if (next == this.tabbedPanel.getTabCount() - 1) {
            this.nextButton.setText("Finish");
        } else {
            this.nextButton.setText("Next");
        }
        this.validateStep();
    }

    private void writeStatus(String status) {
        this.outputWindow.append(status + "\n");
        this.logViewer.pushLog("ForkDatabase: " + status);
        JScrollBar vertical = this.outputWindowScrollPanel.getVerticalScrollBar();
        vertical.setValue(vertical.getMaximum());
    }

    private void doFinish() {
        this.cancelButton.setEnabled(false);
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.progressBar.setVisible(true);
        this.stateOptions.saveTo = new File(this.fileLocation.getText());
        new Thread(() -> {
            if (this.stateOptions.doFork) {
                this.writeStatus("Will first fork database on github");
            }
            this.writeStatus("Will save repo to " + String.valueOf(new File(this.stateOptions.saveTo, REPO.replaceAll("(?:.*)/(.*?)", "$1"))));
            try {
                File saveTo = this.stateOptions.saveTo;
                String cloneUrl = REPO;
                if (this.stateOptions.doFork) {
                    GithubUtil.Repository fork = this.getExistingFork();
                    if (fork == null) {
                        this.writeStatus("Fork not found, now creating fork");
                        fork = this.createFork();
                        this.writeStatus("Fork successfully created. Waiting 30 seconds for repo initialization...");
                        Thread.sleep(30000L);
                    } else {
                        this.writeStatus("Fork already exists! Will reuse existing fork at " + fork.cloneUrl);
                    }
                    cloneUrl = fork.sshUrl;
                }
                this.writeStatus("Cloning...");
                this.writeStatus(CommandExecutor.Execute(saveTo, "git", "clone", cloneUrl));
                this.parent.initializeTranslationDb(new File(saveTo, MASTER_REPO_NAME));
            }
            catch (IOException | InterruptedException ex) {
                this.writeStatus("Caught exception while trying to operate. Some steps may have completed successfully, andwere not rolled back!");
                this.writeStatus(ex.getMessage());
                return;
            }
            this.writeStatus("Repo successfully cloned! Feel free to close this dialog now.");
            this.cancelButton.setEnabled(true);
            this.cancelButton.setText("Close");
            this.progressBar.setVisible(false);
        }, "ForkDatabase").start();
    }

    private GithubUtil.Repository getExistingFork() throws GithubUtil.GithubException {
        GithubUtil util = new GithubUtil(this.stateOptions.githubToken);
        List<GithubUtil.Repository> r = util.listRepos(null, "owner", null, null, null);
        for (GithubUtil.Repository rr : r) {
            if (!rr.fork) continue;
            try {
                GithubUtil.Repository repo = util.getRepo(rr.owner.login, rr.name);
                if (!"LadyCailin/MethodScriptTranslationDB".equals(repo.parent.fullName)) continue;
                return rr;
            }
            catch (GithubUtil.GithubException ex) {
                if (ex.getResponseCode() == 451) continue;
                throw ex;
            }
        }
        return null;
    }

    private GithubUtil.Repository createFork() throws GithubUtil.GithubException {
        GithubUtil util = new GithubUtil(this.stateOptions.githubToken);
        return util.forkRepo(MASTER_REPO_OWNER, MASTER_REPO_NAME, null);
    }

    private void initComponents() {
        this.step1ButtonGroup = new ButtonGroup();
        this.tabbedPanel = new JTabbedPane();
        this.step1Panel = new JPanel();
        this.jLabel1 = new JLabel();
        this.createForkRadioButton = new JRadioButton();
        this.copyRepoRadioButton = new JRadioButton();
        this.step2Panel = new JPanel();
        this.jLabel2 = new JLabel();
        this.authorizeGithubButton = new JButton();
        this.step3Panel = new JPanel();
        this.jLabel3 = new JLabel();
        this.fileLocation = new JTextField();
        this.browseFileButton = new JButton();
        this.step3ErrorLabel = new JLabel();
        this.nextButton = new JButton();
        this.backButton = new JButton();
        this.cancelButton = new JButton();
        this.progressBar = new JProgressBar();
        this.outputWindowScrollPanel = new JScrollPane();
        this.outputWindow = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle("Fork Database Wizard");
        this.jLabel1.setText("<html><body>Would you like to create a fork first? You must<br>create a fork before you will be able to make contributions.<br>If you create a fork, you must have a github account. You can create one in the next step.<br>If you already have a fork, but just want to check it, select \"Create Fork\" anyways.");
        this.step1ButtonGroup.add(this.createForkRadioButton);
        this.createForkRadioButton.setText("Create Fork");
        this.createForkRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ForkDatabaseWizard.this.createForkRadioButtonActionPerformed(evt);
            }
        });
        this.step1ButtonGroup.add(this.copyRepoRadioButton);
        this.copyRepoRadioButton.setText("Just copy master repo");
        this.copyRepoRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ForkDatabaseWizard.this.copyRepoRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout step1PanelLayout = new GroupLayout(this.step1Panel);
        this.step1Panel.setLayout(step1PanelLayout);
        step1PanelLayout.setHorizontalGroup(step1PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(step1PanelLayout.createSequentialGroup().addContainerGap().addGroup(step1PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.copyRepoRadioButton).addComponent(this.createForkRadioButton).addComponent(this.jLabel1, -2, -1, -2)).addContainerGap(22, Short.MAX_VALUE)));
        step1PanelLayout.setVerticalGroup(step1PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(step1PanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.createForkRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.copyRepoRadioButton).addContainerGap(42, Short.MAX_VALUE)));
        this.tabbedPanel.addTab("Step 1", this.step1Panel);
        this.jLabel2.setText("<html><body>First, we need to authorize the application to access github.<br>If you don't have an account, this will create it.");
        this.authorizeGithubButton.setText("Authorize");
        this.authorizeGithubButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ForkDatabaseWizard.this.authorizeGithubButtonActionPerformed(evt);
            }
        });
        GroupLayout step2PanelLayout = new GroupLayout(this.step2Panel);
        this.step2Panel.setLayout(step2PanelLayout);
        step2PanelLayout.setHorizontalGroup(step2PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(step2PanelLayout.createSequentialGroup().addContainerGap().addGroup(step2PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.authorizeGithubButton)).addContainerGap(168, Short.MAX_VALUE)));
        step2PanelLayout.setVerticalGroup(step2PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(step2PanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.authorizeGithubButton).addContainerGap(108, Short.MAX_VALUE)));
        this.tabbedPanel.addTab("Step 2", this.step2Panel);
        this.jLabel3.setText("<html><body>Where would you like to put the repo on your local machine?<br>A new folder will automatically be created within the directory you select.");
        this.fileLocation.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ForkDatabaseWizard.this.fileLocationKeyReleased(evt);
            }
        });
        this.browseFileButton.setText("Browse");
        this.browseFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ForkDatabaseWizard.this.browseFileButtonActionPerformed(evt);
            }
        });
        this.step3ErrorLabel.setForeground(new Color(255, 51, 0));
        this.step3ErrorLabel.setText("Error Label");
        GroupLayout step3PanelLayout = new GroupLayout(this.step3Panel);
        this.step3Panel.setLayout(step3PanelLayout);
        step3PanelLayout.setHorizontalGroup(step3PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(step3PanelLayout.createSequentialGroup().addContainerGap().addGroup(step3PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(step3PanelLayout.createSequentialGroup().addComponent(this.fileLocation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseFileButton)).addGroup(step3PanelLayout.createSequentialGroup().addGroup(step3PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -2, -1, -2).addComponent(this.step3ErrorLabel)).addGap(0, 90, Short.MAX_VALUE))).addContainerGap()));
        step3PanelLayout.setVerticalGroup(step3PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(step3PanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(step3PanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLocation, -2, -1, -2).addComponent(this.browseFileButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.step3ErrorLabel).addContainerGap(88, Short.MAX_VALUE)));
        this.tabbedPanel.addTab("Step 3", this.step3Panel);
        this.nextButton.setText("Next");
        this.nextButton.setEnabled(false);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ForkDatabaseWizard.this.nextButtonActionPerformed(evt);
            }
        });
        this.backButton.setText("Back");
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ForkDatabaseWizard.this.backButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ForkDatabaseWizard.this.cancelButtonActionPerformed(evt);
            }
        });
        this.progressBar.setIndeterminate(true);
        this.outputWindow.setEditable(false);
        this.outputWindow.setColumns(20);
        this.outputWindow.setLineWrap(true);
        this.outputWindow.setRows(5);
        this.outputWindow.setWrapStyleWord(true);
        this.outputWindowScrollPanel.setViewportView(this.outputWindow);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputWindowScrollPanel).addComponent(this.tabbedPanel).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.backButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPanel, -2, 208, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nextButton).addComponent(this.backButton).addComponent(this.cancelButton)).addComponent(this.progressBar, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputWindowScrollPanel, -1, 104, Short.MAX_VALUE).addContainerGap()));
        this.progressBar.setVisible(false);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void createForkRadioButtonActionPerformed(ActionEvent evt) {
        this.validateStep();
    }

    private void copyRepoRadioButtonActionPerformed(ActionEvent evt) {
        this.validateStep();
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.stepTransition(true);
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        this.stepTransition(false);
    }

    private void authorizeGithubButtonActionPerformed(ActionEvent evt) {
        this.parent.authorizeGithub(false, token -> {
            this.stateOptions.githubToken = token;
            this.writeStatus("Obtained Github Authorization!");
            this.validateStep();
        });
    }

    private void fileLocationKeyReleased(KeyEvent evt) {
        this.validateStep();
    }

    private void browseFileButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        if (0 == fc.showDialog(this, "Select Directory")) {
            try {
                this.fileLocation.setText(fc.getSelectedFile().getCanonicalPath());
                this.validateStep();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class StateOptions {
        boolean doFork;
        String githubToken;
        File saveTo;

        private StateOptions() {
        }
    }

    private static interface BooleanCallable
    extends Callable<Boolean> {
    }

    private static interface IntCallable
    extends Callable<Integer> {
    }

    private static interface Callable<T> {
        public T call();
    }
}

