/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCRecipeChoice;
import com.laytonsmith.abstraction.MCStonecuttingRecipe;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCRecipe;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCMaterial;
import com.laytonsmith.abstraction.enums.MCRecipeType;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.StonecuttingRecipe;

public class BukkitMCStonecuttingRecipe
extends BukkitMCRecipe
implements MCStonecuttingRecipe {
    private final StonecuttingRecipe recipe;

    public BukkitMCStonecuttingRecipe(StonecuttingRecipe recipe) {
        super((Recipe)recipe);
        this.recipe = recipe;
    }

    @Override
    public String getKey() {
        return this.recipe.getKey().getKey();
    }

    @Override
    public MCRecipeType getRecipeType() {
        return MCRecipeType.STONECUTTING;
    }

    @Override
    public String getGroup() {
        return this.recipe.getGroup();
    }

    @Override
    public void setGroup(String group) {
        this.recipe.setGroup(group);
    }

    @Override
    public MCItemStack getResult() {
        return new BukkitMCItemStack(this.recipe.getResult());
    }

    @Override
    public Object getHandle() {
        return this.recipe;
    }

    @Override
    public MCRecipeChoice getInput() {
        RecipeChoice recipeChoice = this.recipe.getInputChoice();
        if (recipeChoice instanceof RecipeChoice.MaterialChoice) {
            RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)recipeChoice;
            MCRecipeChoice.MaterialChoice choice = new MCRecipeChoice.MaterialChoice();
            for (Material material : materialChoice.getChoices()) {
                choice.addMaterial(BukkitMCMaterial.valueOfConcrete(material));
            }
            return choice;
        }
        if (recipeChoice instanceof RecipeChoice.ExactChoice) {
            RecipeChoice.ExactChoice exactChoice = (RecipeChoice.ExactChoice)recipeChoice;
            MCRecipeChoice.ExactChoice choice = new MCRecipeChoice.ExactChoice();
            for (ItemStack itemStack : exactChoice.getChoices()) {
                choice.addItem(new BukkitMCItemStack(itemStack));
            }
            return choice;
        }
        throw new UnsupportedOperationException("Unsupported recipe choice");
    }

    @Override
    public void setInput(MCItemStack input) {
        this.recipe.setInputChoice((RecipeChoice)new RecipeChoice.ExactChoice((ItemStack)input.getHandle()));
    }

    @Override
    public void setInput(MCMaterial mat) {
        this.recipe.setInput((Material)mat.getHandle());
    }

    @Override
    public void setInput(MCRecipeChoice choice) {
        if (choice instanceof MCRecipeChoice.ExactChoice) {
            ArrayList<ItemStack> itemChoice = new ArrayList<ItemStack>();
            for (MCItemStack itemStack : ((MCRecipeChoice.ExactChoice)choice).getItems()) {
                itemChoice.add((ItemStack)itemStack.getHandle());
            }
            this.recipe.setInputChoice((RecipeChoice)new RecipeChoice.ExactChoice(itemChoice));
        } else if (choice instanceof MCRecipeChoice.MaterialChoice) {
            ArrayList<Material> materialChoice = new ArrayList<Material>();
            for (MCMaterial material : ((MCRecipeChoice.MaterialChoice)choice).getMaterials()) {
                materialChoice.add((Material)material.getHandle());
            }
            this.recipe.setInputChoice((RecipeChoice)new RecipeChoice.MaterialChoice(materialChoice));
        }
    }
}

