/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.XMLDocument;
import com.laytonsmith.core.Profiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.SAXException;

public class ProfilesImpl
implements Profiles {
    private final XMLDocument document;
    private final Map<String, Profiles.Profile> profiles = new HashMap<String, Profiles.Profile>();
    private static Map<String, Class<? extends Profiles.Profile>> profileTypes = null;

    public ProfilesImpl() {
        this.document = null;
    }

    public ProfilesImpl(String xml) throws Profiles.InvalidProfileException {
        try {
            this.document = new XMLDocument(xml);
        }
        catch (SAXException ex) {
            throw new Profiles.InvalidProfileException(ex);
        }
        this.parse();
    }

    public ProfilesImpl(File profileFile) throws IOException, Profiles.InvalidProfileException {
        this(FileUtil.readAsStream(profileFile));
    }

    public ProfilesImpl(InputStream profileData) throws IOException, Profiles.InvalidProfileException {
        try {
            this.document = new XMLDocument(profileData);
        }
        catch (SAXException ex) {
            throw new Profiles.InvalidProfileException(ex);
        }
        this.parse();
    }

    private void parse() throws Profiles.InvalidProfileException {
        int profileCount;
        try {
            profileCount = this.document.countNodes("/profiles/profile");
        }
        catch (XPathExpressionException ex) {
            throw new Profiles.InvalidProfileException("Missing root /profiles element");
        }
        for (int i = 1; i < profileCount + 1; ++i) {
            List<String> children;
            String type;
            String id;
            try {
                id = this.document.getNode("/profiles/profile[" + i + "]/@id");
            }
            catch (XPathExpressionException ex) {
                throw new Profiles.InvalidProfileException("All <profile> elements must have an id attribute.");
            }
            try {
                type = this.document.getNode("/profiles/profile[" + i + "]/type");
            }
            catch (XPathExpressionException ex) {
                throw new Profiles.InvalidProfileException("All <profile> elements must have a type attribute.");
            }
            try {
                children = this.document.getChildren("/profiles/profile[" + i + "]");
            }
            catch (XPathExpressionException ex) {
                throw new RuntimeException(ex);
            }
            HashMap<String, String> elements = new HashMap<String, String>();
            for (String child : children) {
                try {
                    elements.put(child, this.document.getNode("/profiles/profile[" + i + "]/" + child));
                }
                catch (XPathExpressionException ex) {
                    throw new RuntimeException(ex);
                }
            }
            elements.remove("type");
            if (this.profiles.containsKey(id)) {
                throw new Profiles.InvalidProfileException("Duplicate profile id found: \"" + id + "\"");
            }
            this.profiles.put(id, ProfilesImpl.getProfile0(id, type, elements));
        }
    }

    @Override
    public Profiles.Profile getProfileById(String id) throws Profiles.InvalidProfileException {
        if (!this.profiles.containsKey(id)) {
            throw new Profiles.InvalidProfileException("No profile by the name \"" + id + "\" was found.");
        }
        return this.profiles.get(id);
    }

    public String toString() {
        return StringUtils.Join(profileTypes, "=", "; ");
    }

    private static Profiles.Profile getProfile0(String id, String type, Map<String, String> data) throws Profiles.InvalidProfileException {
        if (profileTypes == null) {
            profileTypes = new HashMap<String, Class<? extends Profiles.Profile>>();
            for (Class<Profiles.Profile> p2 : ClassDiscovery.getDefaultInstance().loadClassesWithAnnotationThatExtend(Profiles.ProfileType.class, Profiles.Profile.class)) {
                if (p2 == Profiles.Profile.class) continue;
                String t = p2.getAnnotation(Profiles.ProfileType.class).type();
                profileTypes.put(t, p2);
            }
        }
        if (!profileTypes.containsKey(type)) {
            throw new Profiles.InvalidProfileException("Unknown profile type: \"" + type + "\"");
        }
        try {
            return ReflectionUtils.newInstance(profileTypes.get(type), new Class[]{String.class, Map.class}, new Object[]{id, data});
        }
        catch (ReflectionUtils.ReflectionException ex) {
            if (ex.getCause().getCause() instanceof Profiles.InvalidProfileException) {
                throw (Profiles.InvalidProfileException)ex.getCause().getCause();
            }
            throw ex;
        }
    }

    public static Profiles.Profile getProfile(Map<String, String> data) throws Profiles.InvalidProfileException {
        if (!data.containsKey("type")) {
            throw new Profiles.InvalidProfileException("Missing profile \"type\"");
        }
        String type = data.get("type");
        data.remove("type");
        return ProfilesImpl.getProfile(type, data);
    }

    public static Profiles.Profile getProfile(String type, Map<String, String> data) throws Profiles.InvalidProfileException {
        return ProfilesImpl.getProfile0(null, type, data);
    }
}

