/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.keywords;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.Keyword;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CKeyword;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.List;

@Keyword.keyword(value="notinstanceof")
public class NotInstanceofKeyword
extends Keyword {
    @Override
    public int process(List<ParseTree> list, int keywordPosition) throws ConfigCompileException {
        if (keywordPosition == 0) {
            throw new ConfigCompileException("Expected value to proceed \"notinstanceof\" keyword, but no identifiers were found.", list.get(keywordPosition).getTarget());
        }
        if (list.size() <= keywordPosition + 1) {
            throw new ConfigCompileException("Expected type to follow \"notinstanceof\" keyword, but no type was found.", list.get(keywordPosition).getTarget());
        }
        Mixed mixed = list.get(keywordPosition + 1).getData();
        if (mixed instanceof CKeyword) {
            CKeyword cKeyword = (CKeyword)mixed;
            cKeyword.getKeyword().process(list, keywordPosition + 1);
        }
        ParseTree node = new ParseTree(new CFunction("instanceof", list.get(keywordPosition).getTarget()), list.get(keywordPosition).getFileOptions());
        node.addChild(list.get(keywordPosition - 1));
        node.addChild(list.get(keywordPosition + 1));
        ParseTree notNode = new ParseTree(new CFunction("not", list.get(keywordPosition).getTarget()), list.get(keywordPosition).getFileOptions());
        notNode.addChild(node);
        list.set(keywordPosition - 1, notNode);
        list.remove(keywordPosition);
        list.remove(keywordPosition);
        return keywordPosition - 1;
    }

    @Override
    public String docs() {
        return "Provides the same functionality as instanceof, but returns a negated value.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }
}

