/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs.generics;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.ObjectHelpers;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.LeftHandSideType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.generics.ConcreteGenericParameter;
import com.laytonsmith.core.constructs.generics.ConstraintLocation;
import com.laytonsmith.core.constructs.generics.ConstraintValidator;
import com.laytonsmith.core.constructs.generics.LeftHandGenericUse;
import com.laytonsmith.core.constructs.generics.constraints.Constraint;
import com.laytonsmith.core.constructs.generics.constraints.ConstructorConstraint;
import com.laytonsmith.core.constructs.generics.constraints.ExactTypeConstraint;
import com.laytonsmith.core.constructs.generics.constraints.LowerBoundConstraint;
import com.laytonsmith.core.constructs.generics.constraints.UnboundedConstraint;
import com.laytonsmith.core.constructs.generics.constraints.UpperBoundConstraint;
import com.laytonsmith.core.constructs.generics.constraints.VariadicTypeConstraint;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREGenericConstraintException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class Constraints
implements Iterable<Constraint> {
    @ObjectHelpers.StandardField
    private final SortedSet<Constraint> constraints;
    @ObjectHelpers.StandardField
    private final String typename;
    private final boolean isVariadic;
    private final List<Constraint> unorderedConstraints;

    public Constraints(Target t, ConstraintLocation location, Constraint ... constraints) {
        this.unorderedConstraints = Arrays.asList(constraints);
        this.constraints = new TreeSet<Constraint>(this.unorderedConstraints);
        if (!(location != ConstraintLocation.RHS || constraints.length == 1 && constraints[0] instanceof ExactTypeConstraint)) {
            throw new CREGenericConstraintException("Constraints (other than a single ExactType constraint) cannot be used on the RHS. This definition contains " + constraints.length + "  constraint(s), of type(s): " + StringUtils.Join(constraints, ", ", item -> item.getClass().toString()), t);
        }
        this.typename = location == ConstraintLocation.DEFINITION ? ConstraintValidator.ValidateDefinition(this.constraints, t) : "?";
        boolean isVariadic = false;
        for (Constraint c : constraints) {
            ExactTypeConstraint etc;
            if (!(c instanceof VariadicTypeConstraint) && (!(c instanceof ExactTypeConstraint) || (etc = (ExactTypeConstraint)c).getType() == null || !etc.getType().isVariadicType())) continue;
            if (isVariadic) {
                throw new CREGenericConstraintException("Only one variadic type definition may be in the parameter", t);
            }
            isVariadic = true;
        }
        this.isVariadic = isVariadic;
    }

    public int size() {
        return this.constraints.size();
    }

    public String getTypeName() {
        return this.typename;
    }

    public String toSimpleString() {
        StringBuilder b = new StringBuilder();
        boolean doComma = false;
        for (Constraint c : this.constraints) {
            if (doComma) {
                b.append(" & ");
            }
            doComma = true;
            b.append(c.toSimpleString());
        }
        return b.toString();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        boolean doComma = false;
        for (Constraint c : this.constraints) {
            if (doComma) {
                b.append(" & ");
            }
            doComma = true;
            b.append(c.toString());
        }
        return b.toString();
    }

    public boolean withinBounds(Constraints lhs, List<String> errors, Environment env) {
        for (Constraint t : this.constraints) {
            boolean oneIsTrue = false;
            for (Constraint c : lhs) {
                Boolean res = t.isWithinConstraint(c, env);
                if (res == null) continue;
                if (res.booleanValue()) {
                    oneIsTrue = true;
                    continue;
                }
                errors.add("The LHS constraint " + String.valueOf(c) + " does not suit the constraint defined on the class " + String.valueOf(t));
            }
            if (oneIsTrue) continue;
            errors.add("The class defines the constraint " + String.valueOf(t) + ", but no constraints defined on the LHS suit this constraint.");
        }
        return errors.isEmpty();
    }

    public boolean withinBounds(LeftHandSideType type, Environment env) {
        for (Constraint c : this.constraints) {
            if (c.isWithinConstraint(type, env)) continue;
            return false;
        }
        return true;
    }

    public boolean supportsTypeUnions() {
        for (Constraint c : this.constraints) {
            if (c.supportsTypeUnions()) continue;
            return false;
        }
        return true;
    }

    public ExactTypeConstraint convertFromDiamond(Target t) throws CREGenericConstraintException {
        ExactTypeConstraint type = null;
        for (Constraint c : this.constraints) {
            ExactTypeConstraint newType = c.convertFromDiamond(t);
            if (type == null) {
                type = newType;
                continue;
            }
            throw new CREGenericConstraintException("Cannot infer generic type from LHS, please explicitely define the RHS generic parameters.", t);
        }
        if (type == null) {
            throw new CREGenericConstraintException("Cannot infer generic type from LHS, please explicitely define the RHS generic parameters.", t);
        }
        return type;
    }

    public ExactTypeConstraint convertFromNull(Target t) throws CREGenericConstraintException {
        ExactTypeConstraint type = null;
        for (Constraint c : this.constraints) {
            ExactTypeConstraint newType = c.convertFromNull(t);
            if (type == null) {
                type = newType;
                continue;
            }
            throw new CREGenericConstraintException("Cannot infer generic type from LHS, please explicitely define the RHS generic parameters.", t);
        }
        if (type == null) {
            throw new CREGenericConstraintException("Cannot infer generic type from LHS, please explicitely define the RHS generic parameters.", t);
        }
        return type;
    }

    public static Constraints[] BuildFromString(FileOptions fileOptions, String constraintDefinition, ConstraintLocation location, List<Constraints> declarationConstraints, Target t, Environment env) {
        int bracketStack = 0;
        int parenthesisStack = 0;
        constraintDefinition = constraintDefinition.replaceAll("\n", " ");
        constraintDefinition = constraintDefinition.replaceAll("\r", " ");
        constraintDefinition = constraintDefinition.replaceAll(" +", " ");
        ArrayList<Constraints> constraintsS = new ArrayList<Constraints>();
        StringBuilder buf = new StringBuilder();
        int declarationCount = 0;
        char[] cArray = constraintDefinition.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (c.charValue() == '<') {
                ++bracketStack;
            } else if (c.charValue() == '>') {
                --bracketStack;
            } else if (c.charValue() == '(') {
                ++parenthesisStack;
            } else if (c.charValue() == ')') {
                --parenthesisStack;
            } else if (c.charValue() == ',' && bracketStack == 0 && parenthesisStack == 0) {
                constraintsS.add(Constraints.GetConstraints(fileOptions, buf.toString(), t, location, declarationConstraints == null ? null : declarationConstraints.get(declarationCount++), env));
                buf = new StringBuilder();
                continue;
            }
            buf.append(c);
        }
        constraintsS.add(Constraints.GetConstraints(fileOptions, buf.toString(), t, location, declarationConstraints == null ? null : declarationConstraints.get(declarationCount++), env));
        return (Constraints[])constraintsS.toArray(Constraints[]::new);
    }

    private static Constraints GetConstraints(FileOptions fileOptions, String s, Target t, ConstraintLocation location, Constraints declarationConstraints, Environment env) {
        int bracketStack = 0;
        int parenthesisStack = 0;
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        StringBuilder buf = new StringBuilder();
        boolean endOfConstraint = false;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (c.charValue() == '(') {
                ++parenthesisStack;
            } else if (c.charValue() == ')') {
                --parenthesisStack;
            } else if (c.charValue() == '<') {
                ++bracketStack;
            } else if (c.charValue() == '>') {
                if (--bracketStack == 0 && parenthesisStack == 0) {
                    endOfConstraint = true;
                    buf.append(c);
                    continue;
                }
            } else if (bracketStack == 0 && c.charValue() == '&') {
                constraints.add(Constraints.GetConstraint(fileOptions, buf.toString(), t, location, declarationConstraints, env));
                endOfConstraint = false;
                buf = new StringBuilder();
                continue;
            }
            if (endOfConstraint && !Character.isWhitespace(c.charValue())) {
                throw new CREGenericConstraintException("Improperly formatted generic statement", t);
            }
            buf.append(c);
        }
        constraints.add(Constraints.GetConstraint(fileOptions, buf.toString(), t, location, declarationConstraints, env));
        return new Constraints(t, location, (Constraint[])constraints.toArray(Constraint[]::new));
    }

    static Constraint GetConstraint(FileOptions fileOptions, String s, Target t, ConstraintLocation location, Constraints declarationConstraints, Environment env) {
        LeftHandSideType clazz;
        s = s.trim();
        String name = "";
        String keyword2 = null;
        boolean inName = true;
        boolean inKeyword = false;
        boolean isNewConstraint = false;
        int subGenericStack = 0;
        int newParenthesisStack = 0;
        StringBuilder buf = new StringBuilder();
        char[] cArray = s.trim().toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (c.charValue() == '<') {
                ++subGenericStack;
            }
            if (c.charValue() == '>') {
                --subGenericStack;
                buf.append(c);
                continue;
            }
            if (subGenericStack > 0) {
                buf.append(c);
                continue;
            }
            if (!isNewConstraint && inName && Character.isWhitespace(c.charValue())) {
                name = buf.toString();
                buf = new StringBuilder();
                if ("new".equals(name)) {
                    isNewConstraint = true;
                    name = "";
                    continue;
                }
                inKeyword = true;
                inName = false;
                continue;
            }
            if (inKeyword && Character.isWhitespace(c.charValue())) {
                keyword2 = buf.toString();
                buf = new StringBuilder();
                inKeyword = false;
                continue;
            }
            if (isNewConstraint && c.charValue() == '(') {
                name = buf.toString().trim();
                ++newParenthesisStack;
                buf = new StringBuilder();
                continue;
            }
            if (isNewConstraint && c.charValue() == ')' && --newParenthesisStack == 0) {
                List<LeftHandSideType> types = Constraints.GetNewTypes(fileOptions, buf.toString(), t, env);
                return new ConstructorConstraint(t, name, types);
            }
            buf.append(c);
        }
        if (!inName && !inKeyword) {
            clazz = Constraints.ParseClassType(fileOptions, buf.toString(), t, env);
            if ("extends".equals(keyword2)) {
                return new UpperBoundConstraint(t, name, clazz);
            }
            if ("super".equals(keyword2)) {
                return new LowerBoundConstraint(t, name, clazz);
            }
        }
        if (inName && keyword2 == null) {
            if (location == ConstraintLocation.DEFINITION) {
                if (fileOptions != null) {
                    try {
                        CClassType.get(FullyQualifiedClassName.forName(buf.toString(), t, env), t);
                        CompilerWarning warning = new CompilerWarning("Typename overrides a real type, which may be confusing.", t, FileOptions.SuppressWarning.GenericTypeOverrides);
                        env.getEnv(CompilerEnvironment.class).addCompilerWarning(fileOptions, warning);
                    }
                    catch (CRECastException warning) {
                    }
                    catch (ClassNotFoundException warning) {
                        // empty catch block
                    }
                }
                if (buf.toString().endsWith("...")) {
                    return new VariadicTypeConstraint(t, buf.toString().substring(0, buf.toString().length() - 3));
                }
                return new UnboundedConstraint(t, buf.toString());
            }
            String typename = buf.toString();
            if ("?".equals(typename)) {
                return ExactTypeConstraint.AsUnboundedWildcard(t, declarationConstraints);
            }
            clazz = Constraints.ParseClassType(fileOptions, typename, t, env);
            return new ExactTypeConstraint(t, clazz);
        }
        throw new CREGenericConstraintException("Malformed generic parameters", t);
    }

    private static List<LeftHandSideType> GetNewTypes(FileOptions fileOptions, String s, Target t, Environment env) {
        ArrayList<LeftHandSideType> list = new ArrayList<LeftHandSideType>();
        int bracketStack = 0;
        int parenthesisStack = 0;
        StringBuilder buf = new StringBuilder();
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (bracketStack == 0 && parenthesisStack == 0 && c.charValue() == ',') {
                list.add(Constraints.ParseClassType(fileOptions, buf.toString(), t, env));
                buf = new StringBuilder();
                continue;
            }
            if (c.charValue() == '<') {
                ++bracketStack;
            } else if (c.charValue() == '>') {
                --bracketStack;
            } else if (c.charValue() == '(') {
                ++parenthesisStack;
            } else if (c.charValue() == ')') {
                --parenthesisStack;
            }
            buf.append(c);
        }
        if (!buf.isEmpty()) {
            list.add(Constraints.ParseClassType(fileOptions, buf.toString(), t, env));
        }
        return list;
    }

    private static LeftHandSideType ParseClassType(FileOptions fileOptions, String s, Target t, Environment env) {
        s = s.trim();
        CClassType nakedType = null;
        LeftHandGenericUse lhgu = null;
        boolean inLHS = false;
        int bracketStack = 0;
        StringBuilder buf = new StringBuilder();
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (c.charValue() == '<') {
                if (!inLHS) {
                    nakedType = CClassType.getNakedClassType(FullyQualifiedClassName.forName(buf.toString(), t, env), env);
                    buf = new StringBuilder();
                }
                inLHS = true;
                ++bracketStack;
            }
            if (c.charValue() == '>' && --bracketStack == 0) {
                buf.append(c);
                lhgu = new LeftHandGenericUse(nakedType, t, env, Constraints.BuildFromString(fileOptions, buf.toString().trim().replaceAll("<(.*)>", "$1"), ConstraintLocation.LHS, nakedType.getGenericDeclaration().getConstraints(), t, env));
                buf = new StringBuilder();
                continue;
            }
            buf.append(c);
        }
        if (!inLHS) {
            lhgu = null;
        }
        if (nakedType == null) {
            nakedType = CClassType.getNakedClassType(FullyQualifiedClassName.forName(buf.toString(), t, env), env);
        }
        return LeftHandSideType.fromCClassType(new ConcreteGenericParameter(nakedType, lhgu, t, env), t, env);
    }

    public boolean equals(Object o) {
        return ObjectHelpers.DoEquals(this, o);
    }

    public int hashCode() {
        return ObjectHelpers.DoHashCode(this);
    }

    @Override
    public Iterator<Constraint> iterator() {
        return this.constraints.iterator();
    }

    public List<Constraint> getInDefinitionOrder() {
        return new ArrayList<Constraint>(this.unorderedConstraints);
    }

    public boolean isVariadic() {
        return this.isVariadic;
    }
}

