/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs.generics.constraints;

import com.laytonsmith.core.constructs.LeftHandSideType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.generics.ConstraintLocation;
import com.laytonsmith.core.constructs.generics.ConstraintToConstraintValidator;
import com.laytonsmith.core.constructs.generics.constraints.BoundaryConstraint;
import com.laytonsmith.core.constructs.generics.constraints.ConstructorConstraint;
import com.laytonsmith.core.constructs.generics.constraints.ExactTypeConstraint;
import com.laytonsmith.core.constructs.generics.constraints.UnboundedConstraint;
import com.laytonsmith.core.constructs.generics.constraints.UpperBoundConstraint;
import com.laytonsmith.core.constructs.generics.constraints.VariadicTypeConstraint;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREGenericConstraintException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.EnumSet;

public class LowerBoundConstraint
extends BoundaryConstraint {
    public LowerBoundConstraint(Target t, String typename, LeftHandSideType lowerBound) {
        super(t, typename, lowerBound);
        if (lowerBound.equals(Mixed.TYPE.asLeftHandSideType())) {
            throw new CREGenericConstraintException("Cannot create a lower bound on mixed", t);
        }
    }

    @Override
    protected boolean isConcreteClassWithinConstraint(LeftHandSideType type, Environment env) {
        return this.bound.doesExtend(type, env);
    }

    public LeftHandSideType getLowerBound() {
        return this.bound;
    }

    @Override
    public String toSimpleString() {
        return this.getTypeName() + " super " + this.getLowerBound().getSimpleName();
    }

    public String toString() {
        return this.getTypeName() + " super " + String.valueOf(this.getLowerBound());
    }

    public EnumSet<ConstraintLocation> validLocations() {
        return EnumSet.of(ConstraintLocation.LHS);
    }

    @Override
    public String getConstraintName() {
        return "lower bound";
    }

    @Override
    protected ConstraintToConstraintValidator getConstraintToConstraintValidator(final Environment env) {
        return new ConstraintToConstraintValidator(){

            @Override
            public Boolean isWithinBounds(ConstructorConstraint lhs) {
                return null;
            }

            @Override
            public Boolean isWithinBounds(ExactTypeConstraint lhs) {
                return LowerBoundConstraint.this.isWithinConstraint(lhs.getType(), env);
            }

            @Override
            public Boolean isWithinBounds(LowerBoundConstraint lhs) {
                return LowerBoundConstraint.this.isWithinConstraint(lhs.getLowerBound(), env);
            }

            @Override
            public Boolean isWithinBounds(UpperBoundConstraint lhs) {
                return false;
            }

            @Override
            public Boolean isWithinBounds(UnboundedConstraint lhs) {
                throw new Error("Unexpected constraint combination.");
            }

            @Override
            public Boolean isWithinBounds(VariadicTypeConstraint lhs) {
                throw new Error("Unexpected constraint combination.");
            }
        };
    }

    @Override
    public ExactTypeConstraint convertFromDiamond(Target t) {
        return new ExactTypeConstraint(t, this.bound);
    }

    @Override
    public boolean supportsTypeUnions() {
        return true;
    }
}

