/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs.generics;

import com.laytonsmith.PureUtilities.ObjectHelpers;
import com.laytonsmith.core.compiler.signature.FunctionSignature;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.LeftHandSideType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.generics.ConcreteGenericParameter;
import com.laytonsmith.core.constructs.generics.ConstraintLocation;
import com.laytonsmith.core.constructs.generics.ConstraintValidator;
import com.laytonsmith.core.constructs.generics.Constraints;
import com.laytonsmith.core.constructs.generics.GenericDeclaration;
import com.laytonsmith.core.constructs.generics.GenericTypeParameters;
import com.laytonsmith.core.constructs.generics.LeftHandGenericUse;
import com.laytonsmith.core.constructs.generics.constraints.ExactTypeConstraint;
import com.laytonsmith.core.environments.Environment;
import java.util.ArrayList;
import java.util.List;

@ObjectHelpers.StandardField
public final class GenericParameters {
    private GenericDeclaration genericDeclaration;
    private final List<LeftHandSideType> parameters = new ArrayList<LeftHandSideType>();

    public GenericParameters subset(GenericDeclaration superDeclaration, String ... parameters) {
        GenericParameters newParams = new GenericParameters();
        for (int i = 0; i < parameters.length; ++i) {
            String p2 = parameters[i];
            for (int j = 0; j < superDeclaration.getParameterCount(); ++j) {
                if (!p2.equals(superDeclaration.getConstraints().get(j).getTypeName())) continue;
                newParams.parameters.add(this.parameters.get(j));
            }
        }
        newParams.genericDeclaration = superDeclaration;
        return newParams;
    }

    public static GenericParametersBuilder addParameter(CClassType forType, CClassType type, LeftHandGenericUse genericStatement, Environment env, Target t) {
        return GenericParameters.emptyBuilder(forType).addParameter(type, genericStatement, env, t);
    }

    public static GenericParametersBuilder addNativeParameter(CClassType forType, CClassType type, LeftHandGenericUse nativeGenericStatement) {
        return GenericParameters.emptyBuilder(forType).addParameter(type, nativeGenericStatement, null, Target.UNKNOWN);
    }

    public static GenericParametersBuilder emptyBuilder(CClassType forType) {
        GenericParameters gp = new GenericParameters();
        return new GenericParametersBuilder(gp, forType == null ? null : forType.getGenericDeclaration());
    }

    public static GenericParametersBuilder emptyBuilder(FunctionSignature forSignature) {
        GenericParameters gp = new GenericParameters();
        return new GenericParametersBuilder(gp, forSignature.getGenericDeclaration());
    }

    private GenericParameters() {
    }

    public List<LeftHandSideType> getParameters() {
        return new ArrayList<LeftHandSideType>(this.parameters);
    }

    public LeftHandGenericUse toLeftHandEquivalent(CClassType forType, Environment env) {
        Constraints[] constraints = new Constraints[this.parameters.size()];
        for (int i = 0; i < this.parameters.size(); ++i) {
            LeftHandSideType parameter = this.parameters.get(i);
            ExactTypeConstraint c = new ExactTypeConstraint(Target.UNKNOWN, parameter);
            constraints[i] = new Constraints(Target.UNKNOWN, ConstraintLocation.LHS, c);
        }
        LeftHandGenericUse lhgu = new LeftHandGenericUse(forType, Target.UNKNOWN, env, constraints);
        return lhgu;
    }

    public GenericTypeParameters toGenericTypeParameters(CClassType forType, Target t, Environment env) {
        GenericTypeParameters.GenericTypeParametersBuilder builder = GenericTypeParameters.emptyBuilder(forType, t, env);
        for (LeftHandSideType lhst : this.parameters) {
            builder.addParameter(lhst);
        }
        return builder.build();
    }

    public boolean equals(Object that) {
        return ObjectHelpers.DoEquals(this, that);
    }

    public int hashCode() {
        return ObjectHelpers.DoHashCode(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("<");
        boolean doComma = false;
        for (LeftHandSideType p2 : this.parameters) {
            if (doComma) {
                b.append(", ");
            }
            doComma = true;
            b.append(p2.toString());
        }
        b.append(">");
        return b.toString();
    }

    public static final class GenericParametersBuilder {
        private final GenericParameters p;

        private GenericParametersBuilder(GenericParameters p2, GenericDeclaration forType) {
            this.p = p2;
            p2.genericDeclaration = forType;
        }

        public GenericParametersBuilder addParameter(CClassType type, LeftHandGenericUse genericStatement, Environment env, Target t) {
            return this.addParameter(new ConcreteGenericParameter(type, genericStatement, t, env));
        }

        public GenericParametersBuilder addParameter(ConcreteGenericParameter type) {
            return this.addParameter(type.asLeftHandSideType());
        }

        public GenericParametersBuilder addParameter(LeftHandSideType type) {
            this.p.parameters.add(type);
            return this;
        }

        public GenericParametersBuilder addNativeParameter(CClassType nativeType, LeftHandGenericUse nativeGenericStatement) {
            return this.addParameter(nativeType, nativeGenericStatement, null, Target.UNKNOWN);
        }

        public boolean isEmpty() {
            return this.p.parameters.isEmpty();
        }

        public GenericParameters buildNative() {
            return this.build(Target.UNKNOWN, null);
        }

        public GenericParameters build(Target t, Environment env) {
            if (this.p.parameters.isEmpty()) {
                throw new Error("Empty parameter builders cannot be used. Check for this condition with isEmpty()");
            }
            ConstraintValidator.ValidateParametersToDeclaration(t, env, this.p, this.p.genericDeclaration, null);
            return this.p;
        }

        public GenericParameters buildWithoutValidation() {
            if (this.p.parameters.isEmpty()) {
                throw new Error("Empty parameter builders cannot be used. Check for this condition with isEmpty()");
            }
            return this.p;
        }
    }
}

