/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.federation;

import com.laytonsmith.core.federation.FederationConnection;
import com.laytonsmith.core.federation.FederationServer;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

public class Federation {
    private static Federation defaultFederation;
    public static final int MASTER_PORT = 55423;
    public static final int DYNAMIC_PORT_MINIMUM = 55424;
    public static final int DYNAMIC_PORT_MAXIMUM = 56423;
    public static final int DEAD_SERVER_TIMEOUT = 10;
    public static final int HEARTBEAT_INTERVAL = 5;
    private final int serverCount = 0;
    private final Object serverCountLock = new Object();
    private final Map<String, FederationConnection> federationConnections = new HashMap<String, FederationConnection>();
    private final Map<String, FederationServer> federationServers = new HashMap<String, FederationServer>();
    private final Socket masterSocket = null;

    public static Federation GetFederation() {
        if (defaultFederation == null) {
            defaultFederation = new Federation();
        }
        return defaultFederation;
    }

    public static void ClearFederation() {
        defaultFederation = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

