/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.core;

import com.laytonsmith.libs.org.postgresql.core.Logger;
import com.laytonsmith.libs.org.postgresql.core.ProtocolConnection;
import com.laytonsmith.libs.org.postgresql.core.v3.ConnectionFactoryImpl;
import com.laytonsmith.libs.org.postgresql.util.GT;
import com.laytonsmith.libs.org.postgresql.util.PSQLException;
import com.laytonsmith.libs.org.postgresql.util.PSQLState;
import java.sql.SQLException;
import java.util.Properties;

public abstract class ConnectionFactory {
    private static final Object[][] versions = new Object[][]{{"3", new ConnectionFactoryImpl()}, {"2", new com.laytonsmith.libs.org.postgresql.core.v2.ConnectionFactoryImpl()}};

    public static ProtocolConnection openConnection(String host, int port, String user2, String database, Properties info, Logger logger) throws SQLException {
        String protoName = info.getProperty("protocolVersion");
        for (int i = 0; i < versions.length; ++i) {
            ConnectionFactory factory;
            ProtocolConnection connection;
            String versionProtoName = (String)versions[i][0];
            if (protoName != null && !protoName.equals(versionProtoName) || (connection = (factory = (ConnectionFactory)versions[i][1]).openConnectionImpl(host, port, user2, database, info, logger)) == null) continue;
            return connection;
        }
        throw new PSQLException(GT.tr("A connection could not be made using the requested protocol {0}.", protoName), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    public abstract ProtocolConnection openConnectionImpl(String var1, int var2, String var3, String var4, Properties var5, Logger var6) throws SQLException;
}

