/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence;

import com.laytonsmith.PureUtilities.Pair;
import com.laytonsmith.core.GenericTreeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DataSourceModel {
    private final GenericTreeNode<Pair<String, String>> tree = new GenericTreeNode();

    public DataSourceModel(Map<String, Object> model) {
        if (model != null) {
            this.build(model, this.tree);
        }
    }

    public DataSourceModel(List<Pair<String, String>> list) {
        for (Pair<String, String> pair : list) {
            String[] key = pair.getKey().split("\\.");
            this.set(key, pair.getValue());
        }
    }

    private void build(Object node, GenericTreeNode<Pair<String, String>> treeNode) {
        if (node instanceof Map) {
            for (String key : ((Map)node).keySet()) {
                if (key.equals("_")) {
                    this.build(((Map)node).get(key), treeNode);
                    continue;
                }
                GenericTreeNode<Pair<String, String>> newNode = new GenericTreeNode<Pair<String, String>>(new Pair<String, Object>(key, null));
                treeNode.addChild(newNode);
                this.build(((Map)node).get(key), newNode);
            }
        } else {
            ((Pair)treeNode.data).setValue(node == null ? null : node.toString());
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (GenericTreeNode<Pair<String, String>> child : this.tree.getChildren()) {
            this.decompose(map, child);
        }
        return map;
    }

    public List<Pair<String[], String>> toList() {
        ArrayList<Pair<String[], String>> list = new ArrayList<Pair<String[], String>>();
        return list;
    }

    private void decompose(Map<String, Object> node, GenericTreeNode<Pair<String, String>> treeNode) {
        if (treeNode.hasChildren()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (treeNode.getData().getValue() != null) {
                map.put("_", treeNode.getData().getValue());
            }
            node.put(treeNode.getData().getKey(), map);
            for (GenericTreeNode<Pair<String, String>> child : treeNode.getChildren()) {
                this.decompose(map, child);
            }
        } else {
            node.put(treeNode.getData().getKey(), treeNode.getData().getValue());
        }
    }

    public String get(String[] key) {
        return this.getValue(new ArrayList<String>(Arrays.asList(key)), this.tree);
    }

    public void set(String[] key, String value) {
        this.setValue(new ArrayList<String>(Arrays.asList(key)), this.tree, value);
    }

    public void clearKey(String[] key) {
        this.set(key, null);
    }

    private String getValue(List<String> keys, GenericTreeNode<Pair<String, String>> treeNode) {
        String value = null;
        if (!keys.isEmpty()) {
            String key = keys.get(0);
            keys.remove(0);
            for (GenericTreeNode<Pair<String, String>> child : treeNode.getChildren()) {
                if (!child.getData().getKey().equals(key)) continue;
                return this.getValue(keys, child);
            }
        } else {
            value = treeNode.getData().getValue();
        }
        return value;
    }

    private void setValue(List<String> keys, GenericTreeNode<Pair<String, String>> treeNode, String value) {
        if (keys.isEmpty()) {
            treeNode.getData().setValue(value);
        } else {
            GenericTreeNode<Pair<String, Object>> found = null;
            String key = keys.get(0);
            keys.remove(0);
            for (GenericTreeNode<Pair<String, String>> child : treeNode.getChildren()) {
                if (!child.getData().getKey().equals(key)) continue;
                found = child;
                break;
            }
            if (found == null) {
                found = new GenericTreeNode<Pair<String, Object>>(new Pair<String, Object>(key, null));
                treeNode.addChild(found);
            }
            if (value == null && keys.isEmpty()) {
                for (int i = 0; i < treeNode.getNumberOfChildren(); ++i) {
                    GenericTreeNode<Pair<String, String>> node = treeNode.getChildAt(i);
                    if (!node.getData().getKey().equals(key)) continue;
                    treeNode.removeChildAt(i);
                    break;
                }
                return;
            }
            this.setValue(keys, found, value);
        }
    }

    public Set<String[]> keySet() {
        HashSet<String[]> keys = new HashSet<String[]>();
        for (GenericTreeNode<Pair<String, String>> child : this.tree.getChildren()) {
            this.traverse(child, new ArrayList<String>(), keys);
        }
        return keys;
    }

    private void traverse(GenericTreeNode<Pair<String, String>> treeNode, List<String> ongoingKey, Set<String[]> keys) {
        if (treeNode.hasChildren()) {
            ongoingKey.add(treeNode.getData().getKey());
            if (treeNode.getData().getValue() != null) {
                keys.add(ongoingKey.toArray(new String[ongoingKey.size()]));
            }
            for (GenericTreeNode<Pair<String, String>> child : treeNode.getChildren()) {
                this.traverse(child, ongoingKey, keys);
            }
            ongoingKey.remove(ongoingKey.size() - 1);
        } else {
            ongoingKey.add(treeNode.getData().getKey());
            keys.add(ongoingKey.toArray(new String[ongoingKey.size()]));
            ongoingKey.remove(ongoingKey.size() - 1);
        }
    }
}

