/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading.ClassMirror;

import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.AbstractElementMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.AnnotationMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassReferenceMirror;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ModifierMirror;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import java.lang.reflect.Field;
import java.util.List;

public class FieldMirror
extends AbstractElementMirror {
    private static final long serialVersionUID = 1L;
    private final Object value;
    private Field field;

    public FieldMirror(Field field) {
        super(field);
        this.field = field;
        Object value = null;
        try {
            value = field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException exception) {
            // empty catch block
        }
        this.value = value;
    }

    public FieldMirror(ClassReferenceMirror parent, List<AnnotationMirror> annotations, ModifierMirror modifiers, ClassReferenceMirror type, String name, Object value, String signature) {
        super(parent, annotations, modifiers, type, name, signature);
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return StringUtils.Join(this.annotations, "\n") + (this.annotations.isEmpty() ? "" : "\n") + (this.modifiers.toString() + " " + String.valueOf(this.type)).trim() + " " + this.name + " = " + (this.value == null ? "null" : this.value.toString()) + ";";
    }

    FieldMirror(ClassReferenceMirror parent, ModifierMirror modifiers, ClassReferenceMirror type, String name, Object value, String signature) {
        super(parent, null, modifiers, type, name, signature);
        this.value = value;
    }

    public Field loadField() throws ClassNotFoundException {
        return this.loadField(FieldMirror.class.getClassLoader(), true);
    }

    public Field loadField(ClassLoader loader, boolean initialize) throws ClassNotFoundException {
        if (this.field != null) {
            return this.field;
        }
        Class parent = this.loadParentClass(loader, initialize);
        NoSuchFieldException nsfe = null;
        do {
            try {
                this.field = parent.getDeclaredField(this.name);
                break;
            }
            catch (NoSuchFieldException ex) {
                nsfe = ex;
            }
            catch (SecurityException ex) {
                throw new RuntimeException(ex);
            }
        } while ((parent = parent.getSuperclass()) != null);
        try {
            this.field = this.loadParentClass(loader, initialize).getField(this.name);
        }
        catch (NoSuchFieldException ex) {
            nsfe = ex;
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        if (this.field == null && nsfe != null) {
            throw new RuntimeException(nsfe);
        }
        return this.field;
    }
}

