/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs.generics.constraints;

import com.laytonsmith.PureUtilities.ObjectHelpers;
import com.laytonsmith.core.constructs.Auto;
import com.laytonsmith.core.constructs.InstanceofUtil;
import com.laytonsmith.core.constructs.LeftHandSideType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.generics.ConcreteGenericParameter;
import com.laytonsmith.core.constructs.generics.ConstraintLocation;
import com.laytonsmith.core.constructs.generics.ConstraintToConstraintValidator;
import com.laytonsmith.core.constructs.generics.Constraints;
import com.laytonsmith.core.constructs.generics.constraints.Constraint;
import com.laytonsmith.core.constructs.generics.constraints.ConstructorConstraint;
import com.laytonsmith.core.constructs.generics.constraints.LowerBoundConstraint;
import com.laytonsmith.core.constructs.generics.constraints.UnboundedConstraint;
import com.laytonsmith.core.constructs.generics.constraints.UpperBoundConstraint;
import com.laytonsmith.core.constructs.generics.constraints.VariadicTypeConstraint;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREGenericConstraintException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import java.util.EnumSet;
import java.util.Objects;

public class ExactTypeConstraint
extends Constraint {
    @ObjectHelpers.StandardField
    private final LeftHandSideType type;
    private Constraints declarationBounds;

    public static ExactTypeConstraint AsUnboundedWildcard(Target t, Constraints declarationBounds) {
        ExactTypeConstraint type;
        Objects.requireNonNull(declarationBounds);
        try {
            type = new ExactTypeConstraint(t);
        }
        catch (ConfigCompileException ex) {
            throw new Error(ex);
        }
        type.declarationBounds = declarationBounds;
        return type;
    }

    private ExactTypeConstraint(Target t) throws ConfigCompileException {
        super(t, "?");
        this.type = null;
    }

    public ExactTypeConstraint(Target t, LeftHandSideType type) {
        super(t, type.val());
        Objects.requireNonNull(type);
        this.type = type;
    }

    public EnumSet<ConstraintLocation> validLocations() {
        return EnumSet.of(ConstraintLocation.LHS, ConstraintLocation.RHS);
    }

    @Override
    public String getConstraintName() {
        return this.type == null ? "?" : this.type.val();
    }

    @Override
    public boolean isWithinConstraint(LeftHandSideType type, Environment env) {
        if (this.type == null) {
            return this.declarationBounds.withinBounds(type, env);
        }
        if (this.type.getTypes().size() != type.getTypes().size()) {
            return false;
        }
        for (int i = 0; i < this.type.getTypes().size(); ++i) {
            ConcreteGenericParameter theirs = type.getTypes().get(i);
            ConcreteGenericParameter ours = this.type.getTypes().get(i);
            if (!(!ours.getType().getNakedType(env).equals(theirs.getType().getNakedType(env)) || ours.getLeftHandGenericUse() == null && theirs.getLeftHandGenericUse() != null || ours.getLeftHandGenericUse() != null && theirs.getLeftHandGenericUse() == null) && (ours.getLeftHandGenericUse() == null || ours.getLeftHandGenericUse().isWithinBounds(env, theirs.getLeftHandGenericUse()))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected ConstraintToConstraintValidator getConstraintToConstraintValidator(final Environment env) {
        return new ConstraintToConstraintValidator(){

            @Override
            public Boolean isWithinBounds(ConstructorConstraint lhs) {
                return false;
            }

            @Override
            public Boolean isWithinBounds(ExactTypeConstraint lhs) {
                if (ExactTypeConstraint.this.equals(lhs)) {
                    return true;
                }
                if (ExactTypeConstraint.this.getType().isAuto() || lhs.getType().isAuto()) {
                    return true;
                }
                if (!ExactTypeConstraint.this.getType().getNakedType(Target.UNKNOWN, env).equals(lhs.getType().getNakedType(Target.UNKNOWN, env))) {
                    return false;
                }
                return InstanceofUtil.isInstanceof(lhs.getType(), ExactTypeConstraint.this.getType(), env);
            }

            @Override
            public Boolean isWithinBounds(LowerBoundConstraint lhs) {
                return false;
            }

            @Override
            public Boolean isWithinBounds(UpperBoundConstraint lhs) {
                return false;
            }

            @Override
            public Boolean isWithinBounds(UnboundedConstraint lhs) {
                throw new Error("Unexpected constraint combination.");
            }

            @Override
            public Boolean isWithinBounds(VariadicTypeConstraint lhs) {
                throw new Error("Unexpected constraint combination.");
            }
        };
    }

    @Override
    public ExactTypeConstraint convertFromDiamond(Target t) {
        return this;
    }

    public LeftHandSideType getType() {
        return this.type;
    }

    @Override
    public String toSimpleString() {
        return this.type == null ? "?" : this.type.getSimpleName();
    }

    public String toString() {
        return this.type == null ? "?" : this.type.val();
    }

    public boolean equals(Object that) {
        return ObjectHelpers.DoEquals(this, that);
    }

    public int hashCode() {
        return ObjectHelpers.DoHashCode(this);
    }

    @Override
    public boolean supportsTypeUnions() {
        return false;
    }

    @Override
    public ExactTypeConstraint convertFromNull(Target t) throws CREGenericConstraintException {
        return new ExactTypeConstraint(t, Auto.LHSTYPE);
    }
}

