/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.core;
import com.laytonsmith.annotations.hide;
import com.laytonsmith.annotations.noboilerplate;
import com.laytonsmith.annotations.noprofile;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.Optimizable;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.compiler.analysis.StaticAnalysis;
import com.laytonsmith.core.compiler.signature.FunctionSignatures;
import com.laytonsmith.core.compiler.signature.SignatureBuilder;
import com.laytonsmith.core.constructs.CBareString;
import com.laytonsmith.core.constructs.CBracket;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CEntry;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CKeyword;
import com.laytonsmith.core.constructs.CLabel;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CSymbol;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.IVariableList;
import com.laytonsmith.core.constructs.InstanceofUtil;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Token;
import com.laytonsmith.core.constructs.generics.GenericParameters;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CRENotFoundException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.functions.DataHandling;
import com.laytonsmith.core.functions.DummyFunction;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;

@core
public class Compiler {
    public static String docs() {
        return "Compiler internal functions should be declared here. If you're reading this from anywhere but the source code, there's a bug, because these functions shouldn't be public or used in a script.";
    }

    @api
    @noprofile
    @noboilerplate
    @hide(value="This is only used internally by the compiler.")
    public static class __unsafe_assign__
    extends DataHandling.assign {
        public static final String NAME = "__unsafe_assign__";

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public Mixed exec(Target t, Environment env, GenericParameters generics, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            IVariable var;
            Mixed val;
            String varName;
            CClassType type;
            if (args.length == 3) {
                type = (CClassType)args[0];
                varName = ((IVariable)args[1]).getVariableName();
                val = args[2];
            } else {
                type = null;
                varName = ((IVariable)args[0]).getVariableName();
                val = args[1];
            }
            IVariableList list = env.getEnv(GlobalEnv.class).GetVarList();
            if (val instanceof IVariable) {
                IVariable ivar = (IVariable)val;
                val = list.get(ivar.getVariableName(), ivar.getTarget(), env).ival();
            }
            if ((var = list.get(varName)) == null || type != null && !type.equals(var.getDefinedType())) {
                var = new IVariable(type, varName, val, t);
                list.set(var);
            } else {
                var.setIval(val);
            }
            return var;
        }
    }

    @api
    @noprofile
    @hide(value="This is only used internally by the compiler.")
    public static class __cast__
    extends DummyFunction
    implements Optimizable {
        public static final String NAME = "__cast__";

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public FunctionSignatures getSignatures() {
            return new SignatureBuilder(CClassType.AUTO).param(Mixed.TYPE, "value", "The value.").param(CClassType.TYPE, "type", "The type.").throwsEx(CRECastException.class, "When value cannot be cast to type.").build();
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "mixed {mixed value, ClassType type} Used internally by the compiler. You shouldn't use it.";
        }

        @Override
        public Mixed exec(Target t, Environment env, GenericParameters generics, Mixed ... args) throws ConfigRuntimeException {
            Mixed value = args[0];
            CClassType type = ArgumentValidation.getClassType(args[1], t);
            if (!InstanceofUtil.isInstanceof(value, type, env)) {
                throw new CRECastException("Cannot cast from " + value.typeof().getSimpleName() + " to " + type.getSimpleName() + ".", t);
            }
            return value;
        }

        @Override
        public CClassType typecheck(StaticAnalysis analysis, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
            if (ast.numberOfChildren() != 2) {
                return super.typecheck(analysis, ast, env, exceptions);
            }
            ParseTree valNode = ast.getChildAt(0);
            CClassType valType = analysis.typecheck(valNode, env, exceptions);
            StaticAnalysis.requireType(valType, Mixed.TYPE, valType.getTarget(), env, exceptions);
            ParseTree typeNode = ast.getChildAt(1);
            CClassType typeType = analysis.typecheck(typeNode, env, exceptions);
            StaticAnalysis.requireType(typeType, CClassType.TYPE, typeNode.getTarget(), env, exceptions);
            if (!(typeNode.getData() instanceof CClassType)) {
                assert (!exceptions.isEmpty()) : "Missing compile-time type error for cast type argument.";
                return CClassType.AUTO;
            }
            CClassType castToType = (CClassType)typeNode.getData();
            if (castToType.equals(valType)) {
                env.getEnv(CompilerEnvironment.class).addCompilerWarning(ast.getFileOptions(), new CompilerWarning("Redundant cast to " + castToType.getSimpleName(), ast.getTarget(), FileOptions.SuppressWarning.UselessCode));
            }
            if (!InstanceofUtil.isInstanceof(valType, castToType, env) && !InstanceofUtil.isInstanceof(castToType, valType, env)) {
                exceptions.add(new ConfigCompileException("Cannot cast from " + valType.getSimpleName() + " to " + castToType.getSimpleName() + ".", ast.getTarget()));
            }
            return castToType;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC, Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException, ConfigCompileGroupException {
            CFunction cf;
            ParseTree valNode = children.get(0);
            Mixed mixed = valNode.getData();
            if (mixed instanceof CFunction && (cf = (CFunction)mixed).getCachedFunction() != null && cf.getCachedFunction().getName().equals(NAME) && valNode.numberOfChildren() == 2) {
                ParseTree typeNode = children.get(1);
                ParseTree childTypeNode = valNode.getChildAt(1);
                Mixed mixed2 = typeNode.getData();
                if (mixed2 instanceof CClassType) {
                    CClassType childType;
                    CClassType type = (CClassType)mixed2;
                    mixed2 = childTypeNode.getData();
                    if (mixed2 instanceof CClassType && InstanceofUtil.isInstanceof(childType = (CClassType)mixed2, type, env)) {
                        return valNode;
                    }
                }
            }
            return null;
        }
    }

    @api
    @hide(value="This is more of a compiler feature, rather than a function, and so it is hidden from normal documentation.")
    public static class __smart_string__
    extends AbstractFunction {
        public static final String NAME = "__smart_string__";

        public static Token getDumbStringOrFail(Token token) throws ConfigCompileException {
            if (token.type != Token.TType.SMART_STRING) {
                throw new Error("This method can only be called on SMART_STRING tokens.");
            }
            String original = token.value;
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < original.length(); ++i) {
                char c2;
                char c = original.charAt(i);
                char c3 = c2 = i + 1 < original.length() ? original.charAt(i + 1) : (char)'\u0000';
                if (c == '\\') {
                    if (c2 == '@' || c2 == '\\') {
                        b.append(c2);
                        ++i;
                        continue;
                    }
                    throw new ConfigCompileException("Invalid unhandled escape sequence passed to __smart_string__: \\" + c2, token.target);
                }
                if (c == '@') {
                    throw new ConfigCompileException("Cannot use smart strings here", token.target);
                }
                b.append(c);
            }
            return new Token(Token.TType.STRING, b.toString(), token.target.copy());
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, GenericParameters generics, Mixed ... args) throws ConfigRuntimeException {
            throw new UnsupportedOperationException(this.getName() + " should have been compiled out. If you are reaching this, an error has occurred in the parser. Please report this error to the developers.");
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "none {string} This is a compiler construct, and is not normally used directly. It is created via double quoted strings.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ParseTree postParseRewrite(ParseTree ast, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Set<ConfigCompileException> exceptions) {
            List<ParseTree> children = ast.getChildren();
            Target t = ast.getTarget();
            FileOptions fileOptions = ast.getFileOptions();
            try {
                if (children.size() != 1) {
                    throw new ConfigCompileException(this.getName() + " can only take one parameter", t);
                }
                if (!children.get(0).getData().isInstanceOf(CString.TYPE)) {
                    throw new ConfigCompileException("Only hardcoded strings may be passed into " + this.getName(), t);
                }
                String value = children.get(0).getData().val();
                if (value.isEmpty()) {
                    return new ParseTree(new CString("", t), fileOptions);
                }
                StringBuilder b = new StringBuilder();
                boolean inBrace = false;
                boolean inSimpleVar = false;
                boolean isDumbString = true;
                ParseTree root = new ParseTree(null, fileOptions);
                for (int i = 0; i < value.length(); ++i) {
                    char c2;
                    char c = value.charAt(i);
                    char c3 = c2 = i + 1 < value.length() ? value.charAt(i + 1) : (char)'\u0000';
                    if (c == '\\') {
                        if (c2 == '@' || c2 == '\\') {
                            b.append(c2);
                            ++i;
                            continue;
                        }
                        throw new ConfigCompileException("Invalid unhandled escape sequence passed to " + this.getName() + ": \\" + c2, t);
                    }
                    if (c == '@') {
                        isDumbString = false;
                        if (c2 == '{') {
                            inBrace = true;
                            ++i;
                        } else if (Character.isLetterOrDigit(c2) || c2 == '_') {
                            inSimpleVar = true;
                        } else {
                            throw new ConfigCompileException("Unexpected \"@\" in smart string. If you want a literal at sign, escape it with \"\\@\".", t);
                        }
                        if (b.length() <= 0) continue;
                        root.addChild(new ParseTree(new CString(b.toString(), t), fileOptions));
                        b = new StringBuilder();
                        continue;
                    }
                    if (inSimpleVar && !Character.isLetterOrDigit(c) && c != '_') {
                        String vname = b.toString();
                        b = new StringBuilder();
                        root.addChild(new ParseTree(new IVariable("@" + vname, t), fileOptions));
                        inSimpleVar = false;
                    }
                    if (inBrace && c == '}') {
                        String complex = b.toString().trim();
                        b = new StringBuilder();
                        inBrace = false;
                        if (!complex.matches("[a-zA-Z0-9_]+")) continue;
                        root.addChild(new ParseTree(new IVariable("@" + complex, t), fileOptions));
                        continue;
                    }
                    b.append(c);
                }
                if (isDumbString) {
                    return new ParseTree(new CString(b.toString(), t), fileOptions);
                }
                if (inBrace) {
                    throw new ConfigCompileException("Missing end brace (}) in smart string", t);
                }
                if (inSimpleVar) {
                    root.addChild(new ParseTree(new IVariable("@" + b.toString(), t), fileOptions));
                } else if (b.length() > 0) {
                    root.addChild(new ParseTree(new CString(b.toString(), t), fileOptions));
                }
                assert (root.numberOfChildren() != 0) : "Empty strings should have already been handled.";
                if (root.numberOfChildren() == 1) {
                    ParseTree child = root.getChildAt(0);
                    if (child.getData() instanceof CString) {
                        return child;
                    }
                    root.setData(new CFunction("string", t));
                } else {
                    root.setData(new CFunction("concat", t));
                }
                return root;
            }
            catch (ConfigCompileException e) {
                exceptions.add(e);
                return null;
            }
        }
    }

    @api
    @hide(value="This is only used internally by the compiler, and will be removed at some point.")
    public static class __cbrace__
    extends DummyFunction
    implements Optimizable {
        public static final String NAME = "__cbrace__";

        @Override
        public Mixed exec(Target t, Environment environment, GenericParameters generics, Mixed ... args) throws ConfigRuntimeException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            throw new ConfigCompileException("Unexpected use of braces", t);
        }
    }

    @api
    @hide(value="This is only used internally by the compiler, and will be removed at some point.")
    public static class __cbracket__
    extends DummyFunction
    implements Optimizable {
        @Override
        public Mixed exec(Target t, Environment environment, GenericParameters generics, Mixed ... args) throws ConfigRuntimeException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            ParseTree node;
            if (children.isEmpty()) {
                node = new ParseTree(CVoid.VOID, fileOptions);
            } else if (children.size() == 1) {
                node = children.get(0);
            } else {
                throw new ConfigCompileException("Unexpected children. This appears to be an error, as __autoconcat__ should have already been processed. Please report this error to the developer.", t);
            }
            return new ParseTree(new CBracket(node), fileOptions);
        }
    }

    @api
    @noprofile
    @hide(value="This is only used for testing.")
    public static class dyn
    extends DummyFunction {
        @Override
        public String docs() {
            return "exception {[argument]} Registers as a dynamic component, for optimization testing; that is to say, this will not be optimizable ever. It simply returns the argument provided, or void if none.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, GenericParameters generics, Mixed ... args) throws ConfigRuntimeException {
            if (args.length == 0) {
                return CVoid.VOID;
            }
            return args[0];
        }
    }

    @api
    @hide(value="This is only used for testing unexpected error handling.")
    @noboilerplate
    public static class npe
    extends DummyFunction {
        @Override
        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Mixed exec(Target t, Environment env, GenericParameters generics, Mixed ... args) throws ConfigRuntimeException {
            String s = null;
            if (args.length == 1) {
                s = args[0].val();
            }
            if (s == null) {
                throw new NullPointerException();
            }
            throw new NullPointerException(s);
        }
    }

    @api
    @noprofile
    @hide(value="This is only used internally by the compiler.")
    public static class __type_ref__
    extends DummyFunction
    implements Optimizable {
        public static final String NAME = "__type_ref__";
        public static final String TYPE_REGEX = "[a-zA-Z0-9\\-_\\.]+";

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class};
        }

        @Override
        public String docs() {
            return "mixed {string} Used internally by the compiler. You shouldn't use it.";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public Mixed exec(Target t, Environment env, GenericParameters generics, Mixed ... args) throws ConfigRuntimeException {
            throw new CRENotFoundException("\"" + args[0].val() + "\" cannot be resolved to a type.", t);
        }

        @Override
        public CClassType getReturnType(Target t, List<CClassType> argTypes, List<Target> argTargets, Environment env, Set<ConfigCompileException> exceptions) {
            return CClassType.TYPE;
        }

        public static ParseTree createASTNode(String typeName, Target t, FileOptions fileOptions) {
            ParseTree node = new ParseTree(new CFunction(NAME, t), fileOptions);
            node.addChild(new ParseTree(new CString(typeName, t), fileOptions, true));
            return node;
        }

        public static ParseTree createFromBareStringOrConcats(ParseTree typeNode) {
            if (typeNode.getData().getClass().equals(CBareString.class) && typeNode.getData().val().matches(TYPE_REGEX)) {
                return __type_ref__.createASTNode(typeNode.getData().val(), typeNode.getTarget(), typeNode.getFileOptions());
            }
            if (typeNode.getData() instanceof CFunction && typeNode.getData().val().equals("concat") && typeNode.getChildren().size() == 2) {
                String typeName = null;
                ParseTree node = typeNode;
                while (true) {
                    String[] cClassTypeStrSplit;
                    ParseTree child1 = node.getChildAt(0);
                    ParseTree child2 = node.getChildAt(1);
                    if (child2.getData() instanceof CBareString) {
                        typeName = child2.getData().val() + (String)(typeName == null ? "" : "." + typeName);
                    } else if (child2.getData() instanceof CClassType) {
                        cClassTypeStrSplit = child2.getData().val().split("\\.");
                        typeName = cClassTypeStrSplit[cClassTypeStrSplit.length - 1] + (String)(typeName == null ? "" : "." + typeName);
                    } else {
                        return null;
                    }
                    if (child1.getData() instanceof CBareString) {
                        typeName = child1.getData().val() + "." + typeName;
                        break;
                    }
                    if (child1.getData() instanceof CClassType) {
                        cClassTypeStrSplit = child1.getData().val().split("\\.");
                        typeName = cClassTypeStrSplit[cClassTypeStrSplit.length - 1] + "." + typeName;
                        break;
                    }
                    if (!(child1.getData() instanceof CFunction) || !"concat".equals(child1.getData().val()) || child1.getChildren().size() != 2) {
                        return null;
                    }
                    node = child1;
                }
                if (typeName.matches(TYPE_REGEX)) {
                    return __type_ref__.createASTNode(typeName, typeNode.getTarget(), typeNode.getFileOptions());
                }
            }
            return null;
        }

        @Override
        public ParseTree postParseRewrite(ParseTree ast, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Set<ConfigCompileException> exceptions) {
            String typeName = ast.getChildAt(0).getData().val();
            try {
                CClassType classType = CClassType.get(FullyQualifiedClassName.forName(typeName, ast.getTarget(), env));
                return new ParseTree(classType, ast.getFileOptions());
            }
            catch (CRECastException | ClassNotFoundException e) {
                return null;
            }
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            if (!StaticAnalysis.enabled()) {
                throw new ConfigCompileException("\"" + children.get(0).getData().val() + "\" cannot be resolved to a type.", t);
            }
            return null;
        }
    }

    @api
    @noprofile
    @hide(value="This is only used internally by the compiler.")
    public static class __statements__
    extends DummyFunction {
        public static final String NAME = "__statements__";

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public String docs() {
            return "void {[...]} Used internally by the compiler. You shouldn't use it.";
        }

        @Override
        public Mixed exec(Target t, Environment env, GenericParameters generics, Mixed ... args) throws ConfigRuntimeException {
            return CVoid.VOID;
        }

        @Override
        public CClassType getReturnType(Target t, List<CClassType> argTypes, List<Target> argTargets, Environment env, Set<ConfigCompileException> exceptions) {
            for (CClassType argType : argTypes) {
                if (argType != null) continue;
                return null;
            }
            return CVoid.TYPE;
        }

        @Override
        public boolean preResolveVariables() {
            return false;
        }

        @Override
        public ParseTree postParseRewrite(ParseTree ast, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Set<ConfigCompileException> exceptions) {
            for (ParseTree child : ast.getChildren()) {
                if (child.getData() instanceof CFunction || child.getData() instanceof CBareString && !(child.getData() instanceof CKeyword)) continue;
                exceptions.add(new ConfigCompileException("Not a statement.", child.getTarget()));
            }
            return null;
        }
    }

    @api
    @noprofile
    @hide(value="This is only used internally by the compiler.")
    public static class __autoconcat__
    extends DummyFunction {
        public static final String NAME = "__autoconcat__";

        @Override
        public Mixed exec(Target t, Environment env, GenericParameters generics, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            throw new Error("Should not have gotten here, __autoconcat__ was not removed before runtime.");
        }

        @Override
        public String docs() {
            return "string {var1, [var2...]} This function should only be used by the compiler, behavior may be undefined if it is used in code.";
        }

        public static ParseTree rewrite(List<ParseTree> list, boolean returnSConcat, Set<Class<? extends Environment.EnvironmentImpl>> envs) throws ConfigCompileException {
            ParseTree tree;
            FileOptions options;
            ParseTree node;
            Cloneable typeNode;
            Cloneable ac;
            CSymbol sy;
            ParseTree node2;
            int i;
            boolean inSymbolMode = false;
            __autoconcat__.rewriteParenthesis(list);
            for (i = list.size() - 2; i >= 0; --i) {
                node2 = list.get(i + 1);
                if (!(node2.getData() instanceof CSymbol) || !((CSymbol)node2.getData()).isAssignment()) continue;
                ParseTree lhs = list.get(i);
                if (i < list.size() - 3) {
                    CFunction cf;
                    Mixed mixed;
                    ArrayList<ParseTree> valChildren = new ArrayList<ParseTree>();
                    int index = i + 2;
                    while (list.size() > index + 1 && (list.get(index).getData() instanceof CSymbol || (mixed = list.get(index).getData()) instanceof CFunction && (cf = (CFunction)mixed).val().equals("p") && list.get(index).numberOfChildren() == 1 && (list.get(index).getChildAt(0).getData() instanceof CClassType || __type_ref__.createFromBareStringOrConcats(list.get(index).getChildAt(0)) != null))) {
                        valChildren.add(list.get(index));
                        list.remove(index);
                    }
                    valChildren.add(list.get(index));
                    list.remove(index);
                    while (list.size() > index + 1 && list.get(index).getData() instanceof CSymbol) {
                        do {
                            valChildren.add(list.get(index));
                            list.remove(index);
                        } while (list.size() > index && list.get(index).getData() instanceof CSymbol);
                        if (list.size() <= index) {
                            throw new ConfigCompileException("Unexpected end of statement", list.get(list.size() - 1).getTarget());
                        }
                        valChildren.add(list.get(index));
                        list.remove(index);
                    }
                    list.add(i + 2, __autoconcat__.rewrite(valChildren, returnSConcat, envs));
                }
                if (list.size() <= i + 2) {
                    throw new ConfigCompileException("Unexpected end of statement", list.get(i).getTarget());
                }
                ParseTree rhs = list.get(i + 2);
                CSymbol sy2 = (CSymbol)node2.getData();
                String conversionFunction = sy2.convertAssignment();
                if (conversionFunction != null) {
                    ParseTree rhsReplacement = new ParseTree(new CFunction(conversionFunction, node2.getTarget()), node2.getFileOptions());
                    rhsReplacement.addChild(lhs);
                    rhsReplacement.addChild(rhs);
                    rhs = rhsReplacement;
                }
                ParseTree assignNode = new ParseTree(new CFunction("assign", node2.getTarget()), node2.getFileOptions());
                assignNode.addChild(lhs);
                assignNode.addChild(rhs);
                list.set(i, assignNode);
                list.remove(i + 1);
                list.remove(i + 1);
            }
            for (i = 0; i < list.size(); ++i) {
                node2 = list.get(i);
                if (node2.getData() instanceof CSymbol) {
                    inSymbolMode = true;
                }
                if (!(node2.getData() instanceof CSymbol) || !((CSymbol)node2.getData()).isPostfix() || i - 1 < 0 || list.get(i - 1).getData() instanceof CSymbol) continue;
                sy = (CSymbol)node2.getData();
                ParseTree conversion = sy.val().equals("++") ? new ParseTree(new CFunction("postinc", node2.getTarget()), node2.getFileOptions()) : new ParseTree(new CFunction("postdec", node2.getTarget()), node2.getFileOptions());
                conversion.addChild(list.get(i - 1));
                list.set(i - 1, conversion);
                list.remove(i);
                --i;
            }
            if (inSymbolMode) {
                try {
                    for (i = 0; i < list.size() - 1; ++i) {
                        ParseTree conversion;
                        node2 = list.get(i);
                        if (!(node2.getData() instanceof CSymbol) || !((CSymbol)node2.getData()).isUnary()) continue;
                        if (node2.getData().val().equals("-") || node2.getData().val().equals("+")) {
                            if ((i != 0 && !(list.get(i - 1).getData() instanceof CSymbol) || list.get(i + 1).getData() instanceof CSymbol) && (i == 0 || !(list.get(i - 1).getData() instanceof CLabel))) continue;
                            conversion = node2.getData().val().equals("-") ? new ParseTree(new CFunction("neg", node2.getTarget()), node2.getFileOptions()) : new ParseTree(new CFunction("p", node2.getTarget()), node2.getFileOptions());
                        } else {
                            conversion = new ParseTree(new CFunction(((CSymbol)node2.getData()).convert(), node2.getTarget()), node2.getFileOptions());
                        }
                        ac = new ArrayList();
                        list.set(i, conversion);
                        for (int k = i + 1; k < list.size(); ++k) {
                            ParseTree m = list.get(k);
                            if (m.getData() instanceof CSymbol && ((CSymbol)m.getData()).isUnary()) {
                                ac.add(m);
                                list.remove(k);
                                --k;
                                --i;
                                continue;
                            }
                            ac.add(m);
                            list.remove(k);
                            break;
                        }
                        conversion.addChild(__autoconcat__.rewrite((List<ParseTree>)((Object)ac), returnSConcat, envs));
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConfigCompileException("Unexpected symbol (" + list.get(list.size() - 1).getData().val() + ")", list.get(list.size() - 1).getTarget());
                }
            }
            for (i = list.size() - 2; i >= 0; --i) {
                CFunction cf;
                node2 = list.get(i);
                ac = node2.getData();
                if (!(ac instanceof CFunction) || !(cf = (CFunction)ac).val().equals("p") || node2.numberOfChildren() != 1) continue;
                typeNode = node2.getChildAt(0);
                if (!((ParseTree)typeNode).getData().isInstanceOf(CClassType.TYPE)) {
                    ParseTree convertedTypeNode = __type_ref__.createFromBareStringOrConcats((ParseTree)typeNode);
                    if (convertedTypeNode == null) continue;
                    typeNode = convertedTypeNode;
                }
                ParseTree castNode = new ParseTree(new CFunction("__cast__", node2.getTarget()), node2.getFileOptions());
                castNode.addChild(list.get(i + 1));
                castNode.addChild((ParseTree)typeNode);
                list.set(i, castNode);
                list.remove(i + 1);
            }
            if (inSymbolMode) {
                try {
                    ParseTree next;
                    for (i = 0; i < list.size() - 1; ++i) {
                        next = list.get(i + 1);
                        typeNode = next.getData();
                        if (!(typeNode instanceof CSymbol) || !(sy = (CSymbol)typeNode).isExponential()) continue;
                        __autoconcat__.rewriteBinaryOperator(list, sy, i--);
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        next = list.get(i + 1);
                        typeNode = next.getData();
                        if (!(typeNode instanceof CSymbol) || !(sy = (CSymbol)typeNode).isMultaplicative() || sy.isAssignment()) continue;
                        __autoconcat__.rewriteBinaryOperator(list, sy, i--);
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        next = list.get(i + 1);
                        typeNode = next.getData();
                        if (!(typeNode instanceof CSymbol) || !(sy = (CSymbol)typeNode).isAdditive() || sy.isAssignment()) continue;
                        __autoconcat__.rewriteBinaryOperator(list, sy, i--);
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        next = list.get(i + 1);
                        typeNode = next.getData();
                        if (!(typeNode instanceof CSymbol) || !(sy = (CSymbol)typeNode).isRelational()) continue;
                        __autoconcat__.rewriteBinaryOperator(list, sy, i--);
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        next = list.get(i + 1);
                        typeNode = next.getData();
                        if (!(typeNode instanceof CSymbol) || !(sy = (CSymbol)typeNode).isEquality()) continue;
                        __autoconcat__.rewriteBinaryOperator(list, sy, i--);
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        next = list.get(i + 1);
                        typeNode = next.getData();
                        if (!(typeNode instanceof CSymbol) || !(sy = (CSymbol)typeNode).isDefaultAnd()) continue;
                        __autoconcat__.rewriteBinaryOperator(list, sy, i--);
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        next = list.get(i + 1);
                        typeNode = next.getData();
                        if (!(typeNode instanceof CSymbol) || !(sy = (CSymbol)typeNode).isDefaultOr()) continue;
                        __autoconcat__.rewriteBinaryOperator(list, sy, i--);
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        next = list.get(i + 1);
                        typeNode = next.getData();
                        if (!(typeNode instanceof CSymbol) || !(sy = (CSymbol)typeNode).isLogicalAnd()) continue;
                        __autoconcat__.rewriteBinaryOperator(list, sy, i--);
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        next = list.get(i + 1);
                        typeNode = next.getData();
                        if (!(typeNode instanceof CSymbol) || !(sy = (CSymbol)typeNode).isLogicalOr()) continue;
                        __autoconcat__.rewriteBinaryOperator(list, sy, i--);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConfigCompileException("Unexpected symbol (" + list.get(list.size() - 1).getData().val() + ")", list.get(list.size() - 1).getTarget());
                }
            }
            block30: for (int k = 0; k < list.size(); ++k) {
                ParseTree node3;
                ParseTree typeNode2 = list.get(k);
                ParseTree convertedTypeNode = __type_ref__.createFromBareStringOrConcats(typeNode2);
                ParseTree originalTypeNode = typeNode2;
                if (convertedTypeNode != null) {
                    typeNode2 = convertedTypeNode;
                }
                if (convertedTypeNode == null && !typeNode2.getData().equals(CVoid.VOID) && !typeNode2.getData().isInstanceOf(CClassType.TYPE)) continue;
                if (k == list.size() - 1) break;
                if (list.get(k + 1).getData() instanceof CFunction) {
                    switch (list.get(k + 1).getData().val()) {
                        case "assign": 
                        case "proc": {
                            if (list.get(k + 1).getData().val().equals("assign") && typeNode2.getData().equals(CVoid.VOID)) {
                                throw new ConfigCompileException("Variables may not be of type void", list.get(k + 1).getTarget());
                            }
                            list.remove(k);
                            List<ParseTree> children = list.get(k).getChildren();
                            children.add(0, typeNode2);
                            list.get(k).setChildren(children);
                            break;
                        }
                        default: {
                            if (!typeNode2.getData().equals(CVoid.VOID) && !typeNode2.getData().isInstanceOf(CClassType.TYPE)) continue block30;
                            throw new ConfigCompileException("Unexpected ClassType \"" + typeNode2.getData().val() + "\"", typeNode2.getTarget());
                        }
                    }
                    continue;
                }
                if (list.get(k + 1).getData() instanceof IVariable) {
                    node3 = new ParseTree(new CFunction("assign", list.get(k + 1).getTarget()), typeNode2.getFileOptions());
                    node3.addChild(typeNode2);
                    node3.addChild(list.get(k + 1));
                    node3.addChild(new ParseTree(CNull.UNDEFINED, typeNode2.getFileOptions()));
                    list.set(k, node3);
                    list.remove(k + 1);
                    continue;
                }
                if (list.get(k + 1).getData() instanceof CLabel) {
                    node3 = new ParseTree(new CFunction("assign", list.get(k + 1).getTarget()), typeNode2.getFileOptions());
                    ParseTree labelNode = new ParseTree(new CLabel(node3.getData()), typeNode2.getFileOptions());
                    labelNode.addChild(typeNode2);
                    labelNode.addChild(new ParseTree(((CLabel)list.get(k + 1).getData()).cVal(), typeNode2.getFileOptions()));
                    labelNode.addChild(new ParseTree(CNull.UNDEFINED, typeNode2.getFileOptions()));
                    list.set(k, labelNode);
                    list.remove(k + 1);
                    continue;
                }
                if (originalTypeNode.getData().getClass().equals(CBareString.class)) continue;
                throw new ConfigCompileException("Unexpected data after ClassType", list.get(k + 1).getTarget());
            }
            if (list.size() >= 1 && (node = list.get(0)).getData() instanceof CLabel) {
                list.remove(0);
                ParseTree value = __autoconcat__.rewrite(list, returnSConcat, envs);
                ParseTree ce = new ParseTree(new CFunction("centry", node.getTarget()), node.getFileOptions());
                ce.addChild(node);
                ce.addChild(value);
                return ce;
            }
            if (list.size() == 1) {
                ParseTree node4 = list.get(0);
                if (node4.getData() instanceof CFunction && node4.getData().val().equals(NAME)) {
                    node4 = __autoconcat__.rewrite(node4.getChildren(), returnSConcat, envs);
                }
                return node4;
            }
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (!Construct.IsCType(list.get(i2).getData(), Construct.ConstructType.IDENTIFIER)) continue;
                if (i2 == 0) {
                    CFunction identifier = new CFunction(list.get(i2).getData().val(), list.get(i2).getTarget());
                    list.remove(0);
                    ParseTree child = list.get(0);
                    if (list.size() > 1) {
                        child = new ParseTree(new CFunction("sconcat", child.getTarget()), child.getFileOptions());
                        child.setChildren(list);
                    }
                    try {
                        Function f = (Function)FunctionList.getFunction(identifier, envs);
                        ParseTree node5 = new ParseTree(f.execs(identifier.getTarget(), null, null, child), child.getFileOptions());
                        if (node5.getData() instanceof CFunction && node5.getData().val().equals(NAME)) {
                            node5 = __autoconcat__.rewrite(node5.getChildren(), returnSConcat, envs);
                        }
                        return node5;
                    }
                    catch (Exception e) {
                        throw new Error("Unknown function " + identifier.val() + "?");
                    }
                }
                throw new ConfigCompileException("Unexpected IDENTIFIER. Please report a bug, and include the script you used to get this error. At or around:", list.get(i2).getTarget());
            }
            Target t = Target.UNKNOWN;
            if (!list.isEmpty()) {
                options = list.get(0).getFileOptions();
                t = list.get(0).getTarget();
            } else {
                options = new FileOptions(new HashMap<String, String>());
            }
            if (returnSConcat) {
                tree = new ParseTree(new CFunction("sconcat", t), options, true);
                tree.setChildren(list);
            } else {
                tree = new ParseTree(new CFunction("__statements__", t), options, true);
                ArrayList<ParseTree> newChildren = new ArrayList<ParseTree>();
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    CFunction cf;
                    ParseTree child = list.get(i3);
                    Mixed mixed = child.getData();
                    if (mixed instanceof CFunction && (cf = (CFunction)mixed).val().equals("__statements__")) {
                        for (ParseTree subChild : child.getChildren()) {
                            newChildren.add(subChild);
                        }
                        continue;
                    }
                    newChildren.add(child);
                }
                tree.setChildren(newChildren);
            }
            return tree;
        }

        private static void rewriteBinaryOperator(List<ParseTree> list, CSymbol symbol, int leftIndex) throws ConfigCompileException {
            ParseTree left = list.get(leftIndex);
            if (left.getData() instanceof CSymbol) {
                throw new ConfigCompileException("Unexpected symbol (" + left.getData().val() + ") before binary operator (" + list.get(leftIndex + 1).getData().val() + ")", left.getTarget());
            }
            ParseTree right = list.get(leftIndex + 2);
            if (right.getData() instanceof CSymbol) {
                throw new ConfigCompileException("Unexpected symbol (" + right.getData().val() + ") after binary operator (" + list.get(leftIndex + 1).getData().val() + ")", right.getTarget());
            }
            ParseTree conversion = new ParseTree(new CFunction(symbol.convert(), symbol.getTarget()), left.getFileOptions());
            conversion.addChild(left);
            conversion.addChild(right);
            list.set(leftIndex, conversion);
            list.remove(leftIndex + 1);
            list.remove(leftIndex + 1);
        }

        private static void rewriteParenthesis(List<ParseTree> list) throws ConfigCompileException {
            for (int listInd = list.size() - 1; listInd >= 1; --listInd) {
                CFunction cfunc;
                ParseTree prevNode;
                Mixed prevNodeVal;
                CFunction cf;
                ParseTree node;
                Mixed mixed;
                Stack<ParseTree> executes = new Stack<ParseTree>();
                while (!(listInd <= 0 || !((mixed = (node = list.get(listInd)).getData()) instanceof CFunction) || !(cf = (CFunction)mixed).val().equals("p") || (prevNodeVal = (prevNode = list.get(listInd - 1)).getData()) instanceof CSymbol || prevNodeVal instanceof CLabel || prevNodeVal instanceof CString || prevNodeVal instanceof CFunction && (cfunc = (CFunction)prevNodeVal).val().equals("p") && prevNode.numberOfChildren() == 1 && (prevNode.getChildAt(0).getData().isInstanceOf(CClassType.TYPE) || __type_ref__.createFromBareStringOrConcats(prevNode.getChildAt(0)) != null))) {
                    executes.push(node);
                    list.remove(listInd--);
                }
                if (executes.isEmpty()) continue;
                if (listInd >= 0) {
                    ParseTree executableNode = list.get(listInd);
                    ParseTree execute2 = new ParseTree(new CFunction("execute", executableNode.getTarget()), executableNode.getFileOptions(), true);
                    while (!executes.empty()) {
                        execute2.setChildren(((ParseTree)executes.pop()).getChildren());
                        execute2.addChild(executableNode);
                        list.set(listInd, execute2);
                        executableNode = execute2;
                        execute2 = new ParseTree(new CFunction("execute", executableNode.getTarget()), executableNode.getFileOptions(), true);
                    }
                    continue;
                }
                if (executes.size() == 1) continue;
                throw new ConfigCompileException("Unexpected parenthesis", ((ParseTree)executes.peek()).getTarget());
            }
        }
    }

    @api
    @noprofile
    @hide(value="This is only used internally by the compiler.")
    public static class centry
    extends DummyFunction {
        public static final String NAME = "centry";

        @Override
        public String docs() {
            return "CEntry {label, content} Dynamically creates a CEntry. This is used internally by the compiler.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, GenericParameters generics, Mixed ... args) throws ConfigRuntimeException {
            return new CEntry(args[0], args[1], t);
        }
    }

    @api
    @noprofile
    @hide(value="This is only used internally by the compiler.")
    public static class p
    extends DummyFunction
    implements Optimizable {
        public static final String NAME = "p";

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public String docs() {
            return "mixed {c...} Used internally by the compiler. You shouldn't use it.";
        }

        @Override
        public boolean useSpecialExec() {
            return true;
        }

        @Override
        public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
            return nodes.length == 1 ? parent.eval(nodes[0], env) : CVoid.VOID;
        }

        @Override
        public Mixed exec(Target t, Environment env, GenericParameters generics, Mixed ... args) throws ConfigRuntimeException {
            return CVoid.VOID;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException, ConfigCompileGroupException {
            if (children.size() == 1) {
                return Optimizable.PULL_ME_UP;
            }
            if (children.isEmpty()) {
                return Optimizable.REMOVE_ME;
            }
            return null;
        }

        @Override
        public ParseTree postParseRewrite(ParseTree ast, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Set<ConfigCompileException> exceptions) {
            if (ast.getChildren().size() == 1) {
                return ast.getChildAt(0);
            }
            return null;
        }

        @Override
        public CClassType getReturnType(Target t, List<CClassType> argTypes, List<Target> argTargets, Environment env, Set<ConfigCompileException> exceptions) {
            if (argTypes.size() == 1) {
                return argTypes.get(0);
            }
            return CVoid.TYPE;
        }
    }
}

