/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.io.gsonfire.gson;

import com.laytonsmith.libs.com.google.gson.Gson;
import com.laytonsmith.libs.com.google.gson.TypeAdapter;
import com.laytonsmith.libs.com.google.gson.TypeAdapterFactory;
import com.laytonsmith.libs.com.google.gson.reflect.TypeToken;
import com.laytonsmith.libs.com.google.gson.stream.JsonReader;
import com.laytonsmith.libs.com.google.gson.stream.JsonWriter;
import com.laytonsmith.libs.io.gsonfire.gson.NullableTypeAdapter;
import java.io.IOException;

public final class EnumDefaultValueTypeAdapterFactory<T extends Enum>
implements TypeAdapterFactory {
    private final Class<T> clazz;
    private final T defaultValue;

    public EnumDefaultValueTypeAdapterFactory(Class<T> clazz, T defaultValue) {
        this.clazz = clazz;
        this.defaultValue = defaultValue;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (this.clazz.isAssignableFrom(type.getRawType())) {
            final TypeAdapter<T> originalTypeAdapter = gson.getDelegateAdapter(this, type);
            return new NullableTypeAdapter(new TypeAdapter<T>(){

                @Override
                public void write(JsonWriter jsonWriter, T o) throws IOException {
                    originalTypeAdapter.write(jsonWriter, o);
                }

                @Override
                public T read(JsonReader jsonReader) throws IOException {
                    Object result = originalTypeAdapter.read(jsonReader);
                    if (result == null) {
                        return EnumDefaultValueTypeAdapterFactory.this.defaultValue;
                    }
                    return result;
                }
            });
        }
        return null;
    }
}

