/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.perf4j.log4j;

import com.laytonsmith.libs.org.perf4j.GroupedTimingStatistics;
import com.laytonsmith.libs.org.perf4j.helpers.GenericAsyncCoalescingStatisticsAppender;
import java.io.Flushable;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;

public class AsyncCoalescingStatisticsAppender
extends AppenderSkeleton
implements AppenderAttachable {
    private Level downstreamLogLevel = Level.INFO;
    private final GenericAsyncCoalescingStatisticsAppender baseImplementation = this.newGenericAsyncCoalescingStatisticsAppender();
    private final AppenderAttachableImpl downstreamAppenders = new AppenderAttachableImpl();
    private Thread shutdownHook = null;

    public long getTimeSlice() {
        return this.baseImplementation.getTimeSlice();
    }

    public void setTimeSlice(long timeSlice) {
        this.baseImplementation.setTimeSlice(timeSlice);
    }

    public String getDownstreamLogLevel() {
        return this.downstreamLogLevel.toString();
    }

    public void setDownstreamLogLevel(String downstreamLogLevel) {
        this.downstreamLogLevel = Level.toLevel((String)downstreamLogLevel);
    }

    public boolean isCreateRollupStatistics() {
        return this.baseImplementation.isCreateRollupStatistics();
    }

    public void setCreateRollupStatistics(boolean createRollupStatistics) {
        this.baseImplementation.setCreateRollupStatistics(createRollupStatistics);
    }

    public int getQueueSize() {
        return this.baseImplementation.getQueueSize();
    }

    public void setQueueSize(int queueSize) {
        this.baseImplementation.setQueueSize(queueSize);
    }

    public String getStopWatchParserClassName() {
        return this.baseImplementation.getStopWatchParserClassName();
    }

    public void setStopWatchParserClassName(String stopWatchParserClassName) {
        this.baseImplementation.setStopWatchParserClassName(stopWatchParserClassName);
    }

    public void setName(String name) {
        super.setName(name);
        this.baseImplementation.setName(name);
    }

    public synchronized void activateOptions() {
        this.baseImplementation.start(new GenericAsyncCoalescingStatisticsAppender.GroupedTimingStatisticsHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(GroupedTimingStatistics statistics) {
                LoggingEvent coalescedLoggingEvent = new LoggingEvent(Logger.class.getName(), (Category)Logger.getLogger((String)"com.laytonsmith.libs.org.perf4j.TimingLogger"), System.currentTimeMillis(), (Priority)AsyncCoalescingStatisticsAppender.this.downstreamLogLevel, (Object)statistics, null);
                try {
                    AppenderAttachableImpl appenderAttachableImpl = AsyncCoalescingStatisticsAppender.this.downstreamAppenders;
                    synchronized (appenderAttachableImpl) {
                        AsyncCoalescingStatisticsAppender.this.downstreamAppenders.appendLoopOnAppenders(coalescedLoggingEvent);
                    }
                }
                catch (Exception e) {
                    AsyncCoalescingStatisticsAppender.this.getErrorHandler().error("Exception calling append with GroupedTimingStatistics on downstream appender", e, -1, coalescedLoggingEvent);
                }
            }

            public void error(String errorMessage) {
                AsyncCoalescingStatisticsAppender.this.getErrorHandler().error(errorMessage);
            }
        });
        if (this.shutdownHook == null) {
            try {
                this.shutdownHook = new Thread("perf4j-async-stats-appender-shutdown"){

                    public void run() {
                        if (!AsyncCoalescingStatisticsAppender.this.closed) {
                            AsyncCoalescingStatisticsAppender.this.close();
                        }
                    }
                };
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getNumDiscardedMessages() {
        return this.baseImplementation.getNumDiscardedMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            this.downstreamAppenders.addAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            return this.downstreamAppenders.getAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Appender getAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            return this.downstreamAppenders.getAppender(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttached(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            return this.downstreamAppenders.isAttached(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            this.downstreamAppenders.removeAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            this.downstreamAppenders.removeAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            this.downstreamAppenders.removeAppender(name);
        }
    }

    protected void append(LoggingEvent event) {
        this.baseImplementation.append(String.valueOf(event.getMessage()));
    }

    public boolean requiresLayout() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.baseImplementation.stop();
        AppenderAttachableImpl appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            Enumeration enumer = this.downstreamAppenders.getAllAppenders();
            while (enumer != null && enumer.hasMoreElements()) {
                Appender appender = (Appender)enumer.nextElement();
                if (!(appender instanceof Flushable)) continue;
                try {
                    ((Flushable)appender).flush();
                }
                catch (Exception e) {}
            }
            enumer = this.downstreamAppenders.getAllAppenders();
            while (enumer != null && enumer.hasMoreElements()) {
                ((Appender)enumer.nextElement()).close();
            }
        }
        this.closed = true;
    }

    protected GenericAsyncCoalescingStatisticsAppender newGenericAsyncCoalescingStatisticsAppender() {
        return new GenericAsyncCoalescingStatisticsAppender();
    }
}

