/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import java.util.Objects;
import java.util.Optional;

public final class Either<L, R> {
    private final Optional<L> left;
    private final Optional<R> right;

    public static <L, R> Either<L, R> left(L value) {
        return new Either(Optional.of(value), Optional.empty());
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Either(Optional.empty(), Optional.of(value));
    }

    public static <L, R> Either<L, R> neither() {
        return new Either(Optional.empty(), Optional.empty());
    }

    private Either(Optional<L> left, Optional<R> right) {
        this.left = left;
        this.right = right;
    }

    public Optional<L> getLeft() {
        return this.left;
    }

    public Optional<R> getRight() {
        return this.right;
    }

    public boolean hasLeft() {
        return this.left.isPresent();
    }

    public boolean hasRight() {
        return this.right.isPresent();
    }

    public int hashCode() {
        int hash2 = 3;
        hash2 = 19 * hash2 + Objects.hashCode(this.left);
        hash2 = 19 * hash2 + Objects.hashCode(this.right);
        return hash2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Either other = (Either)obj;
        if (!Objects.equals(this.left, other.left)) {
            return false;
        }
        return Objects.equals(this.right, other.right);
    }

    public String toString() {
        return "Either{left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + "}";
    }
}

