/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.ArgumentParser;
import com.laytonsmith.core.AbstractCommandLineTool;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.functions.Meta;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.tool;
import com.laytonsmith.libs.com.google.gson.JsonSyntaxException;
import io.swagger.client.ApiException;
import io.swagger.client.api.BuildsApi;
import io.swagger.client.model.BuildArtifact;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class Updater {
    private static final String DEFAULT_UPDATE_CHANNEL = "commandhelperjar";
    private static final BuildsApi API = new BuildsApi();

    public static Date getDateFromString(String date) throws ParseException {
        date = date.replaceAll("Z$", "+0000");
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(date);
    }

    public static BuildArtifact getLatestVersionInfo() throws ApiException, ParseException {
        List<BuildArtifact> versions = API.buildsArtifactGet(DEFAULT_UPDATE_CHANNEL, true);
        BuildArtifact maxVersion = null;
        for (int i = 0; i < versions.size(); ++i) {
            BuildArtifact version = versions.get(i);
            Date versionDate = Updater.getDateFromString(version.getDate());
            if (maxVersion != null && !versionDate.after(Updater.getDateFromString(maxVersion.getDate()))) continue;
            maxVersion = version;
        }
        return maxVersion;
    }

    public static Boolean isUpdateAvailable() {
        Mixed buildDate = new Meta.engine_build_date().exec(null, null, null, null);
        if (buildDate instanceof CNull) {
            return null;
        }
        long iBuildDate = ((CInt)buildDate).getInt();
        Date time2 = new Date(iBuildDate);
        try {
            BuildArtifact latestVersion = Updater.getLatestVersionInfo();
            if (latestVersion != null) {
                Date versionDate = Updater.getDateFromString(latestVersion.getDate());
                Calendar cal = Calendar.getInstance();
                cal.setTime(versionDate);
                cal.add(12, 5);
                versionDate = cal.getTime();
                return time2.before(versionDate);
            }
            return null;
        }
        catch (JsonSyntaxException | ApiException | IllegalStateException | ParseException ex) {
            return null;
        }
    }

    @tool(value="check-update")
    public static class CheckUpdate
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Checks if an update is available from the build server.").addExtendedDescription("By default, the command checks against the official build server,  which is located at https://apps.methodscript.com/ however this can be changed to other build servers by setting the methodscript.apps.server system property.");
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            Boolean updateAvailable = Updater.isUpdateAvailable();
            if (updateAvailable == null) {
                System.err.println("Unable to determine build date of this installation, or version info is wrong, cannot check for updates.");
                System.exit(1);
            }
            if (updateAvailable.booleanValue()) {
                System.out.println("An update is available! Check https://methodscript.com/docs/" + MSVersion.LATEST.getVersionString() + "/Download.html");
            } else {
                System.out.println("No update is available.");
            }
        }
    }
}

