/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.profiler;

import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.profiler.Profiler;

public class ProfilePoint
implements Comparable<ProfilePoint> {
    private final String name;
    private String message;
    boolean gcRun;
    private final Profiler parent;
    private LogLevel granularity;

    public ProfilePoint(String name, Profiler parent) {
        this.name = name;
        this.gcRun = false;
        this.parent = parent;
        this.message = null;
    }

    public String toString() {
        return this.name;
    }

    void garbageCollectorRun() {
        this.gcRun = true;
    }

    boolean wasGCd() {
        return this.gcRun;
    }

    public void stop() {
        this.parent.stop(this);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String newMessage) {
        this.message = newMessage;
    }

    @Override
    public int compareTo(ProfilePoint o) {
        return o.name.compareTo(this.name);
    }

    void setGranularity(LogLevel granularity) {
        this.granularity = granularity;
    }

    public LogLevel getGranularity() {
        return this.granularity;
    }
}

