/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.SimpleVersion;
import com.laytonsmith.PureUtilities.SmartComment;
import com.laytonsmith.annotations.OperatorPreferred;
import com.laytonsmith.annotations.breakable;
import com.laytonsmith.annotations.nolinking;
import com.laytonsmith.annotations.unbreakable;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.MethodScriptComplete;
import com.laytonsmith.core.Optimizable;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Procedure;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.BranchStatement;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.compiler.EarlyBindingKeyword;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.compiler.Keyword;
import com.laytonsmith.core.compiler.KeywordList;
import com.laytonsmith.core.compiler.LateBindingKeyword;
import com.laytonsmith.core.compiler.TokenStream;
import com.laytonsmith.core.compiler.analysis.StaticAnalysis;
import com.laytonsmith.core.constructs.CBareString;
import com.laytonsmith.core.constructs.CDecimal;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CKeyword;
import com.laytonsmith.core.constructs.CLabel;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CPreIdentifier;
import com.laytonsmith.core.constructs.CSemicolon;
import com.laytonsmith.core.constructs.CSlice;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CSymbol;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.SourceType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Token;
import com.laytonsmith.core.constructs.Variable;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.extensions.ExtensionManager;
import com.laytonsmith.core.extensions.ExtensionTracker;
import com.laytonsmith.core.functions.Compiler;
import com.laytonsmith.core.functions.ControlFlow;
import com.laytonsmith.core.functions.DataHandling;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.persistence.DataSourceException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public final class MethodScriptCompiler {
    private static final EnumSet<Optimizable.OptimizationOption> NO_OPTIMIZATIONS = EnumSet.noneOf(Optimizable.OptimizationOption.class);
    private static final Pattern VAR_PATTERN = Pattern.compile("\\$[\\p{L}0-9_]+");
    private static final Pattern IVAR_PATTERN = Pattern.compile("@[\\p{L}0-9_]+");
    private static final Pattern NUM_PATTERN = Pattern.compile("[0-9]+");
    private static final Pattern FUNC_NAME_PATTERN = Pattern.compile("[_a-zA-Z0-9]+");
    private static final List<Character> PDF_STACK = Arrays.asList(Character.valueOf('\u202a'), Character.valueOf('\u202b'), Character.valueOf('\u202d'), Character.valueOf('\u202e'));
    private static final List<Character> PDI_STACK = Arrays.asList(Character.valueOf('\u2066'), Character.valueOf('\u2067'));
    private static final char PDF = '\u202c';
    private static final char PDI = '\u2069';

    private MethodScriptCompiler() {
    }

    public static TokenStream lex(String script, Environment env, File file, boolean inPureMScript) throws ConfigCompileException {
        return MethodScriptCompiler.lex(script, env, file, inPureMScript, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TokenStream lex(String script, Environment env, File file, boolean inPureMScript, boolean saveAllTokens) throws ConfigCompileException {
        String fileName;
        if (env == null) {
            env = Environment.createEnvironment(new CompilerEnvironment());
        }
        if (!env.hasEnv(CompilerEnvironment.class)) {
            env = env.cloneAndAdd(new CompilerEnvironment());
        }
        if (((String)script).isEmpty()) {
            return new TokenStream(new LinkedList<Token>(), "", new HashMap<String, String>());
        }
        if (((String)script).charAt(0) == '\ufeff') {
            script = ((String)script).substring(1);
        }
        StringBuilder fileOptions = new StringBuilder();
        FileOptions builtFileOptions = null;
        script = ((String)script).replace("\r\n", "\n");
        script = (String)script + "\n";
        Set<String> keywords = KeywordList.getKeywordNames();
        TokenStream tokenList = new TokenStream();
        boolean stateInQuote = false;
        int quoteLineNumberStart = 1;
        boolean inSmartQuote = false;
        int smartQuoteLineNumberStart = 1;
        boolean inComment = false;
        int commentLineNumberStart = 1;
        boolean commentIsBlock = false;
        boolean inOptVar = false;
        boolean inCommand = !inPureMScript;
        boolean inMultiline = false;
        boolean inSmartComment = false;
        boolean inFileOptions = false;
        boolean inAnnotation = false;
        int fileOptionsLineNumberStart = 1;
        StringBuilder buf = new StringBuilder();
        int lineNum = 1;
        int column = 1;
        int lastColumn = 0;
        Target target = Target.UNKNOWN;
        block65: for (int i = 0; i < ((String)script).length(); ++i) {
            char c2;
            char c;
            block171: {
                Token token;
                c = ((String)script).charAt(i);
                c2 = '\u0000';
                char c3 = '\u0000';
                if (i < ((String)script).length() - 1) {
                    c2 = ((String)script).charAt(i + 1);
                }
                if (i < ((String)script).length() - 2) {
                    c3 = ((String)script).charAt(i + 2);
                }
                column += i - lastColumn;
                lastColumn = i;
                if (c == '\n') {
                    ++lineNum;
                    column = 0;
                    if (!inMultiline && !inPureMScript) {
                        inCommand = true;
                    }
                }
                if (buf.length() == 0) {
                    target = new Target(lineNum, file, column);
                }
                if (inFileOptions) {
                    switch (c) {
                        case '\\': {
                            if (c2 != '>') break;
                            fileOptions.append('>');
                            ++i;
                            continue block65;
                        }
                        case '>': {
                            if (saveAllTokens) {
                                tokenList.add(new Token(Token.TType.FILE_OPTIONS_STRING, fileOptions.toString(), target));
                                tokenList.add(new Token(Token.TType.FILE_OPTIONS_END, ">", target));
                            }
                            inFileOptions = false;
                            builtFileOptions = TokenStream.parseFileOptions(fileOptions.toString(), new HashMap<String, String>());
                            continue block65;
                        }
                    }
                    fileOptions.append(c);
                    continue;
                }
                if (!stateInQuote && !inSmartQuote) {
                    switch (c) {
                        case '/': {
                            if (c2 == '*') {
                                if (inComment && commentIsBlock) {
                                    CompilerWarning warning = new CompilerWarning("Nested comment blocks are being added to a future version, where this code will suddenly cause an unclosed comment block. You can remove this block comment open symbol now, or add a  new block comment close when this feature is implemented (it will likely cause an obvious compile error), and optionally suppress this warning.", target, FileOptions.SuppressWarning.FutureNestedCommentChange);
                                    env.getEnv(CompilerEnvironment.class).addCompilerWarning(builtFileOptions, warning);
                                }
                                if (inComment) break;
                                buf.append("/*");
                                inComment = true;
                                commentIsBlock = true;
                                if (i + 2 < ((String)script).length() && ((String)script).charAt(i + 2) == '*' && (i + 3 >= ((String)script).length() || ((String)script).charAt(i + 3) != '/')) {
                                    inSmartComment = true;
                                    buf.append("*");
                                    ++i;
                                }
                                commentLineNumberStart = lineNum;
                                ++i;
                                continue block65;
                            }
                            if (c2 != '/' || inComment) break;
                            buf.append("//");
                            inComment = true;
                            ++i;
                            continue block65;
                        }
                        case '#': {
                            if (inComment) break;
                            buf.append("#");
                            inComment = true;
                            continue block65;
                        }
                        case '*': {
                            if (!inComment || !commentIsBlock || c2 != '/') break;
                            if (saveAllTokens || inSmartComment) {
                                buf.append("*/");
                                MethodScriptCompiler.validateTerminatedBidiSequence(buf.toString(), target);
                                tokenList.add(new Token(inSmartComment ? Token.TType.SMART_COMMENT : Token.TType.COMMENT, buf.toString(), target));
                            }
                            buf = new StringBuilder();
                            target = new Target(lineNum, file, column);
                            inComment = false;
                            commentIsBlock = false;
                            inSmartComment = false;
                            ++i;
                            continue block65;
                        }
                        case '\n': {
                            if (!inComment || commentIsBlock) break;
                            inComment = false;
                            if (saveAllTokens) {
                                MethodScriptCompiler.validateTerminatedBidiSequence(buf.toString(), target);
                                tokenList.add(new Token(Token.TType.COMMENT, buf.toString(), target));
                                tokenList.add(new Token(Token.TType.NEWLINE, "\n", new Target(lineNum + 1, file, 0)));
                            }
                            buf = new StringBuilder();
                            target = new Target(lineNum, file, column);
                            continue block65;
                        }
                    }
                }
                if (inComment || inAnnotation && c != '}') {
                    buf.append(c);
                    continue;
                }
                if (stateInQuote) break block171;
                switch (c) {
                    case '+': {
                        if (c2 == '=') {
                            token = new Token(Token.TType.PLUS_ASSIGNMENT, "+=", target.copy());
                            ++i;
                            break;
                        }
                        if (c2 == '+') {
                            token = new Token(Token.TType.INCREMENT, "++", target.copy());
                            ++i;
                            break;
                        }
                        token = new Token(Token.TType.PLUS, "+", target.copy());
                        break;
                    }
                    case '-': {
                        if (c2 == '=') {
                            token = new Token(Token.TType.MINUS_ASSIGNMENT, "-=", target.copy());
                            ++i;
                            break;
                        }
                        if (c2 == '-') {
                            token = new Token(Token.TType.DECREMENT, "--", target.copy());
                            ++i;
                            break;
                        }
                        if (c2 == '>') {
                            token = new Token(Token.TType.DEREFERENCE, "->", target.copy());
                            ++i;
                            break;
                        }
                        token = new Token(Token.TType.MINUS, "-", target.copy());
                        break;
                    }
                    case '*': {
                        if (c2 == '=') {
                            token = new Token(Token.TType.MULTIPLICATION_ASSIGNMENT, "*=", target.copy());
                            ++i;
                            break;
                        }
                        if (c2 == '*') {
                            token = new Token(Token.TType.EXPONENTIAL, "**", target.copy());
                            ++i;
                            break;
                        }
                        token = new Token(Token.TType.MULTIPLICATION, "*", target.copy());
                        break;
                    }
                    case '/': {
                        if (c2 == '=') {
                            token = new Token(Token.TType.DIVISION_ASSIGNMENT, "/=", target.copy());
                            ++i;
                            break;
                        }
                        if (!Character.isLetter(c2)) {
                            token = new Token(Token.TType.DIVISION, "/", target.copy());
                            break;
                        }
                        break block171;
                    }
                    case '.': {
                        if (c2 == '=') {
                            token = new Token(Token.TType.CONCAT_ASSIGNMENT, ".=", target.copy());
                            ++i;
                            break;
                        }
                        if (c2 == '.' && c3 == '.') {
                            token = new Token(Token.TType.VARARGS, "...", target.copy());
                            i += 2;
                            break;
                        }
                        if (c2 == '.') {
                            token = new Token(Token.TType.SLICE, "..", target.copy());
                            ++i;
                            break;
                        }
                        token = new Token(Token.TType.DOT, ".", target.copy());
                        break;
                    }
                    case '%': {
                        token = new Token(Token.TType.MODULO, "%", target.copy());
                        break;
                    }
                    case '>': {
                        if (c2 == '=') {
                            token = new Token(Token.TType.GTE, ">=", target.copy());
                            ++i;
                            break;
                        }
                        if (c2 == '>' && i < ((String)script).length() - 2 && ((String)script).charAt(i + 2) == '>') {
                            token = new Token(Token.TType.MULTILINE_START, ">>>", target.copy());
                            inMultiline = true;
                            i += 2;
                            break;
                        }
                        token = new Token(Token.TType.GT, ">", target.copy());
                        break;
                    }
                    case '<': {
                        if (c2 == '!') {
                            if (buf.length() > 0) {
                                tokenList.add(new Token(Token.TType.UNKNOWN, buf.toString(), target));
                                buf = new StringBuilder();
                                target = new Target(lineNum, file, column);
                            }
                            if (saveAllTokens) {
                                tokenList.add(new Token(Token.TType.FILE_OPTIONS_START, "<!", target.copy()));
                            }
                            inFileOptions = true;
                            fileOptionsLineNumberStart = lineNum;
                            ++i;
                            continue block65;
                        }
                        if (c2 == '=') {
                            token = new Token(Token.TType.LTE, "<=", target.copy());
                            ++i;
                            break;
                        }
                        if (c2 == '<' && i < ((String)script).length() - 2 && ((String)script).charAt(i + 2) == '<') {
                            token = new Token(Token.TType.MULTILINE_END, "<<<", target.copy());
                            inMultiline = false;
                            i += 2;
                            break;
                        }
                        token = new Token(Token.TType.LT, "<", target.copy());
                        break;
                    }
                    case '=': {
                        if (c2 == '=') {
                            if (i < ((String)script).length() - 2 && ((String)script).charAt(i + 2) == '=') {
                                token = new Token(Token.TType.STRICT_EQUALS, "===", target.copy());
                                i += 2;
                                break;
                            }
                            token = new Token(Token.TType.EQUALS, "==", target.copy());
                            ++i;
                            break;
                        }
                        if (inCommand) {
                            if (inOptVar) {
                                token = new Token(Token.TType.OPT_VAR_ASSIGN, "=", target.copy());
                                break;
                            }
                            token = new Token(Token.TType.ALIAS_END, "=", target.copy());
                            inCommand = false;
                            break;
                        }
                        token = new Token(Token.TType.ASSIGNMENT, "=", target.copy());
                        break;
                    }
                    case '!': {
                        if (c2 == '=') {
                            if (i < ((String)script).length() - 2 && ((String)script).charAt(i + 2) == '=') {
                                token = new Token(Token.TType.STRICT_NOT_EQUALS, "!==", target.copy());
                                i += 2;
                                break;
                            }
                            token = new Token(Token.TType.NOT_EQUALS, "!=", target.copy());
                            ++i;
                            break;
                        }
                        token = new Token(Token.TType.LOGICAL_NOT, "!", target.copy());
                        break;
                    }
                    case '&': {
                        if (c2 == '&') {
                            if (i < ((String)script).length() - 2 && ((String)script).charAt(i + 2) == '&') {
                                token = new Token(Token.TType.DEFAULT_AND, "&&&", target.copy());
                                i += 2;
                                break;
                            }
                            token = new Token(Token.TType.LOGICAL_AND, "&&", target.copy());
                            ++i;
                            break;
                        }
                        break block171;
                    }
                    case '|': {
                        if (c2 == '|') {
                            if (i < ((String)script).length() - 2 && ((String)script).charAt(i + 2) == '|') {
                                token = new Token(Token.TType.DEFAULT_OR, "|||", target.copy());
                                i += 2;
                                break;
                            }
                            token = new Token(Token.TType.LOGICAL_OR, "||", target.copy());
                            ++i;
                            break;
                        }
                        break block171;
                    }
                    case ':': {
                        if (c2 == ':') {
                            token = new Token(Token.TType.DEREFERENCE, "::", target.copy());
                            ++i;
                            break;
                        }
                        token = new Token(Token.TType.LABEL, ":", target.copy());
                        break;
                    }
                    case '{': {
                        token = new Token(Token.TType.LCURLY_BRACKET, "{", target.copy());
                        break;
                    }
                    case '}': {
                        if (inAnnotation) {
                            inAnnotation = false;
                            token = new Token(Token.TType.COMMENT, "@{" + buf.toString() + "}", target);
                            buf = new StringBuilder();
                            break;
                        }
                        token = new Token(Token.TType.RCURLY_BRACKET, "}", target.copy());
                        break;
                    }
                    case '[': {
                        token = new Token(Token.TType.LSQUARE_BRACKET, "[", target.copy());
                        inOptVar = true;
                        break;
                    }
                    case ']': {
                        token = new Token(Token.TType.RSQUARE_BRACKET, "]", target.copy());
                        inOptVar = false;
                        break;
                    }
                    case ',': {
                        token = new Token(Token.TType.COMMA, ",", target.copy());
                        break;
                    }
                    case ';': {
                        token = new Token(Token.TType.SEMICOLON, ";", target.copy());
                        break;
                    }
                    case '(': {
                        token = new Token(Token.TType.FUNC_START, "(", target.copy());
                        if (buf.length() > 0) {
                            if (saveAllTokens && KeywordList.getKeywordByName(buf.toString()) != null) {
                                tokenList.add(new Token(Token.TType.KEYWORD, buf.toString(), target));
                            } else {
                                String funcName = buf.toString();
                                if (FUNC_NAME_PATTERN.matcher(funcName).matches()) {
                                    tokenList.add(new Token(Token.TType.FUNC_NAME, funcName, target));
                                } else {
                                    tokenList.add(new Token(Token.TType.UNKNOWN, funcName, target));
                                }
                            }
                            buf = new StringBuilder();
                            target = new Target(lineNum, file, column);
                            break;
                        }
                        try {
                            Token token2;
                            int count = 0;
                            Iterator it = tokenList.descendingIterator();
                            while (true) {
                                token2 = (Token)it.next();
                                if (token2.type != Token.TType.WHITESPACE) break;
                                ++count;
                            }
                            if (token2.type != Token.TType.UNKNOWN) break;
                            token2.type = Token.TType.FUNC_NAME;
                            --count;
                            for (int a = 0; a < count; ++a) {
                                tokenList.removeLast();
                            }
                            break;
                        }
                        catch (NoSuchElementException count) {
                            break;
                        }
                    }
                    case ')': {
                        token = new Token(Token.TType.FUNC_END, ")", target.copy());
                        break;
                    }
                    case ' ': {
                        token = new Token(Token.TType.WHITESPACE, " ", target.copy());
                        break;
                    }
                    case '\t': {
                        token = new Token(Token.TType.WHITESPACE, "\t", target.copy());
                        break;
                    }
                    case '@': {
                        if (c2 == '{') {
                            inAnnotation = true;
                            ++i;
                            continue block65;
                        }
                        break block171;
                    }
                    default: {
                        break block171;
                    }
                }
                if (buf.length() > 0) {
                    tokenList.add(new Token(Token.TType.UNKNOWN, buf.toString(), target));
                    buf = new StringBuilder();
                    target = new Target(lineNum, file, column);
                }
                tokenList.add(token);
                continue;
            }
            switch (c) {
                case '\'': {
                    if (stateInQuote && !inSmartQuote) {
                        MethodScriptCompiler.validateTerminatedBidiSequence(buf.toString(), target);
                        tokenList.add(new Token(Token.TType.STRING, buf.toString(), target));
                        buf = new StringBuilder();
                        target = new Target(lineNum, file, column);
                        stateInQuote = false;
                        continue block65;
                    }
                    if (!stateInQuote) {
                        stateInQuote = true;
                        quoteLineNumberStart = lineNum;
                        inSmartQuote = false;
                        if (buf.length() <= 0) continue block65;
                        tokenList.add(new Token(Token.TType.UNKNOWN, buf.toString(), target));
                        buf = new StringBuilder();
                        target = new Target(lineNum, file, column);
                        continue block65;
                    }
                    buf.append("'");
                    continue block65;
                }
                case '\"': {
                    if (stateInQuote && inSmartQuote) {
                        MethodScriptCompiler.validateTerminatedBidiSequence(buf.toString(), target);
                        tokenList.add(new Token(Token.TType.SMART_STRING, buf.toString(), target));
                        buf = new StringBuilder();
                        target = new Target(lineNum, file, column);
                        stateInQuote = false;
                        inSmartQuote = false;
                        continue block65;
                    }
                    if (!stateInQuote) {
                        stateInQuote = true;
                        inSmartQuote = true;
                        smartQuoteLineNumberStart = lineNum;
                        if (buf.length() <= 0) continue block65;
                        tokenList.add(new Token(Token.TType.UNKNOWN, buf.toString(), target));
                        buf = new StringBuilder();
                        target = new Target(lineNum, file, column);
                        continue block65;
                    }
                    buf.append('\"');
                    continue block65;
                }
                case '\n': {
                    if (stateInQuote) {
                        buf.append(c);
                        continue block65;
                    }
                    if (buf.length() > 0) {
                        tokenList.add(new Token(Token.TType.UNKNOWN, buf.toString(), target));
                        buf = new StringBuilder();
                        target = new Target(lineNum, file, column);
                    }
                    tokenList.add(new Token(Token.TType.NEWLINE, "\n", target));
                    continue block65;
                }
                case '\\': {
                    if (!stateInQuote) {
                        tokenList.add(new Token(Token.TType.SEPERATOR, "\\", target));
                        continue block65;
                    }
                    switch (c2) {
                        case '\\': {
                            if (inSmartQuote) {
                                buf.append('\\');
                            }
                            buf.append('\\');
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            buf.append(c2);
                            break;
                        }
                        case 'n': {
                            buf.append('\n');
                            break;
                        }
                        case 'r': {
                            buf.append('\r');
                            break;
                        }
                        case 't': {
                            buf.append('\t');
                            break;
                        }
                        case '0': {
                            buf.append('\u0000');
                            break;
                        }
                        case 'f': {
                            buf.append('\f');
                            break;
                        }
                        case 'v': {
                            buf.append('\u000b');
                            break;
                        }
                        case 'a': {
                            buf.append('\u0007');
                            break;
                        }
                        case 'b': {
                            buf.append('\b');
                            break;
                        }
                        case 'u': {
                            int unicodeNum;
                            if (i + 5 >= ((String)script).length()) {
                                throw new ConfigCompileException("Unrecognized unicode escape sequence", target);
                            }
                            String unicode = ((String)script).substring(i + 2, i + 6);
                            try {
                                unicodeNum = Integer.parseInt(unicode, 16);
                            }
                            catch (NumberFormatException e) {
                                throw new ConfigCompileException("Unrecognized unicode escape sequence: \\u" + unicode, target);
                            }
                            buf.append(Character.toChars(unicodeNum));
                            i += 4;
                            break;
                        }
                        case 'U': {
                            int unicodeNum;
                            if (i + 9 >= ((String)script).length()) {
                                throw new ConfigCompileException("Unrecognized unicode escape sequence", target);
                            }
                            String unicode = ((String)script).substring(i + 2, i + 10);
                            try {
                                unicodeNum = Integer.parseInt(unicode, 16);
                            }
                            catch (NumberFormatException e) {
                                throw new ConfigCompileException("Unrecognized unicode escape sequence: \\u" + unicode, target);
                            }
                            buf.append(Character.toChars(unicodeNum));
                            i += 8;
                            break;
                        }
                        case '@': {
                            if (!inSmartQuote) {
                                throw new ConfigCompileException("The escape sequence \\@ is not a recognized escape sequence in a non-smart string", target);
                            }
                            buf.append("\\@");
                            break;
                        }
                        default: {
                            throw new ConfigCompileException("The escape sequence \\" + c2 + " is not a recognized escape sequence", target);
                        }
                    }
                    ++i;
                    continue block65;
                }
                default: {
                    if (!stateInQuote && c == '\u00a0') {
                        throw new ConfigCompileException("NBSP character in script", target);
                    }
                    buf.append(c);
                    continue block65;
                }
            }
        }
        if (inFileOptions) {
            throw new ConfigCompileException("Unended file options. You started the the file options on line " + fileOptionsLineNumberStart, target);
        }
        if (stateInQuote) {
            if (inSmartQuote) {
                throw new ConfigCompileException("Unended string literal. You started the last double quote on line " + smartQuoteLineNumberStart, target);
            }
            throw new ConfigCompileException("Unended string literal. You started the last single quote on line " + quoteLineNumberStart, target);
        }
        if (inComment || commentIsBlock) {
            throw new ConfigCompileException("Unended block comment. You started the comment on line " + commentLineNumberStart, target);
        }
        ListIterator it = tokenList.listIterator(0);
        while (it.hasNext()) {
            Token next;
            Token t = (Token)it.next();
            if (t.type == Token.TType.WHITESPACE && it.hasNext()) {
                next = (Token)it.next();
                if (next.type == Token.TType.WHITESPACE) {
                    t.value = t.value + next.val();
                    it.remove();
                } else {
                    it.previous();
                }
                it.previous();
                it.next();
            }
            it.previous();
            if (it.hasPrevious() && t.type == Token.TType.UNKNOWN) {
                Token prev1 = (Token)it.previous();
                if (prev1.type.isPlusMinus()) {
                    Token prevNonWhitespace = null;
                    while (it.hasPrevious()) {
                        if (((Token)it.previous()).type == Token.TType.WHITESPACE) continue;
                        prevNonWhitespace = (Token)it.next();
                        break;
                    }
                    while (it.next() != prev1) {
                    }
                    if (prevNonWhitespace != null && !prevNonWhitespace.type.isIdentifier() && prevNonWhitespace.type != Token.TType.FUNC_END && prevNonWhitespace.type != Token.TType.RSQUARE_BRACKET && NUM_PATTERN.matcher(t.val()).matches()) {
                        t.value = prev1.value + t.value;
                        it.remove();
                    }
                } else {
                    it.next();
                }
            }
            it.next();
            if (t.type == Token.TType.UNKNOWN) {
                if (t.val().charAt(0) == '/' && t.val().length() > 1) {
                    t.type = Token.TType.COMMAND;
                } else if (t.val().equals("$")) {
                    t.type = Token.TType.FINAL_VAR;
                } else if (VAR_PATTERN.matcher(t.val()).matches()) {
                    t.type = Token.TType.VARIABLE;
                } else if (IVAR_PATTERN.matcher(t.val()).matches()) {
                    t.type = Token.TType.IVARIABLE;
                } else {
                    if (t.val().charAt(0) == '@') {
                        throw new ConfigCompileException("IVariables must match the regex: " + String.valueOf(IVAR_PATTERN), t.getTarget());
                    }
                    t.type = keywords.contains(t.val()) ? Token.TType.KEYWORD : (t.val().matches("[\t ]*") ? Token.TType.WHITESPACE : Token.TType.LIT);
                }
            }
            if (!it.hasNext()) continue;
            next = (Token)it.next();
            it.previous();
            it.previous();
            if (t.type.isSymbol() && !t.type.isUnary() && !next.type.isUnary() && it.hasPrevious()) {
                Token prev1 = (Token)it.previous();
                if (prev1.type.equals((Object)Token.TType.FUNC_START) || prev1.type.equals((Object)Token.TType.COMMA) || next.type.equals((Object)Token.TType.FUNC_END) || next.type.equals((Object)Token.TType.COMMA) || prev1.type.isSymbol() || next.type.isSymbol()) {
                    throw new ConfigCompileException("Unexpected symbol token (" + t.val() + ")", t.getTarget());
                }
                it.next();
            }
            it.next();
        }
        HashMap<String, String> defaults = new HashMap<String, String>();
        ArrayList<File> dirs = new ArrayList<File>();
        if (file != null) {
            for (File f = file.getParentFile(); f != null; f = f.getParentFile()) {
                File fileOptionDefaults = new File(f, ".msfileoptions");
                if (!fileOptionDefaults.exists()) continue;
                dirs.add(fileOptionDefaults);
            }
        }
        Collections.reverse(dirs);
        Iterator f = dirs.iterator();
        while (f.hasNext()) {
            File d = (File)f.next();
            try {
                defaults.putAll(TokenStream.parseFileOptions(FileUtil.read(d), defaults).getRawOptions());
            }
            catch (IOException ex) {
                throw new ConfigCompileException("Cannot read " + d.getAbsolutePath(), Target.UNKNOWN, ex);
            }
        }
        tokenList.setFileOptions(fileOptions.toString(), defaults);
        boolean foundCode = false;
        for (Token t : tokenList) {
            if (t.type.isFileOption()) {
                if (!foundCode) break;
                throw new ConfigCompileException("File options must be the first non-comment section in the code", t.target);
            }
            if (t.type.isComment() || t.type.isWhitespace()) continue;
            foundCode = true;
        }
        if (!(fileName = tokenList.getFileOptions().getName()).isEmpty() && !file.getAbsolutePath().replace('\\', '/').endsWith(fileName.replace('\\', '/'))) {
            CompilerWarning warning = new CompilerWarning(String.valueOf(file) + " has the wrong file name in the file options (" + fileName + ")", new Target(0, file, 0), null);
            env.getEnv(CompilerEnvironment.class).addCompilerWarning(null, warning);
        }
        Collection<ExtensionTracker> exts = ExtensionManager.getTrackers().values();
        HashSet<String> notFound = new HashSet<String>();
        for (String extension : tokenList.getFileOptions().getRequiredExtensions()) {
            boolean found = false;
            for (ExtensionTracker extensionTracker : exts) {
                if (!extensionTracker.getIdentifier().equalsIgnoreCase(extension)) continue;
                found = true;
                break;
            }
            if (found) continue;
            notFound.add(extension);
        }
        if (!notFound.isEmpty()) {
            throw new ConfigCompileException("Could not compile file, because one or more required extensions are not loaded: " + StringUtils.Join(notFound, ", ") + ". These extensions must be provided before compilation can continue.", new Target(0, file, 0));
        }
        return tokenList;
    }

    public static List<Script> preprocess(TokenStream tokenStream, Set<Class<? extends Environment.EnvironmentImpl>> envs) throws ConfigCompileException {
        if (tokenStream == null || tokenStream.isEmpty()) {
            return new ArrayList<Script>();
        }
        while (!tokenStream.isEmpty() && ((Token)tokenStream.getFirst()).type == Token.TType.NEWLINE) {
            tokenStream.removeFirst();
        }
        if (tokenStream.isEmpty()) {
            return new ArrayList<Script>();
        }
        ListIterator it = tokenStream.listIterator(0);
        Token token = (Token)it.next();
        block12: while (true) {
            switch (token.type) {
                case WHITESPACE: {
                    it.remove();
                    if (!it.hasNext()) break block12;
                    token = (Token)it.next();
                    continue block12;
                }
                case NEWLINE: {
                    while (it.hasNext()) {
                        token = (Token)it.next();
                        if (token.type != Token.TType.NEWLINE) continue block12;
                        it.remove();
                    }
                    break block12;
                }
                default: {
                    if (!it.hasNext()) break block12;
                    token = (Token)it.next();
                    continue block12;
                }
            }
            break;
        }
        boolean insideMultiline = false;
        ListIterator it2 = tokenStream.listIterator(0);
        Token token2 = null;
        block14: while (it2.hasNext()) {
            token2 = (Token)it2.next();
            switch (token2.type) {
                case ALIAS_END: {
                    if (!it2.hasNext()) continue block14;
                    if (((Token)it2.next()).type == Token.TType.MULTILINE_START) {
                        insideMultiline = true;
                        it2.remove();
                        it2.previous();
                        it2.next();
                        continue block14;
                    }
                    it2.previous();
                    continue block14;
                }
                case MULTILINE_END: {
                    if (!insideMultiline) {
                        throw new ConfigCompileException("Found multiline end symbol, and no multiline start found", token2.target);
                    }
                    insideMultiline = false;
                    it2.remove();
                    continue block14;
                }
                case MULTILINE_START: {
                    if (insideMultiline) {
                        throw new ConfigCompileException("Did not expect a multiline start symbol here, are you missing a multiline end symbol above this line?", token2.target);
                    }
                    it2.previous();
                    if (!it2.hasPrevious() || ((Token)it2.previous()).type != Token.TType.ALIAS_END) {
                        throw new ConfigCompileException("Multiline symbol must follow the alias_end (=) symbol", token2.target);
                    }
                    it2.next();
                    it2.next();
                    continue block14;
                }
                case NEWLINE: {
                    if (!insideMultiline) continue block14;
                    it2.remove();
                    continue block14;
                }
                case COMMENT: {
                    it2.remove();
                    continue block14;
                }
            }
            if (token2.type == Token.TType.STRING || !token2.val().equals("\\") || !it2.hasNext()) continue;
            if (((Token)it2.next()).type == Token.TType.NEWLINE) {
                it2.remove();
                it2.previous();
                it2.next();
                continue;
            }
            it2.previous();
        }
        assert (token2 != null);
        if (insideMultiline) {
            throw new ConfigCompileException("Expecting a multiline end symbol, but your last multiline alias appears to be missing one.", token2.target);
        }
        ArrayList<Token> left = new ArrayList<Token>();
        ArrayList<Token> right = new ArrayList<Token>();
        ArrayList<Script> scripts = new ArrayList<Script>();
        SmartComment comment = null;
        it2 = tokenStream.listIterator(0);
        block15: while (it2.hasNext()) {
            Token t = (Token)it2.next();
            if (t.type == Token.TType.SMART_COMMENT) {
                if (comment != null) {
                    // empty if block
                }
                comment = new SmartComment(t.val());
                t = (Token)it2.next();
            }
            while (t.type != Token.TType.ALIAS_END) {
                if (!it2.hasNext()) break block15;
                left.add(t);
                t = (Token)it2.next();
            }
            while (t.type != Token.TType.NEWLINE) {
                assert (it2.hasNext());
                right.add(t);
                t = (Token)it2.next();
            }
            if (t.type != Token.TType.NEWLINE) continue;
            for (int j = left.size() - 1; j >= 0; --j) {
                if (((Token)left.get((int)j)).type != Token.TType.NEWLINE || j <= 0 || ((Token)left.get((int)(j - 1))).type == Token.TType.WHITESPACE) continue;
                throw new ConfigCompileException("Unexpected token: " + ((Token)left.get(j - 1)).val(), ((Token)left.get(j - 1)).getTarget());
            }
            Script s = new Script(left, right, null, envs, tokenStream.getFileOptions(), comment);
            scripts.add(s);
            left = new ArrayList();
            right = new ArrayList();
            comment = null;
        }
        return scripts;
    }

    public static ParseTree compile(TokenStream stream, Environment environment, Set<Class<? extends Environment.EnvironmentImpl>> envs) throws ConfigCompileException, ConfigCompileGroupException {
        return MethodScriptCompiler.compile(stream, environment, envs, new StaticAnalysis(true));
    }

    public static ParseTree compile(TokenStream stream, Environment environment, Set<Class<? extends Environment.EnvironmentImpl>> envs, StaticAnalysis staticAnalysis) throws ConfigCompileException, ConfigCompileGroupException {
        Target unknown;
        Objects.requireNonNull(envs, "envs parameter must not be null");
        Objects.requireNonNull(staticAnalysis, "Static Analysis may be disabled, but cannot be null.");
        try {
            if (environment == null) {
                environment = Static.GenerateStandaloneEnvironment(false);
            }
            if (!environment.hasEnv(CompilerEnvironment.class)) {
                Environment e = Static.GenerateStandaloneEnvironment(false);
                environment = environment.cloneAndAdd(e.getEnv(CompilerEnvironment.class));
            }
            environment.getEnv(CompilerEnvironment.class).setStaticAnalysis(staticAnalysis);
        }
        catch (Profiles.InvalidProfileException | DataSourceException | IOException | URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        HashSet<ConfigCompileException> compilerErrors = new HashSet<ConfigCompileException>();
        if (stream == null || stream.isEmpty()) {
            staticAnalysis.analyze(null, environment, envs, compilerErrors);
            return null;
        }
        try {
            unknown = new Target(0, ((Token)stream.get((int)0)).target.file(), 0);
        }
        catch (Exception e) {
            unknown = Target.UNKNOWN;
        }
        ListIterator it = stream.listIterator(0);
        while (it.hasNext()) {
            if (!((Token)it.next()).type.isWhitespace()) continue;
            it.remove();
        }
        MethodScriptCompiler.processEarlyKeywords(stream, environment, compilerErrors);
        if (!compilerErrors.isEmpty()) {
            throw new ConfigCompileGroupException(compilerErrors);
        }
        FileOptions fileOptions = stream.getFileOptions();
        ParseTree rootNode = new ParseTree(fileOptions);
        rootNode.setData(CNull.NULL);
        ParseTree tree = rootNode;
        Stack<ParseTree> parents = new Stack<ParseTree>();
        Stack<AtomicInteger> constructCount = new Stack<AtomicInteger>();
        constructCount.push(new AtomicInteger(0));
        parents.push(tree);
        tree.addChild(new ParseTree(new CFunction("__autoconcat__", unknown), fileOptions, true));
        parents.push(tree.getChildAt(0));
        tree = tree.getChildAt(0);
        constructCount.push(new AtomicInteger(0));
        Stack<AtomicInteger> arrayStack = new Stack<AtomicInteger>();
        arrayStack.add(new AtomicInteger(-1));
        Stack<AtomicInteger> minusArrayStack = new Stack<AtomicInteger>();
        Stack<AtomicInteger> minusFuncStack = new Stack<AtomicInteger>();
        int parens = 0;
        Token t = null;
        int braceCount = 0;
        SmartComment lastSmartComment = null;
        Token[] tokenArray = (Token[])stream.toArray(Token[]::new);
        for (int i = 0; i < tokenArray.length; ++i) {
            ArrayList<ParseTree> subChildren;
            Token next3;
            t = tokenArray[i];
            Token prev1 = i - 1 >= 0 ? tokenArray[i - 1] : new Token(Token.TType.UNKNOWN, "", t.target.copy());
            Token next1 = i + 1 < stream.size() ? tokenArray[i + 1] : new Token(Token.TType.UNKNOWN, "", t.target.copy());
            Token next2 = i + 2 < stream.size() ? tokenArray[i + 2] : new Token(Token.TType.UNKNOWN, "", t.target.copy());
            Token token = next3 = i + 3 < stream.size() ? tokenArray[i + 3] : new Token(Token.TType.UNKNOWN, "", t.target.copy());
            if (t.type == Token.TType.LCURLY_BRACKET) {
                ParseTree b = new ParseTree(new CFunction("__cbrace__", t.getTarget()), fileOptions, true);
                tree.addChild(b);
                tree = b;
                parents.push(b);
                ++braceCount;
                constructCount.push(new AtomicInteger(0));
                continue;
            }
            if (t.type == Token.TType.RCURLY_BRACKET) {
                if (braceCount == 0) {
                    throw new ConfigCompileException("Unexpected end curly brace", t.target);
                }
                --braceCount;
                if (((AtomicInteger)constructCount.peek()).get() > 1) {
                    int stacks = ((AtomicInteger)constructCount.peek()).get();
                    int replaceAt = tree.getChildren().size() - stacks;
                    ParseTree c = new ParseTree(new CFunction("__autoconcat__", tree.getTarget()), fileOptions, true);
                    subChildren = new ArrayList<ParseTree>();
                    for (int b = replaceAt; b < tree.numberOfChildren(); ++b) {
                        subChildren.add(tree.getChildAt(b));
                    }
                    c.setChildren(subChildren);
                    if (replaceAt > 0) {
                        ArrayList<ParseTree> firstChildren = new ArrayList<ParseTree>();
                        for (int d = 0; d < replaceAt; ++d) {
                            firstChildren.add(tree.getChildAt(d));
                        }
                        tree.setChildren(firstChildren);
                    } else {
                        tree.removeChildren();
                    }
                    tree.addChild(c);
                }
                parents.pop();
                tree = (ParseTree)parents.peek();
                constructCount.pop();
                try {
                    ((AtomicInteger)constructCount.peek()).incrementAndGet();
                    continue;
                }
                catch (EmptyStackException e) {
                    throw new ConfigCompileException("Unexpected end curly brace", t.target);
                }
            }
            if (t.type == Token.TType.LABEL && !tree.getChildren().isEmpty()) {
                if (!prev1.type.isAtomicLit() && prev1.type != Token.TType.IVARIABLE && prev1.type != Token.TType.KEYWORD) {
                    ConfigCompileException error = new ConfigCompileException("Invalid label specified", t.getTarget());
                    if (prev1.type == Token.TType.FUNC_END) {
                        throw error;
                    }
                    compilerErrors.add(error);
                }
                ParseTree cc = tree.getChildren().get(tree.getChildren().size() - 1);
                tree.removeChildAt(tree.getChildren().size() - 1);
                tree.addChild(new ParseTree(new CLabel(cc.getData()), fileOptions));
                continue;
            }
            if (t.type.equals((Object)Token.TType.LSQUARE_BRACKET)) {
                arrayStack.push(new AtomicInteger(tree.getChildren().size() - 1));
                continue;
            }
            if (t.type.equals((Object)Token.TType.RSQUARE_BRACKET)) {
                ParseTree myIndex;
                boolean emptyArray = false;
                if (prev1.type.equals((Object)Token.TType.LSQUARE_BRACKET)) {
                    emptyArray = true;
                }
                if (arrayStack.size() == 1) {
                    throw new ConfigCompileException("Mismatched square bracket", t.target);
                }
                int array2 = ((AtomicInteger)arrayStack.pop()).get();
                int index = array2 + 1;
                if (array2 == -1 || array2 >= tree.numberOfChildren()) {
                    throw new ConfigCompileException("Brackets are illegal here", t.target);
                }
                ParseTree myArray = tree.getChildAt(array2);
                if (!emptyArray) {
                    myIndex = new ParseTree(new CFunction("__autoconcat__", myArray.getTarget()), fileOptions, true);
                    for (int j = index; j < tree.numberOfChildren(); ++j) {
                        myIndex.addChild(tree.getChildAt(j));
                    }
                } else {
                    myIndex = new ParseTree(new CSlice("0..-1", t.target), fileOptions, true);
                }
                tree.setChildren(tree.getChildren().subList(0, array2));
                ParseTree arrayGet = new ParseTree(new CFunction("array_get", t.target), fileOptions, true);
                arrayGet.addChild(myArray);
                arrayGet.addChild(myIndex);
                if (!minusArrayStack.isEmpty() && arrayStack.size() + 1 == ((AtomicInteger)minusArrayStack.peek()).get()) {
                    if (!next1.type.equals((Object)Token.TType.LSQUARE_BRACKET)) {
                        ParseTree negTree = new ParseTree(new CFunction("neg", unknown), fileOptions, true);
                        negTree.addChild(arrayGet);
                        tree.addChild(negTree);
                        minusArrayStack.pop();
                    } else {
                        tree.addChild(arrayGet);
                    }
                } else {
                    tree.addChild(arrayGet);
                }
                ((AtomicInteger)constructCount.peek()).set(((AtomicInteger)constructCount.peek()).get() - myIndex.numberOfChildren());
                continue;
            }
            if (t.type == Token.TType.SMART_STRING) {
                if (t.val().replace("\\\\", "").replace("\\@", "").contains("@")) {
                    ParseTree function = new ParseTree(fileOptions);
                    function.setData(new CFunction("__smart_string__", t.target));
                    ParseTree string = new ParseTree(fileOptions);
                    string.setData(new CString(t.value, t.target));
                    function.addChild(string);
                    tree.addChild(function);
                } else {
                    String str = t.val().replace("\\\\", "\\").replace("\\@", "@");
                    tree.addChild(new ParseTree(new CString(str, t.target), fileOptions, true));
                }
                ((AtomicInteger)constructCount.peek()).incrementAndGet();
                continue;
            }
            if (t.type == Token.TType.DEREFERENCE) {
                compilerErrors.add(new ConfigCompileException("The '" + t.val() + "' symbol is not currently allowed in raw strings. You must quote all symbols.", t.target));
            } else if (t.type.equals((Object)Token.TType.FUNC_NAME)) {
                CFunction func = new CFunction(t.val(), t.target);
                try {
                    OperatorPreferred opPref = func.getFunction().getClass().getAnnotation(OperatorPreferred.class);
                    if (opPref != null) {
                        String msg2 = "The operator \"" + opPref.value() + "\" is preferred over the functional usage.";
                        CompilerWarning warning = new CompilerWarning(msg2, t.target, FileOptions.SuppressWarning.CodeUpgradeNotices);
                        environment.getEnv(CompilerEnvironment.class).addCodeUpgradeNotice(fileOptions, warning);
                    }
                }
                catch (ConfigCompileException opPref) {
                    // empty catch block
                }
                ParseTree f = new ParseTree(func, fileOptions);
                tree.addChild(f);
                constructCount.push(new AtomicInteger(0));
                tree = f;
                parents.push(f);
            } else if (t.type.equals((Object)Token.TType.FUNC_START)) {
                if (!prev1.type.equals((Object)Token.TType.FUNC_NAME)) {
                    ParseTree f;
                    if (prev1.type != Token.TType.SEMICOLON && prev1.type != Token.TType.COMMA && prev1.type != Token.TType.FUNC_START && !prev1.type.isSymbol() && prev1.target.line() != t.target.line() && MSVersion.LATEST.lt(new SimpleVersion(3, 3, 7))) {
                        CompilerWarning warning = new CompilerWarning("This will attempt to execute the previous statement in version 3.3.7 and above. If this is not intended, place a semicolon at the end of the above line, and this warning will go away. If it is intended, move this parenthesis up to the same line to actually execute it.", t.target, FileOptions.SuppressWarning.PossibleUnexpectedExecution);
                        environment.getEnv(CompilerEnvironment.class).addCompilerWarning(fileOptions, warning);
                        f = new ParseTree(new CFunction("__autoconcat__", unknown), fileOptions);
                    } else {
                        f = new ParseTree(new CFunction("p", t.getTarget()), fileOptions);
                    }
                    constructCount.push(new AtomicInteger(0));
                    tree.addChild(f);
                    tree = f;
                    parents.push(f);
                }
                ++parens;
            } else if (t.type.equals((Object)Token.TType.FUNC_END)) {
                if (parens <= 0) {
                    throw new ConfigCompileException("Unexpected parenthesis", t.target);
                }
                --parens;
                parents.pop();
                if (((AtomicInteger)constructCount.peek()).get() > 1) {
                    int stacks = ((AtomicInteger)constructCount.peek()).get();
                    int replaceAt = tree.getChildren().size() - stacks;
                    ParseTree c = new ParseTree(new CFunction("__autoconcat__", tree.getTarget()), fileOptions, true);
                    subChildren = new ArrayList();
                    for (int b = replaceAt; b < tree.numberOfChildren(); ++b) {
                        subChildren.add(tree.getChildAt(b));
                    }
                    c.setChildren(subChildren);
                    if (replaceAt > 0) {
                        ArrayList<ParseTree> firstChildren = new ArrayList<ParseTree>();
                        for (int d = 0; d < replaceAt; ++d) {
                            firstChildren.add(tree.getChildAt(d));
                        }
                        tree.setChildren(firstChildren);
                    } else {
                        tree.removeChildren();
                    }
                    tree.addChild(c);
                }
                constructCount.pop();
                try {
                    ((AtomicInteger)constructCount.peek()).incrementAndGet();
                }
                catch (EmptyStackException e) {
                    throw new ConfigCompileException("Unexpected end parenthesis", t.target);
                }
                try {
                    tree = (ParseTree)parents.peek();
                }
                catch (EmptyStackException e) {
                    throw new ConfigCompileException("Unexpected end parenthesis", t.target);
                }
                if (!minusFuncStack.isEmpty() && ((AtomicInteger)minusFuncStack.peek()).get() == parens + 1) {
                    if (next1.type.equals((Object)Token.TType.LSQUARE_BRACKET)) {
                        minusArrayStack.push(new AtomicInteger(arrayStack.size() + 1));
                    } else {
                        ParseTree negTree = new ParseTree(new CFunction("neg", unknown), fileOptions);
                        negTree.addChild(tree.getChildAt(tree.numberOfChildren() - 1));
                        tree.removeChildAt(tree.numberOfChildren() - 1);
                        tree.addChildAt(tree.numberOfChildren(), negTree);
                    }
                    minusFuncStack.pop();
                }
            } else {
                if (t.type.equals((Object)Token.TType.COMMA)) {
                    if (((AtomicInteger)constructCount.peek()).get() > 1) {
                        int stacks = ((AtomicInteger)constructCount.peek()).get();
                        int replaceAt = tree.getChildren().size() - stacks;
                        ParseTree c = new ParseTree(new CFunction("__autoconcat__", unknown), fileOptions);
                        subChildren = new ArrayList();
                        for (int b = replaceAt; b < tree.numberOfChildren(); ++b) {
                            subChildren.add(tree.getChildAt(b));
                        }
                        c.setChildren(subChildren);
                        if (replaceAt > 0) {
                            ArrayList<ParseTree> firstChildren = new ArrayList<ParseTree>();
                            for (int d = 0; d < replaceAt; ++d) {
                                firstChildren.add(tree.getChildAt(d));
                            }
                            tree.setChildren(firstChildren);
                        } else {
                            tree.removeChildren();
                        }
                        tree.addChild(c);
                    }
                    ((AtomicInteger)constructCount.peek()).set(0);
                    continue;
                }
                if (t.type == Token.TType.SLICE || next1.type == Token.TType.SLICE) {
                    if (t.type == Token.TType.SLICE) {
                        try {
                            Object value = next1.val();
                            if (next1.type == Token.TType.MINUS || next1.type == Token.TType.PLUS) {
                                value = next1.val() + next2.val();
                                ++i;
                            }
                            CSlice slice = new CSlice(".." + (String)value, t.getTarget());
                            ++i;
                            tree.addChild(new ParseTree(slice, fileOptions));
                            ((AtomicInteger)constructCount.peek()).incrementAndGet();
                            continue;
                        }
                        catch (ConfigRuntimeException ex) {
                            throw new ConfigCompileException(ex);
                        }
                    }
                    if (next1.type.equals((Object)Token.TType.SLICE)) {
                        try {
                            CSlice slice;
                            if (t.type.isSeparator() || t.type.isWhitespace() && prev1.type.isSeparator() || t.type.isKeyword()) {
                                Object value = next2.val();
                                ++i;
                                if (next2.type == Token.TType.MINUS || next2.type == Token.TType.PLUS) {
                                    value = next2.val() + next3.val();
                                    ++i;
                                }
                                slice = new CSlice(".." + (String)value, next1.getTarget());
                                if (t.type.isKeyword()) {
                                    tree.addChild(new ParseTree(new CKeyword(t.val(), t.getTarget()), fileOptions));
                                    ((AtomicInteger)constructCount.peek()).incrementAndGet();
                                }
                            } else if (next2.type.isSeparator() || next2.type.isKeyword()) {
                                String modifier = "";
                                if (prev1.type == Token.TType.MINUS || prev1.type == Token.TType.PLUS) {
                                    modifier = prev1.val();
                                    tree.removeChildAt(tree.getChildren().size() - 1);
                                }
                                slice = new CSlice(modifier + t.value + "..", t.target);
                            } else {
                                String modifier1 = "";
                                if (prev1.type == Token.TType.MINUS || prev1.type == Token.TType.PLUS) {
                                    modifier1 = prev1.val();
                                    tree.removeChildAt(tree.getChildren().size() - 1);
                                }
                                Token first = t;
                                if (first.type.isWhitespace()) {
                                    first = prev1;
                                }
                                Token second = next2;
                                ++i;
                                String modifier2 = "";
                                if (next2.type == Token.TType.MINUS || next2.type == Token.TType.PLUS) {
                                    modifier2 = next2.val();
                                    second = next3;
                                    ++i;
                                }
                                slice = new CSlice(modifier1 + first.value + ".." + modifier2 + second.value, t.target);
                            }
                            ++i;
                            tree.addChild(new ParseTree(slice, fileOptions));
                            ((AtomicInteger)constructCount.peek()).incrementAndGet();
                            continue;
                        }
                        catch (ConfigRuntimeException ex) {
                            throw new ConfigCompileException(ex);
                        }
                    }
                } else {
                    if (t.type == Token.TType.VARARGS) {
                        if (tree.getChildren().isEmpty()) {
                            throw new ConfigCompileException("Unexpected varargs token (\"...\")", t.target);
                        }
                        ParseTree previous = tree.getChildAt(tree.getChildren().size() - 1);
                        if (!(previous.getData() instanceof SourceType)) {
                            throw new ConfigCompileException("Unexpected varargs token (\"...\"). This can only be used with types.", t.target);
                        }
                        Mixed mixed = previous.getData();
                        if (!(mixed instanceof SourceType)) continue;
                        SourceType st = (SourceType)mixed;
                        previous.setData(st.asVariadicType(null));
                        continue;
                    }
                    if (t.type == Token.TType.LIT) {
                        Construct c;
                        try {
                            c = Static.resolveConstruct(t.val(), t.target, true);
                        }
                        catch (ConfigRuntimeException ex) {
                            throw new ConfigCompileException(ex);
                        }
                        if (c instanceof CInt && next1.type == Token.TType.DOT && next2.type == Token.TType.LIT) {
                            try {
                                c = new CDouble(Double.parseDouble(t.val() + "." + next2.val()), t.target);
                                i += 2;
                            }
                            catch (NumberFormatException ex) {
                                // empty catch block
                            }
                            ((AtomicInteger)constructCount.peek()).incrementAndGet();
                        } else if (c instanceof CDecimal) {
                            String neg2 = "";
                            if (prev1.value.equals("-")) {
                                neg2 = "-";
                                tree.removeChildAt(tree.getChildren().size() - 1);
                            } else {
                                ((AtomicInteger)constructCount.peek()).incrementAndGet();
                            }
                            if (next1.type == Token.TType.DOT && next2.type == Token.TType.LIT) {
                                c = new CDecimal(neg2 + t.value.substring(2) + "." + next2.value, t.target);
                                i += 2;
                            } else {
                                c = new CDecimal(neg2 + t.value.substring(2), t.target);
                            }
                        } else {
                            ((AtomicInteger)constructCount.peek()).incrementAndGet();
                        }
                        tree.addChild(new ParseTree(c, fileOptions));
                    } else if (t.type.equals((Object)Token.TType.STRING) || t.type.equals((Object)Token.TType.COMMAND)) {
                        tree.addChild(new ParseTree(new CString(t.val(), t.target), fileOptions));
                        ((AtomicInteger)constructCount.peek()).incrementAndGet();
                    } else if (t.type.equals((Object)Token.TType.IDENTIFIER)) {
                        tree.addChild(new ParseTree(new CPreIdentifier(t.val(), t.target), fileOptions));
                        ((AtomicInteger)constructCount.peek()).incrementAndGet();
                    } else if (t.type.isKeyword()) {
                        tree.addChild(new ParseTree(new CKeyword(t.val(), t.getTarget()), fileOptions));
                        ((AtomicInteger)constructCount.peek()).incrementAndGet();
                    } else if (t.type.equals((Object)Token.TType.IVARIABLE)) {
                        tree.addChild(new ParseTree(new IVariable(t.val(), t.target), fileOptions));
                        ((AtomicInteger)constructCount.peek()).incrementAndGet();
                    } else if (t.type.equals((Object)Token.TType.UNKNOWN)) {
                        tree.addChild(new ParseTree(Static.resolveConstruct(t.val(), t.target), fileOptions));
                        ((AtomicInteger)constructCount.peek()).incrementAndGet();
                    } else if (t.type.isSymbol()) {
                        if (!(!t.type.equals((Object)Token.TType.MINUS) || prev1.type.isAtomicLit() || prev1.type.equals((Object)Token.TType.IVARIABLE) || prev1.type.equals((Object)Token.TType.VARIABLE) || prev1.type.equals((Object)Token.TType.RCURLY_BRACKET) || prev1.type.equals((Object)Token.TType.RSQUARE_BRACKET) || prev1.type.equals((Object)Token.TType.FUNC_END) || !next1.type.equals((Object)Token.TType.IVARIABLE) && !next1.type.equals((Object)Token.TType.VARIABLE) && !next1.type.equals((Object)Token.TType.FUNC_NAME))) {
                            if (next2.type.equals((Object)Token.TType.LSQUARE_BRACKET)) {
                                minusArrayStack.push(new AtomicInteger(arrayStack.size() + 1));
                            } else if (next1.type.equals((Object)Token.TType.FUNC_NAME)) {
                                minusFuncStack.push(new AtomicInteger(parens + 1));
                            } else {
                                ParseTree negTree = new ParseTree(new CFunction("neg", unknown), fileOptions);
                                negTree.addChild(new ParseTree(new IVariable(next1.value, next1.target), fileOptions));
                                tree.addChild(negTree);
                                ((AtomicInteger)constructCount.peek()).incrementAndGet();
                                ++i;
                            }
                        } else {
                            tree.addChild(new ParseTree(new CSymbol(t.val(), t.type, t.target), fileOptions));
                            ((AtomicInteger)constructCount.peek()).incrementAndGet();
                        }
                    } else if (t.type == Token.TType.DOT) {
                        Construct c = null;
                        if (next1.type == Token.TType.LIT && prev1.type != Token.TType.STRING && prev1.type != Token.TType.SMART_STRING) {
                            try {
                                c = new CDouble(Double.parseDouble("." + next1.val()), t.target);
                                ++i;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (c == null) {
                            c = new CSymbol(".", Token.TType.CONCAT, t.target);
                        }
                        tree.addChild(new ParseTree(c, fileOptions));
                        ((AtomicInteger)constructCount.peek()).incrementAndGet();
                    } else if (t.type.equals((Object)Token.TType.VARIABLE) || t.type.equals((Object)Token.TType.FINAL_VAR)) {
                        tree.addChild(new ParseTree(new Variable(t.val(), null, false, t.type.equals((Object)Token.TType.FINAL_VAR), t.target), fileOptions));
                        ((AtomicInteger)constructCount.peek()).incrementAndGet();
                    } else {
                        if (t.type.equals((Object)Token.TType.SMART_COMMENT)) {
                            lastSmartComment = new SmartComment(t.val());
                            continue;
                        }
                        if (t.type.equals((Object)Token.TType.SEMICOLON)) {
                            tree.addChild(new ParseTree(new CSemicolon(t.target), fileOptions));
                            ((AtomicInteger)constructCount.peek()).incrementAndGet();
                        }
                    }
                }
            }
            if (lastSmartComment == null) continue;
            if (tree.getChildren().isEmpty()) {
                tree.getNodeModifiers().setComment(lastSmartComment);
            } else {
                tree.getChildren().get(tree.getChildren().size() - 1).getNodeModifiers().setComment(lastSmartComment);
            }
            lastSmartComment = null;
        }
        assert (t != null || stream.isEmpty());
        assert (!arrayStack.isEmpty()) : "The last element of arrayStack should be present, but it was popped.";
        if (arrayStack.size() != 1) {
            Target target = MethodScriptCompiler.traceMismatchedOpenToken(stream, Token.TType.LSQUARE_BRACKET, Token.TType.RSQUARE_BRACKET);
            assert (target != null) : "Mismatched bracket was detected, but target-finding code could not find it.";
            throw new ConfigCompileException("Mismatched square brackets", target);
        }
        if (parens != 0) {
            Target target = MethodScriptCompiler.traceMismatchedOpenToken(stream, Token.TType.FUNC_START, Token.TType.FUNC_END);
            assert (target != null) : "Mismatched parentheses was detected, but target-finding code could not find it.";
            throw new ConfigCompileException("Mismatched parentheses", target);
        }
        if (braceCount != 0) {
            Target target = MethodScriptCompiler.traceMismatchedOpenToken(stream, Token.TType.LCURLY_BRACKET, Token.TType.RCURLY_BRACKET);
            assert (target != null) : "Mismatched curly brace was detected, but target-finding code could not find it.";
            throw new ConfigCompileException("Mismatched curly braces", target);
        }
        assert (parents.size() == 2) : "Expected exactly the root and autoconcat nodes on parents stack.";
        assert (parents.pop() == tree) : "Mismatching stack element.";
        assert (parents.pop() == rootNode) : "Expected the last element of the stack to be the root node.";
        assert (rootNode.getChildAt(0) == tree) : "Expected tree to be the first child of the root node.";
        Stack<List<Procedure>> procs = new Stack<List<Procedure>>();
        procs.add(new ArrayList());
        MethodScriptCompiler.processKeywords(tree, environment, compilerErrors);
        MethodScriptCompiler.addSelfStatements(tree, environment, envs, compilerErrors);
        MethodScriptCompiler.rewriteAutoconcats(tree, environment, envs, compilerErrors, true);
        MethodScriptCompiler.processLateKeywords(tree, environment, compilerErrors);
        MethodScriptCompiler.checkLinearComponents(tree, environment, compilerErrors);
        MethodScriptCompiler.postParseRewrite(rootNode, environment, envs, compilerErrors, true);
        tree = rootNode.getChildAt(0);
        MethodScriptCompiler.moveNodeModifiersOffSyntheticNodes(tree);
        staticAnalysis.analyze(tree, environment, envs, compilerErrors);
        MethodScriptCompiler.optimize(tree, environment, envs, procs, compilerErrors);
        MethodScriptCompiler.link(tree, compilerErrors);
        MethodScriptCompiler.checkFunctionsExist(tree, compilerErrors, envs);
        MethodScriptCompiler.checkBreaks(tree, compilerErrors);
        if (!staticAnalysis.isLocalEnabled()) {
            MethodScriptCompiler.checkUnhandledCompilerConstructs(tree, environment, compilerErrors);
        }
        if (!compilerErrors.isEmpty()) {
            if (compilerErrors.size() == 1) {
                throw (ConfigCompileException)compilerErrors.iterator().next();
            }
            throw new ConfigCompileGroupException(compilerErrors);
        }
        MethodScriptCompiler.eliminateDeadCode(tree, environment, envs);
        return rootNode;
    }

    private static void checkLinearComponents(ParseTree tree, Environment env, Set<ConfigCompileException> compilerErrors) {
        for (ParseTree m : tree.getAllNodes()) {
            if (!(m.getData() instanceof CBareString) || m.getData() instanceof CKeyword) continue;
            if (m.getFileOptions().isStrict()) {
                compilerErrors.add(new ConfigCompileException("Use of bare (unquoted) string: " + m.getData().val(), m.getTarget()));
                continue;
            }
            env.getEnv(CompilerEnvironment.class).addCompilerWarning(m.getFileOptions(), new CompilerWarning("Use of bare (unquoted) string: " + m.getData().val(), m.getTarget(), FileOptions.SuppressWarning.UseBareStrings));
        }
    }

    private static Target traceMismatchedOpenToken(TokenStream stream, Token.TType openType, Token.TType closeType) {
        Iterator iterator = stream.descendingIterator();
        int closingCount = 0;
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            if (token.type == closeType) {
                ++closingCount;
                continue;
            }
            if (token.type != openType) continue;
            if (closingCount <= 0) {
                return token.target;
            }
            --closingCount;
        }
        return null;
    }

    private static void checkBreaks(ParseTree tree, Set<ConfigCompileException> compilerExceptions) {
        MethodScriptCompiler.checkBreaks0(tree, 0L, null, compilerExceptions);
    }

    private static void checkBreaks0(ParseTree tree, long currentLoops, String lastUnbreakable, Set<ConfigCompileException> compilerErrors) {
        Function func;
        if (!(tree.getData() instanceof CFunction)) {
            return;
        }
        if (!((CFunction)tree.getData()).hasFunction()) {
            for (ParseTree child : tree.getChildren()) {
                MethodScriptCompiler.checkBreaks0(child, currentLoops, lastUnbreakable, compilerErrors);
            }
            return;
        }
        try {
            func = ((CFunction)tree.getData()).getFunction();
        }
        catch (ConfigCompileException ex) {
            compilerErrors.add(ex);
            return;
        }
        if (func.getClass().getAnnotation(nolinking.class) != null) {
            return;
        }
        if (func instanceof ControlFlow._break) {
            long breakCounter = 1L;
            if (tree.getChildren().size() == 1) {
                try {
                    breakCounter = ArgumentValidation.getInt32(tree.getChildAt(0).getData(), tree.getChildAt(0).getTarget());
                }
                catch (CRECastException | CRERangeException e) {
                    compilerErrors.add(new ConfigCompileException(e));
                    return;
                }
            }
            if (breakCounter > currentLoops) {
                if (currentLoops == 0L) {
                    compilerErrors.add(new ConfigCompileException("The break() function can only break out of loops" + (String)(lastUnbreakable == null ? "." : ", but an attempt to break out of a " + lastUnbreakable + " was detected."), tree.getTarget()));
                } else {
                    compilerErrors.add(new ConfigCompileException("Too many breaks detected. Check your loop nesting, and set the break count to an appropriate value.", tree.getTarget()));
                }
            }
            return;
        }
        if (func.getClass().getAnnotation(unbreakable.class) != null) {
            for (ParseTree child : tree.getChildren()) {
                MethodScriptCompiler.checkBreaks0(child, 0L, func.getName(), compilerErrors);
            }
            return;
        }
        if (func.getClass().getAnnotation(breakable.class) != null) {
            ++currentLoops;
        }
        for (ParseTree child : tree.getChildren()) {
            MethodScriptCompiler.checkBreaks0(child, currentLoops, lastUnbreakable, compilerErrors);
        }
    }

    private static void moveNodeModifiersOffSyntheticNodes(ParseTree node) {
        if (node.isSyntheticNode() && node.hasChildren() && node.getNodeModifiers() != null) {
            node.getNodeModifiers().merge(node.getChildAt(0).getNodeModifiers());
        }
        for (ParseTree child : node.getChildren()) {
            MethodScriptCompiler.moveNodeModifiersOffSyntheticNodes(child);
        }
    }

    private static void addSelfStatements(ParseTree root, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Set<ConfigCompileException> compilerErrors) {
        for (int i = 0; i < root.numberOfChildren(); ++i) {
            CFunction cf;
            ParseTree node = root.getChildAt(i);
            boolean isSelfStatement = false;
            Mixed mixed = node.getData();
            if (mixed instanceof CFunction && (cf = (CFunction)mixed).hasFunction()) {
                Function function = null;
                try {
                    function = cf.getFunction();
                }
                catch (ConfigCompileException configCompileException) {
                    // empty catch block
                }
                try {
                    isSelfStatement = function != null && function.isSelfStatement(node.getTarget(), env, node.getChildren(), envs);
                }
                catch (ConfigCompileException ex) {
                    compilerErrors.add(ex);
                    return;
                }
            }
            if (isSelfStatement) {
                CFunction cf2;
                int offset = i + 1;
                Mixed ex = root.getData();
                if (!(ex instanceof CFunction) || !(cf2 = (CFunction)ex).val().equals("__autoconcat__")) {
                    ParseTree newNode = new ParseTree(new CFunction("__autoconcat__", Target.UNKNOWN), root.getFileOptions(), true);
                    newNode.addChild(root);
                    root = newNode;
                    offset = 1;
                }
                root.getChildren().add(offset, new ParseTree(new CSemicolon(Target.UNKNOWN), node.getFileOptions(), true));
            }
            MethodScriptCompiler.addSelfStatements(node, env, envs, compilerErrors);
        }
    }

    public static void rewriteAutoconcats(ParseTree root, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Set<ConfigCompileException> compilerExceptions, boolean rewriteKeywords) {
        Object cf;
        Object object;
        Object subChild;
        if (!root.hasChildren()) {
            if (root.getData() instanceof CFunction && root.getData().val().equals("__autoconcat__")) {
                ParseTree tree = new ParseTree(new CFunction("__statements__", root.getTarget()), root.getFileOptions(), true);
                tree.setOptimized(true);
                root.replace(tree);
            }
            return;
        }
        ArrayList children = new ArrayList();
        ArrayList<ParseTree> ongoingChildren = new ArrayList<ParseTree>();
        for (int i = 0; i < root.numberOfChildren(); ++i) {
            ParseTree child = root.getChildAt(i);
            if (child.getData() instanceof CSemicolon) {
                if (ongoingChildren.isEmpty()) {
                    env.getEnv(CompilerEnvironment.class).addCompilerWarning(child.getFileOptions(), new CompilerWarning("Empty statement.", child.getTarget(), FileOptions.SuppressWarning.UselessCode));
                    continue;
                }
                children.add(ongoingChildren);
                ongoingChildren = new ArrayList();
                continue;
            }
            ongoingChildren.add(child);
        }
        ArrayList<ParseTree> newChildren = new ArrayList<ParseTree>();
        ParseTree statements = new ParseTree(new CFunction("__statements__", root.getTarget()), root.getFileOptions(), true);
        for (int k = 0; k < children.size(); ++k) {
            subChild = (List)children.get(k);
            ParseTree autoconcat = new ParseTree(new CFunction("__autoconcat__", root.getTarget()), root.getFileOptions(), true);
            autoconcat.setChildren((List<ParseTree>)subChild);
            MethodScriptCompiler.rewriteAutoconcats(autoconcat, env, envs, compilerExceptions, false);
            if (rewriteKeywords) {
                if (autoconcat.getChildren().isEmpty()) {
                    ParseTree autoconcat2 = new ParseTree(new CFunction("__autoconcat__", root.getTarget()), root.getFileOptions(), true);
                    autoconcat2.addChild(autoconcat);
                    autoconcat = autoconcat2;
                }
                MethodScriptCompiler.processLateKeywords(autoconcat, env, compilerExceptions);
            }
            if (autoconcat.getChildren().size() == 1 && (object = autoconcat.getChildAt(0).getData()) instanceof CFunction && ((Construct)(cf = (CFunction)object)).val().equals("__statements__") && autoconcat.isSyntheticNode()) {
                autoconcat.replace(autoconcat.getChildAt(0));
            }
            if ((object = autoconcat.getData()) instanceof CFunction && ((Construct)(cf = (CFunction)object)).val().equals("__statements__")) {
                object = autoconcat.getChildren().iterator();
                while (object.hasNext()) {
                    ParseTree statementChild = (ParseTree)object.next();
                    statements.addChild(statementChild);
                }
            } else {
                statements.addChild(autoconcat);
            }
            if (!rewriteKeywords || !((object = autoconcat.getData()) instanceof CFunction)) continue;
            cf = (CFunction)object;
            if (!autoconcat.getData().val().equals("__statements__") || autoconcat.getChildren().size() <= 1 || !root.getFileOptions().isStrict()) continue;
            MethodScriptCompiler.doMissingSemicolonError(autoconcat.getChildAt(0).getTarget(), compilerExceptions);
        }
        if (statements.getChildren().size() == 1 && (subChild = statements.getChildAt(0).getData()) instanceof CFunction) {
            CFunction cf2 = (CFunction)subChild;
            if (statements.getChildAt(0).isSyntheticNode() && (cf2.val().equals("__statements__") || cf2.val().equals("__autoconcat__") || cf2.val().equals("sconcat") || cf2.val().equals("string"))) {
                statements.setChildren(statements.getChildAt(0).getChildren());
            }
        }
        if (!statements.getChildren().isEmpty()) {
            newChildren.add(statements);
        }
        root.setChildren(newChildren);
        if (!ongoingChildren.isEmpty()) {
            for (ParseTree child : ongoingChildren) {
                root.addChild(child);
            }
        }
        for (int j = 0; j < root.getChildren().size(); ++j) {
            MethodScriptCompiler.rewriteAutoconcats(root.getChildAt(j), env, envs, compilerExceptions, true);
        }
        if (root.getData() instanceof CFunction && root.getData().val().equals("__autoconcat__")) {
            boolean returnSConcat = !root.getFileOptions().isStrict();
            try {
                ParseTree ret = Compiler.__autoconcat__.rewrite(root.getChildren(), returnSConcat, envs);
                root.replace(ret);
                boolean hasKeyword = false;
                cf = root.getChildren().iterator();
                while (cf.hasNext()) {
                    ParseTree node = (ParseTree)cf.next();
                    if (!(node.getData() instanceof CKeyword)) continue;
                    hasKeyword = true;
                    break;
                }
                if (rewriteKeywords && !hasKeyword && root.getFileOptions().isStrict() && (object = root.getData()) instanceof CFunction && ((Construct)(cf = (CFunction)object)).val().equals("__statements__") && ret.numberOfChildren() > 1 && !ongoingChildren.isEmpty()) {
                    MethodScriptCompiler.doMissingSemicolonError(root.getChildAt(root.numberOfChildren() - 1).getTarget(), compilerExceptions);
                }
            }
            catch (ConfigCompileException ex) {
                compilerExceptions.add(ex);
            }
        }
    }

    private static void doMissingSemicolonError(Target target, Set<ConfigCompileException> exceptions) {
    }

    private static ParseTree postParseRewrite(ParseTree ast, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Set<ConfigCompileException> exceptions, boolean topLevel) {
        CFunction cFunc;
        Mixed node = ast.getData();
        if (node instanceof CFunction && (cFunc = (CFunction)node).hasFunction()) {
            try {
                Function func = cFunc.getFunction();
                ParseTree newAst = func.postParseRewrite(ast, env, envs, exceptions);
                if (newAst != null) {
                    ast = newAst;
                }
            }
            catch (ConfigCompileException func) {
                // empty catch block
            }
        }
        boolean isStrict = ast.getFileOptions().isStrict();
        for (int i = 0; i < ast.numberOfChildren(); ++i) {
            BranchStatement branchStatement;
            List<Boolean> branches;
            CFunction cFunction;
            Function function;
            Mixed mixed;
            ParseTree child = ast.getChildAt(i);
            ParseTree newChild = MethodScriptCompiler.postParseRewrite(child, env, envs, exceptions, false);
            if (newChild != null && child != newChild) {
                ast.getChildren().set(i, newChild);
                --i;
                continue;
            }
            if (!(child.getData() instanceof CFunction) || !child.getData().val().equals("__statements__") || !((mixed = ast.getData()) instanceof CFunction) || (function = (cFunction = (CFunction)mixed).getCachedFunction()) == null) continue;
            boolean statementsAllowed = false;
            if (function instanceof BranchStatement && (branches = (branchStatement = (BranchStatement)((Object)function)).statementsAllowed(ast.getChildren())).get(i).booleanValue()) {
                statementsAllowed = true;
            }
            if (statementsAllowed) continue;
            Object unexpectedStatement = "Unexpected statement; ";
            try {
                unexpectedStatement = function.isSelfStatement(ast.getTarget(), env, ast.getChildren(), envs) ? (String)unexpectedStatement + cFunction.val() + " not allowed in this context." : (ast.getFileOptions().isStrict() && cFunction.getTarget() != child.getTarget() ? (String)unexpectedStatement + "auto concatenation not allowed in Strict mode. (or invalid semi-colon)" : (String)unexpectedStatement + "semicolon (;) not allowed in this context.");
            }
            catch (ConfigCompileException ex) {
                exceptions.add(ex);
            }
            if (ast.getFileOptions().isStrict()) {
                exceptions.add(new ConfigCompileException((String)unexpectedStatement, child.getTarget()));
                continue;
            }
            if (cFunction.val().equals("sconcat")) continue;
            if (child.getChildren().size() != 1) {
                exceptions.add(new ConfigCompileException((String)unexpectedStatement, child.getTarget()));
                continue;
            }
            CompilerWarning warning = new CompilerWarning((String)unexpectedStatement, child.getTarget(), FileOptions.SuppressWarning.UnexpectedStatement);
            env.getEnv(CompilerEnvironment.class).addCompilerWarning(ast.getFileOptions(), warning);
            child.replace(child.getChildren().get(0));
        }
        return ast;
    }

    private static void link(ParseTree tree, Set<ConfigCompileException> compilerErrors) {
        CFunction cFunction;
        Function function;
        Mixed mixed = tree.getData();
        if (mixed instanceof CFunction && (function = (cFunction = (CFunction)mixed).getCachedFunction()) != null) {
            Optimizable op;
            if (function.getClass().getAnnotation(nolinking.class) != null) {
                return;
            }
            if (!MethodScriptCompiler.isValidNumArgs(function, tree.getChildren().size())) {
                compilerErrors.add(new ConfigCompileException("Incorrect number of arguments passed to " + tree.getData().val(), tree.getData().getTarget()));
            }
            if (function instanceof Optimizable && (op = (Optimizable)function).optimizationOptions().contains(Optimizable.OptimizationOption.CUSTOM_LINK)) {
                try {
                    op.link(tree.getData().getTarget(), tree.getChildren());
                }
                catch (ConfigRuntimeException ex) {
                    compilerErrors.add(new ConfigCompileException(ex));
                }
                catch (ConfigCompileException ex) {
                    compilerErrors.add(ex);
                }
            }
        }
        for (ParseTree child : tree.getChildren()) {
            if (!(child.getData() instanceof CFunction)) continue;
            MethodScriptCompiler.link(child, compilerErrors);
        }
    }

    private static void checkFunctionsExist(ParseTree tree, Set<ConfigCompileException> compilerErrors, Set<Class<? extends Environment.EnvironmentImpl>> envs) {
        Mixed mixed = tree.getData();
        if (mixed instanceof CFunction) {
            block7: {
                CFunction cFunc = (CFunction)mixed;
                if (cFunc.hasFunction()) {
                    FunctionBase func = cFunc.getCachedFunction(envs);
                    if (func == null) {
                        try {
                            func = FunctionList.getFunction(cFunc, envs);
                        }
                        catch (ConfigCompileException ex) {
                            compilerErrors.add(ex);
                            break block7;
                        }
                    }
                    if (func.getClass().getAnnotation(nolinking.class) != null) {
                        return;
                    }
                }
            }
            for (ParseTree child : tree.getChildren()) {
                MethodScriptCompiler.checkFunctionsExist(child, compilerErrors, envs);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void optimize(ParseTree tree, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Stack<List<Procedure>> procs, Set<ConfigCompileException> compilerErrors) {
        void var11_27;
        void var11_24;
        CFunction cFunction;
        Function func;
        if (tree.isOptimized()) {
            return;
        }
        if (!(tree.getData() instanceof CFunction)) {
            return;
        }
        if (tree.getData().val().equals("proc")) {
            procs.push(new ArrayList());
        }
        if ((func = (cFunction = (CFunction)tree.getData()).getCachedFunction(envs)) != null && func.getClass().getAnnotation(nolinking.class) != null) {
            return;
        }
        List<ParseTree> children = tree.getChildren();
        if (func instanceof Optimizable && ((Optimizable)func).optimizationOptions().contains(Optimizable.OptimizationOption.PRIORITY_OPTIMIZATION) && MethodScriptCompiler.isValidNumArgs(func, children.size())) {
            try {
                ((Optimizable)func).optimizeDynamic(tree.getTarget(), env, envs, children, tree.getFileOptions());
            }
            catch (ConfigCompileException ex) {
                compilerErrors.add(ex);
                return;
            }
            catch (ConfigCompileGroupException ex) {
                compilerErrors.addAll(ex.getList());
                return;
            }
            catch (ConfigRuntimeException ex) {
                compilerErrors.add(new ConfigCompileException(ex));
                return;
            }
        }
        boolean fullyStatic = true;
        boolean hasIVars = false;
        for (ParseTree parseTree : children) {
            Construct construct;
            Iterator<ParseTree> iterator;
            if (parseTree.getData() instanceof CFunction) {
                MethodScriptCompiler.optimize(parseTree, env, envs, procs, compilerErrors);
            }
            if ((iterator = parseTree.getData()) instanceof Construct && ((construct = (Construct)((Object)iterator)).isDynamic() || construct instanceof IVariable)) {
                fullyStatic = false;
            }
            if (!(parseTree.getData() instanceof IVariable)) continue;
            hasIVars = true;
        }
        tree.setOptimized(true);
        if (func == null) {
            Procedure p2 = null;
            block20: for (List list : procs) {
                for (Procedure pp : list) {
                    if (!pp.getName().equals(cFunction.val())) continue;
                    p2 = pp;
                    break block20;
                }
            }
            if (p2 != null) {
                try {
                    Mixed mixed = DataHandling.proc.optimizeProcedure(p2.getTarget(), p2, children);
                    if (mixed != null) {
                        tree.setData(mixed);
                        tree.removeChildren();
                        return;
                    }
                }
                catch (ConfigRuntimeException configRuntimeException) {
                    compilerErrors.add(new ConfigCompileException(configRuntimeException));
                }
            }
            return;
        }
        if (tree.getData().val().equals("proc")) {
            if (children.size() < 2) {
                compilerErrors.add(new ConfigCompileException("Incorrect number of arguments passed to proc", tree.getData().getTarget()));
                return;
            }
            procs.pop();
            try {
                ParseTree root = new ParseTree(new CFunction("__autoconcat__", Target.UNKNOWN), tree.getFileOptions());
                Script script = Script.GenerateScript(root, "*", null);
                if (env.hasEnv(GlobalEnv.class)) {
                    env.getEnv(GlobalEnv.class).SetFlag("no-check-undefined", true);
                }
                Procedure procedure = DataHandling.proc.getProcedure(tree.getTarget(), env, script, (ParseTree[])children.toArray(ParseTree[]::new));
                tree.getNodeModifiers().merge(children.get(0).getNodeModifiers());
                if (env.hasEnv(GlobalEnv.class)) {
                    env.getEnv(GlobalEnv.class).ClearFlag("no-check-undefined");
                }
                procs.peek().add(procedure);
            }
            catch (ConfigRuntimeException e) {
                compilerErrors.add(new ConfigCompileException(e));
            }
            catch (NullPointerException e) {
                return;
            }
        }
        String oldFunctionName = func.getName();
        EnumSet<Optimizable.OptimizationOption> enumSet = NO_OPTIMIZATIONS;
        if (func instanceof Optimizable) {
            Optimizable optimizable = (Optimizable)func;
            Set<Optimizable.OptimizationOption> set = optimizable.optimizationOptions();
        }
        if (var11_24.contains(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC) && MethodScriptCompiler.isValidNumArgs(func, tree.numberOfChildren())) {
            try {
                void var12_38;
                ParseTree parseTree;
                try {
                    for (ParseTree child : tree.getChildren()) {
                        if (!(child.getData() instanceof CSymbol)) continue;
                        throw new ConfigCompileException("Unexpected symbol", tree.getData().getTarget());
                    }
                    parseTree = ((Optimizable)func).optimizeDynamic(tree.getData().getTarget(), env, envs, tree.getChildren(), tree.getFileOptions());
                }
                catch (ConfigRuntimeException e) {
                    throw new ConfigCompileException(e);
                }
                catch (Error t) {
                    throw new Error("The linked Error had a code target on or around " + String.valueOf(tree.getData().getTarget()), t);
                }
                if (parseTree == Optimizable.PULL_ME_UP) {
                    if (tree.hasChildren()) {
                        ParseTree parseTree2 = tree.getChildAt(0);
                    } else {
                        Object var12_37 = null;
                    }
                }
                if (var12_38 == Optimizable.REMOVE_ME) {
                    tree.setData(new CFunction("p", Target.UNKNOWN));
                    tree.removeChildren();
                } else if (var12_38 != null) {
                    tree.setData(var12_38.getData());
                    tree.setOptimized(var12_38.isOptimized());
                    tree.setChildren(var12_38.getChildren());
                    Construct.SetWasIdentifierHelper(tree.getData(), var12_38.getData(), false);
                    MethodScriptCompiler.optimize(tree, env, envs, procs, compilerErrors);
                    tree.setOptimized(true);
                    if (var12_38.hasBeenMadeStatic()) {
                        fullyStatic = true;
                    }
                }
            }
            catch (ConfigCompileException configCompileException) {
                compilerErrors.add(configCompileException);
                EnumSet<Optimizable.OptimizationOption> enumSet2 = NO_OPTIMIZATIONS;
            }
            catch (ConfigCompileGroupException configCompileGroupException) {
                compilerErrors.addAll(configCompileGroupException.getList());
                EnumSet<Optimizable.OptimizationOption> enumSet3 = NO_OPTIMIZATIONS;
            }
        }
        if (!fullyStatic) {
            return;
        }
        if (func.preResolveVariables() && hasIVars) {
            return;
        }
        if (tree.getData().val().equals(oldFunctionName) && (var11_27.contains(Optimizable.OptimizationOption.OPTIMIZE_CONSTANT) || var11_27.contains(Optimizable.OptimizationOption.CONSTANT_OFFLINE))) {
            Mixed[] mixedArray = new Mixed[tree.getChildren().size()];
            for (int i = 0; i < tree.getChildren().size(); ++i) {
                mixedArray[i] = tree.getChildAt(i).getData();
            }
            try {
                try {
                    Mixed result;
                    if (var11_27.contains(Optimizable.OptimizationOption.CONSTANT_OFFLINE)) {
                        if (!MethodScriptCompiler.isValidNumArgs(func, tree.getChildren().size())) {
                            compilerErrors.add(new ConfigCompileException("Incorrect number of arguments passed to " + tree.getData().val(), tree.getData().getTarget()));
                            result = null;
                        } else {
                            result = Function.ExecuteFunction(func, tree.getData().getTarget(), env, mixedArray);
                        }
                    } else {
                        result = MethodScriptCompiler.isValidNumArgs(func, mixedArray.length) ? ((Optimizable)func).optimize(tree.getData().getTarget(), env, mixedArray) : null;
                    }
                    if (result != null) {
                        Construct.SetWasIdentifierHelper(tree.getData(), result, false);
                        tree.setData(result);
                        tree.removeChildren();
                    }
                }
                catch (ConfigRuntimeException e) {
                    throw new ConfigCompileException(e);
                }
            }
            catch (ConfigCompileException ex) {
                compilerErrors.add(ex);
            }
        }
    }

    private static boolean eliminateDeadCode(ParseTree tree, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs) {
        if (tree.getData() instanceof CFunction && ((CFunction)tree.getData()).hasFunction()) {
            List<Boolean> branches;
            Function f = ((CFunction)tree.getData()).getCachedFunction(envs);
            if (f == null) {
                return false;
            }
            List<ParseTree> children = tree.getChildren();
            if (f instanceof BranchStatement) {
                BranchStatement branchStatement = (BranchStatement)((Object)f);
                branches = branchStatement.isBranch(children);
                if (branches.size() != children.size()) {
                    if (!MethodScriptCompiler.isValidNumArgs(f, children.size())) {
                        return false;
                    }
                    throw new Error(f.getName() + " does not properly implement isBranch. It does not return a value with the same count as the actual children. Children: " + children.size() + "; Branches: " + branches.size() + "; Code target causing this: " + String.valueOf(tree.getTarget()));
                }
            } else {
                branches = children.stream().map(child -> false).toList();
            }
            boolean doDeletion = false;
            for (int m = 0; m < children.size(); ++m) {
                ParseTree child2;
                Mixed mixed;
                boolean isBranch = branches.get(m);
                if (doDeletion) {
                    if (isBranch) {
                        doDeletion = false;
                    } else {
                        env.getEnv(CompilerEnvironment.class).addCompilerWarning(tree.getFileOptions(), new CompilerWarning("Unreachable code. Consider removing this code.", children.get(m).getTarget(), FileOptions.SuppressWarning.UnreachableCode));
                        children.remove(m);
                        --m;
                        continue;
                    }
                }
                if ((mixed = (child2 = children.get(m)).getData()) instanceof CFunction) {
                    Function c;
                    CFunction cFunction = (CFunction)mixed;
                    if (!cFunction.hasFunction() || (c = cFunction.getCachedFunction(envs)) == null) continue;
                    Set<Optimizable.OptimizationOption> options = NO_OPTIMIZATIONS;
                    if (c instanceof Optimizable) {
                        Optimizable optimizable = (Optimizable)c;
                        options = optimizable.optimizationOptions();
                    }
                    doDeletion = options.contains(Optimizable.OptimizationOption.TERMINAL);
                    boolean subDoDelete = MethodScriptCompiler.eliminateDeadCode(child2, env, envs);
                    if (subDoDelete) {
                        doDeletion = true;
                    }
                }
                if (!isBranch) continue;
                doDeletion = false;
            }
            return doDeletion;
        }
        return false;
    }

    private static void processKeywords(ParseTree tree, Environment env, Set<ConfigCompileException> compileErrors) {
        List<ParseTree> children = tree.getChildren();
        boolean processSubChildren = true;
        for (int i = 0; i < children.size(); ++i) {
            Keyword keyword2;
            Mixed m;
            ParseTree node = children.get(i);
            if (processSubChildren) {
                MethodScriptCompiler.processKeywords(node, env, compileErrors);
            }
            if (!((m = node.getData()) instanceof CKeyword) && (!(m instanceof CLabel) || !(((CLabel)m).cVal() instanceof CKeyword)) && !(m instanceof CFunction) || (keyword2 = KeywordList.getKeywordByName(m.val())) == null) continue;
            if (processSubChildren) {
                for (int j = i + 1; j < children.size(); ++j) {
                    MethodScriptCompiler.processKeywords(children.get(j), env, compileErrors);
                }
                processSubChildren = false;
            }
            try {
                i = keyword2.process(children, i);
                continue;
            }
            catch (ConfigCompileException ex) {
                env.getEnv(CompilerEnvironment.class).potentialKeywordCompileErrors.put(m.getTarget(), ex);
            }
        }
    }

    private static void processLateKeywords(ParseTree tree, Environment env, Set<ConfigCompileException> compileErrors) {
        List<ParseTree> children = tree.getChildren();
        block7: for (int i = 0; i < children.size(); ++i) {
            LateBindingKeyword keyword2;
            ParseTree node = children.get(i);
            MethodScriptCompiler.processLateKeywords(node, env, compileErrors);
            Mixed m = node.getData();
            if (!(m instanceof CKeyword) || (keyword2 = KeywordList.getLateBindingKeywordByName(m.val())) == null) continue;
            try {
                ParseTree lhs = null;
                if (i != 0) {
                    lhs = children.get(i - 1);
                }
                ParseTree rhs = null;
                if (i + 1 < children.size()) {
                    rhs = children.get(i + 1);
                }
                switch (keyword2.getAssociativity()) {
                    case LEFT: {
                        if (lhs == null && !keyword2.allowEmptyValue()) {
                            throw new ConfigCompileException("Unexpected keyword " + keyword2.getName(), node.getTarget());
                        }
                        ParseTree replacement = keyword2.processLeftAssociative(node.getTarget(), node.getFileOptions(), lhs);
                        children.set(i, replacement);
                        if (lhs == null) continue block7;
                        children.remove(i - 1);
                        --i;
                        break;
                    }
                    case RIGHT: {
                        if (rhs == null && !keyword2.allowEmptyValue()) {
                            throw new ConfigCompileException("Unexpected keyword " + keyword2.getName(), node.getTarget());
                        }
                        ParseTree replacement = keyword2.processRightAssociative(node.getTarget(), node.getFileOptions(), rhs);
                        children.set(i, replacement);
                        if (rhs == null) continue block7;
                        children.remove(i + 1);
                        break;
                    }
                    case BOTH: {
                        if (!(keyword2.allowEmptyValue() || i != 0 && i + 1 < children.size())) {
                            throw new ConfigCompileException("Unexpected keyword " + keyword2.getName(), node.getTarget());
                        }
                        ParseTree replacement = keyword2.processBothAssociative(node.getTarget(), node.getFileOptions(), lhs, rhs);
                        children.set(i, replacement);
                        if (rhs != null) {
                            children.remove(i + 1);
                            --i;
                        }
                        if (lhs == null) break;
                        children.remove(i - 1);
                    }
                }
                continue;
            }
            catch (ConfigCompileException ex) {
                env.getEnv(CompilerEnvironment.class).potentialKeywordCompileErrors.put(m.getTarget(), ex);
            }
        }
    }

    private static void processEarlyKeywords(TokenStream stream, Environment env, Set<ConfigCompileException> compileErrors) {
        ListIterator it = stream.listIterator();
        while (it.hasNext()) {
            int newInd;
            EarlyBindingKeyword keyword2;
            int ind = it.nextIndex();
            Token token = (Token)it.next();
            if (token.type != Token.TType.KEYWORD && token.type != Token.TType.FUNC_NAME || (keyword2 = KeywordList.getEarlyBindingKeywordByName(token.val())) == null) continue;
            try {
                newInd = keyword2.process(stream, env, ind);
            }
            catch (ConfigCompileException ex) {
                compileErrors.add(ex);
                continue;
            }
            if (newInd >= stream.size()) break;
            it = stream.listIterator(newInd + 1);
        }
    }

    @Deprecated
    private static void checkUnhandledCompilerConstructs(ParseTree tree, Environment env, Set<ConfigCompileException> compilerErrors) {
        for (ParseTree node : tree.getAllNodes()) {
            Mixed m = node.getData();
            if (!(m instanceof CKeyword)) continue;
            ConfigCompileException ex = env.getEnv(CompilerEnvironment.class).potentialKeywordCompileErrors.get(m.getTarget());
            compilerErrors.add(ex != null ? ex : new ConfigCompileException("Unexpected keyword: " + m.val(), m.getTarget()));
        }
    }

    private static boolean isValidNumArgs(Function function, int numArgs) {
        Integer[] integerArray = function.numArgs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int allowedNumArgs = integerArray[i];
            if (allowedNumArgs != Integer.MAX_VALUE && allowedNumArgs != numArgs) continue;
            return true;
        }
        return false;
    }

    public static Mixed execute(String script, File file, boolean inPureMScript, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, MethodScriptComplete done, Script s, List<Variable> vars) throws ConfigCompileException, ConfigCompileGroupException {
        return MethodScriptCompiler.execute(MethodScriptCompiler.compile(MethodScriptCompiler.lex(script, env, file, inPureMScript), env, envs), env, done, s, vars);
    }

    public static Mixed execute(ParseTree root, Environment env, MethodScriptComplete done, Script script) {
        return MethodScriptCompiler.execute(root, env, done, script, null);
    }

    public static Mixed execute(ParseTree root, Environment env, MethodScriptComplete done, Script script, List<Variable> vars) {
        if (root == null) {
            return CVoid.VOID;
        }
        if (script == null) {
            script = new Script(null, null, env.getEnv(GlobalEnv.class).GetLabel(), env.getEnvClasses(), root.getFileOptions(), null);
        }
        if (vars != null) {
            HashMap<String, Variable> varMap = new HashMap<String, Variable>();
            for (Variable v : vars) {
                varMap.put(v.getVariableName(), v);
            }
            for (Mixed tempNode : root.getAllData()) {
                if (!(tempNode instanceof Variable)) continue;
                Variable variable = (Variable)tempNode;
                Variable vv = (Variable)varMap.get(variable.getVariableName());
                if (vv != null) {
                    variable.setVal(vv.getDefault());
                    continue;
                }
                variable.setVal("");
            }
        }
        StringBuilder b = new StringBuilder();
        Mixed returnable = null;
        for (ParseTree gg : root.getChildren()) {
            String ret;
            Mixed retc = script.eval(gg, env);
            if (root.numberOfChildren() == 1) {
                returnable = retc;
                if (done == null) {
                    return returnable;
                }
            }
            if ((ret = retc.val()).trim().isEmpty()) continue;
            b.append(ret).append(" ");
        }
        if (done != null) {
            done.done(b.toString().trim());
        }
        if (returnable != null) {
            return returnable;
        }
        return Static.resolveConstruct(b.toString().trim(), Target.UNKNOWN);
    }

    private static void validateTerminatedBidiSequence(String s, Target t) throws ConfigCompileException {
        int pdfStack = 0;
        int pdiStack = 0;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (PDF_STACK.contains(c)) {
                ++pdfStack;
            }
            if (c.charValue() == '\u202c') {
                --pdfStack;
            }
            if (PDI_STACK.contains(c)) {
                ++pdiStack;
            }
            if (c.charValue() != '\u2069') continue;
            --pdiStack;
        }
        if (pdfStack != 0 || pdiStack != 0) {
            throw new ConfigCompileException("Incorrectly formatted unicode sequence", t);
        }
    }
}

