/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs.generics;

import com.laytonsmith.PureUtilities.Either;
import com.laytonsmith.PureUtilities.Pair;
import com.laytonsmith.core.constructs.Auto;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.LeftHandSideType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.generics.ConstraintLocation;
import com.laytonsmith.core.constructs.generics.ConstraintValidator;
import com.laytonsmith.core.constructs.generics.Constraints;
import com.laytonsmith.core.constructs.generics.GenericParameters;
import com.laytonsmith.core.constructs.generics.LeftHandGenericUse;
import com.laytonsmith.core.constructs.generics.LeftHandGenericUseParameter;
import com.laytonsmith.core.constructs.generics.constraints.ExactTypeConstraint;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREGenericConstraintException;
import java.util.Objects;

public class ConcreteGenericParameter {
    private final CClassType type;
    private final LeftHandGenericUse lhgu;
    private final Environment env;
    public static final ConcreteGenericParameter AUTO = ConcreteGenericParameter.fromNativeType(Auto.TYPE, null);

    public ConcreteGenericParameter(CClassType type, LeftHandGenericUse lhgu, Target t, Environment env) {
        if (type == null && lhgu != null) {
            throw new CREGenericConstraintException("\"none\" type cannot have generic parameters.", t);
        }
        if (type != null && lhgu != null && (type.getGenericDeclaration() == null || type.getGenericDeclaration().getParameterCount() < 1)) {
            throw new CREGenericConstraintException(type.getSimpleName() + " cannot contain generic parameters.", t);
        }
        if (type != null && lhgu != null) {
            ConstraintValidator.ValidateLHS(t, type, lhgu, env);
        }
        this.type = type;
        if (type != null && type.getGenericDeclaration() != null && type.getTypeGenericParameters() == null && lhgu == null) {
            GenericParameters.GenericParametersBuilder builder = GenericParameters.emptyBuilder(type);
            for (Constraints c : type.getGenericDeclaration().getConstraints()) {
                builder.addParameter(c.convertFromNull(t).getType());
            }
            lhgu = builder.build(t, env).toLeftHandEquivalent(type, env);
        }
        this.lhgu = lhgu;
        this.env = env;
    }

    public static ConcreteGenericParameter fromNativeType(CClassType nativeType, LeftHandGenericUse nativeLHGU) {
        return new ConcreteGenericParameter(nativeType, nativeLHGU, Target.UNKNOWN, null);
    }

    public CClassType getType() {
        return this.type;
    }

    public LeftHandGenericUse getLeftHandGenericUse() {
        if (this.type.getTypeGenericParameters() != null) {
            return this.type.getTypeGenericParameters().toLeftHandGenericUse();
        }
        return this.lhgu;
    }

    public Pair<CClassType, LeftHandGenericUse> getAsPair() {
        return new Pair<CClassType, LeftHandGenericUse>(this.type, this.lhgu);
    }

    public LeftHandSideType asLeftHandSideType() {
        return LeftHandSideType.fromCClassType(this, Target.UNKNOWN, this.env);
    }

    public LeftHandGenericUseParameter asLeftHandGenericUseParameter() {
        Constraints constraints = new Constraints(Target.UNKNOWN, ConstraintLocation.RHS, new ExactTypeConstraint(Target.UNKNOWN, this.asLeftHandSideType()));
        return new LeftHandGenericUseParameter(Either.left(constraints));
    }

    public String toString() {
        String typeString = "none";
        if (this.type != null) {
            typeString = this.type.toString();
        }
        return typeString + (String)(this.lhgu == null ? "" : "<" + this.lhgu.toString() + ">");
    }

    public String toSimpleString() {
        String typeString = "none";
        if (this.type != null) {
            typeString = this.type.getSimpleName();
        }
        return typeString + (String)(this.lhgu == null ? "" : "<" + this.lhgu.toSimpleString() + ">");
    }

    public int hashCode() {
        int hash2 = 7;
        return hash2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConcreteGenericParameter other = (ConcreteGenericParameter)obj;
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        return Objects.equals(this.lhgu, other.lhgu);
    }
}

